/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-17 10:12:54
 * @LastEditTime: 2021-03-05 11:05:29
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var financeIndexClasses = new FinanceIndexClasses();
    var financeIndexs = new FinanceIndexs();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var mIndexClassCodes = [];
    var mIndexCodes = [];
    var classNames = [];
    var currentTableBodyData = [];
    var mIndexClassCode = null;

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadFinanceIndexClasses();
        treeEvent();
        bindTableEvent();
    }

    function getAndLoadFinanceIndexClasses(){
        var succ = function(){
            $Utils.loading.close();
            loadFinanceIndexClassesMenu();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取财务指标分类列表",errorStatus,msg);
        };
        financeIndexClasses.getItems(true,succ,fail);
    }

    function loadFinanceIndexClassesMenu(){
        $(".report-folder-tree > ul").html("");
        classNames = [];
        for(var i = 0; i < financeIndexClasses.count; i++){
            var str = "<li class='folder folder-hide' data-indexclasscode="+financeIndexClasses.item(i).indexClassCode+"><div title='("+financeIndexClasses.item(i).indexClassCode + ") " + financeIndexClasses.item(i).indexClassName+"'>("+ financeIndexClasses.item(i).indexClassCode + ") " + financeIndexClasses.item(i).indexClassName+"</div><ul></ul></li>";
            $(".report-folder-tree > ul").append(str);
            mIndexClassCodes.push(financeIndexClasses.item(i).indexClassCode);
            classNames.push(financeIndexClasses.item(i).indexClassName);
        }
        $(".report-folder-tree > ul > li:first-child > div").trigger("click");
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "indexCode", title: "指标编码", width: 80, sort: true},
                {field: "indexName", title: "指标名称", width: 150, sort: true, templet: function(d){
                    if(d.indexName){
                        return (d.indexName).replace(new RegExp(" ", "gm"), "&nbsp;");
                    }
                }},
                {field: "expression", title: "表达式"}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function treeEvent(){
        
        $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);

        $(".report-folder-tree > ul").on("click","div",function(){
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");
            $Utils.loading.open();
            loadFinanceIndexClasses($(this).parent("li").attr("data-indexclasscode"));
        });
    }

    function loadFinanceIndexClasses(indexClassCode){
        mIndexClassCode = indexClassCode;
        getAndLoadFinanceIndex(indexClassCode);
    }

    function getAndLoadFinanceIndex(indexClassCode){
        var succ = function(){
            $Utils.loading.close();
            loadFinanceIndex(indexClassCode);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取财务指标列表",errorStatus,msg);
        };
        financeIndexs.getItems(true,succ,fail);
    }

    function loadFinanceIndex(indexClassCode){
        mTableBodyData = setTableBody(indexClassCode);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
    }

    function setTableBody(indexClassCode){
        var reportsTableBody = [];
        mIndexCodes = [];
        for(var i = 0; i < financeIndexs.count; i++){
            if(financeIndexs.item(i).indexClassCode == indexClassCode){
                var tempObj = {};
                for(var key in financeIndexs.item(i)){
                    if(typeof financeIndexs.item(i)[key] === "function"){ continue;}
                    tempObj[key] = financeIndexs.item(i)[key];
                }
                reportsTableBody.push(tempObj);
                mIndexCodes.push(tempObj.indexCode);
            }
        }
        return reportsTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        $Utils.loading.close();
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindTableEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type, field = obj.field, data = mSortBodyData, thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
			getAndLoadFinanceIndex(mIndexClassCode);
        });

        $(".add-class").click(function(){
            var financeIndexClass = new FinanceIndexClass();
            getAndLoadClassForm(0,financeIndexClass);
        });

        $(".edit-class").click(function(){
            var financeIndexClass = financeIndexClasses.item($(".finance-class").find(".click-folder").attr("data-indexclasscode"));
            getAndLoadClassForm(1,financeIndexClass);
        });

        $(".delete-class").click(function(){
            if($(".finance-class").find(".click-folder").length){
                var indexClassCode = $(".finance-class").find(".click-folder").attr("data-indexclasscode");
                if(financeIndexClasses.item(indexClassCode).financeIndices.count){
                    layer.msg("不能删除含有指标的分类。",{icon: 2});
                }else{
                    layer.open({
                        type: 0,
                        title: "删除分类",
                        closeBtn: 1,
                        shadeClose: true,
                        resize: false,
                        area: ["480px","270px"],
                        skin: "delete-window",
                        content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+financeIndexClasses.item(indexClassCode).indexClassName+" ？</div></div>",
                        btn: ["是","否"],
                        yes: function(index,layero){
                            layer.close(index);
                            $Utils.loading.open();
                            deleteClass(indexClassCode);
                        }
                    });
                }
            }
        });

        $(".add-index").click(function(){
            var indexClassCode = $(".finance-class").find(".click-folder").attr("data-indexclasscode");
            if(indexClassCode){
                var financeIndex = new FinanceIndex();
                getAndLoadIndexForm(0,financeIndex,indexClassCode);
            }else{
                layer.msg("请先创建指标分类。",{icon:2});
            }
        });

        $(".edit-index").click(function(){
            if(table.checkStatus('objectList').data.length){
                var indexClassCode = $(".finance-class").find(".click-folder").attr("data-indexclasscode");
                var financeIndex = financeIndexs.item(table.checkStatus('objectList').data[0].indexID);
                getAndLoadIndexForm(1,financeIndex,indexClassCode);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".delete-index").click(function(){
            if(table.checkStatus('objectList').data.length){
                var indexClassCode = $(".finance-class").find(".click-folder").attr("data-indexclasscode");
                var indexID = table.checkStatus('objectList').data[0].indexID;
                layer.open({
                    type: 0,
                    title: "删除指标",
                    closeBtn: 1,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].indexName+" ？</div></div>",
                    btn: ["是","否"],
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteIndex(indexClassCode,indexID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].indexCode.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].indexName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].expression.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function deleteClass(indexClassCode){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            getAndLoadFinanceIndexClasses();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除财务指标分类",errorStatus,msg);
		};
		financeIndexClasses.deleteItem(indexClassCode,true,succ,fail);
    }

    function deleteIndex(indexClassCode,indexID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            loadFinanceIndexClasses(indexClassCode);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除财务指标",errorStatus,msg);
        };
        financeIndexClasses.item(indexClassCode).financeIndices.deleteItem(indexID,true,succ,fail)
    }

    function getAndLoadClassForm(operationType,financeIndexClass){
        $.ajax({
            url: "html/iDataOrganize/financeIndex/financeIndexClass.html",
            type: 'GET',
            success: function(data){
                loadClassForm(operationType,financeIndexClass,data);
            }
        });
    }

    function loadClassForm(operationType,financeIndexClass,strHtml){
        layer.open({
            type: 1,
            title: [operationType?financeIndexClass.indexClassName+" 属性":"新增财务指标分类","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initClassForm(index, financeIndexClass, operationType, mIndexClassCodes,classNames,addSubmitClass,editSubmitClass);
            }
        });
    }

    function getAndLoadIndexForm(operationType,financeIndex,indexClassCode){
        $.ajax({
            url: "html/iDataOrganize/financeIndex/financeIndex.html",
            type: 'GET',
            success: function(data){
                loadIndexForm(operationType,financeIndex,indexClassCode,data);
            }
        });
    }

    function loadIndexForm(operationType,financeIndex,indexClassCode,strHtml){
        layer.open({
            type: 1,
            title: [operationType?financeIndex.indexName+" 属性":"新增财务指标","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                if(operationType == 1){
                    mIndexCodes.splice(mIndexCodes.indexOf(financeIndex.indexCode),1);
                }
                initIndexForm(index,financeIndex,operationType,mIndexCodes,indexClassCode,addSubmitIndex,editSubmitIndex);
            }
        });
    }

    var addSubmitClass = function(financeIndexClass,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadFinanceIndexClasses();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增财务指标分类",errorStatus,msg);
        };
        
		financeIndexClasses.addItem(financeIndexClass,true,succ,fail);
    };

    var editSubmitClass = function(financeIndexClass,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            $(".finance-class > ul li").each(function(){
                if($(this).attr("data-indexclasscode") == financeIndexClass.indexClassCode){
                    $(this).find("div").attr("title","("+financeIndexClass.indexClassCode+") "+financeIndexClass.indexClassName);
                    $(this).find("div").text("("+financeIndexClass.indexClassCode+") "+financeIndexClass.indexClassName);
                }
            });
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改财务指标分类",errorStatus,msg);
        };

		financeIndexClasses.editItem(financeIndexClass,true,succ,fail);
    };

    var addSubmitIndex = function(financeIndex,indexClassCode,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
			getAndLoadFinanceIndex(mIndexClassCode);
            // getAndLoadFinanceIndexClasses();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增财务指标",errorStatus,msg);
        };
		financeIndexClasses.item(indexClassCode).financeIndices.addItem(financeIndex,true,succ,fail);
    };

    var editSubmitIndex = function(financeIndex,indexClassCode,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            editListItem(financeIndex);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改财务指标",errorStatus,msg);
        };

		financeIndexClasses.item(indexClassCode).financeIndices.editItem(financeIndex,true,succ,fail);
    };
    
    function editListItem(financeIndex){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].indexID == financeIndex.indexID){
                for(var key in currentTableBodyData[i]){
                    currentTableBodyData[i][key] = financeIndex[key];
                    tempTableBody[i][key] = financeIndex[key];
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("objectList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();