/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-17 10:33:19
 * @LastEditTime: 2021-03-05 17:28:32
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var mOperationType = null,mFinanceIndex = null,formAddSubmit = null,formEditSubmit = null,layerIndex = null, mIndexClassCode = null, mIndexCode = null;

    window.initIndexForm = function(index,financeIndex,operationType,indexCodes,indexClassCode,addSubmitIndex,editSubmitIndex){
        mOperationType = operationType;
        mFinanceIndex = financeIndex;
        layerIndex = index;
        formAddSubmit = addSubmitIndex;
        formEditSubmit = editSubmitIndex;
        mIndexClassCode = indexClassCode;
        mIndexCode = indexCodes;
        initForm();
    }

    function initForm(){
        $(".relation-model-window input[name=indexCode]").focus();
        if(mOperationType == 1){
            initEditFinanceIndexForm();
        }

        bindElementEvent();
    }

    function initEditFinanceIndexForm(){
        form.val("formWindow",{
            "indexCode": mFinanceIndex.indexCode,
            "indexName": mFinanceIndex.indexName,
            "showName": mFinanceIndex.showName,
            "expression": mFinanceIndex.expression,
            "finalExpression": mFinanceIndex.finalExpression
        });
    }

    function bindElementEvent(){

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        form.on('submit(formSubmit)', function(data){
            if(mIndexCode.indexOf(data.field.indexCode) != -1){
                layer.msg("指标编号不能重复。",{icon:2});
                return false;
            }
            if(mOperationType == 1){
                if(changed(data)){
                    $Utils.loading.open();
                    var financeIndex = new FinanceIndex();
                    financeIndex.init(JSON.parse(JSON.stringify(mFinanceIndex)));
                    setFinanceIndex(data, financeIndex);
                    formEditSubmit(financeIndex,mIndexClassCode,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                $Utils.loading.open();
                setFinanceIndex(data, mFinanceIndex);
                formAddSubmit(mFinanceIndex,mIndexClassCode,layerIndex);
            }
            return false;
        });

        $(".select-account").click(function(){
            getAndLoadExpressionSelectForm();
        });
    }

    function setFinanceIndex(data,financeIndex){
        financeIndex.indexCode = data.field.indexCode;
        financeIndex.indexName = data.field.indexName;
        financeIndex.showName = data.field.showName;
        financeIndex.expression = data.field.expression;
        financeIndex.finalExpression = data.field.finalExpression;
        if(mOperationType == 0){
            financeIndex.indexClassCode = mIndexClassCode;
        }
    }

    function changed(data){
        if(mFinanceIndex.indexCode != data.field.indexCode){
            return true
        }
        if(mFinanceIndex.indexName != data.field.indexName){
            return true
        }
        if(mFinanceIndex.showName != data.field.showName){
            return true
        }
        if(mFinanceIndex.expression != data.field.expression){
            return true
        }
        return false;
    }

    function getAndLoadExpressionSelectForm(){
        $.ajax({
            url: "html/iDataOrganize/financeIndex/selectExpression.html",
            type: 'GET',
            success: function(data){
                loadExpressionSelectForm(data);
            }
        });
    }

    function loadExpressionSelectForm(strHtml){
        layer.open({
            type: 1,
            title: ["编辑表达式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["720px","540px"],
            content: strHtml,
            success: function(layero,index){
                initExpressionForm($("#expression").val(),addItemToExpression,index);
            }
        });
    }

    var addItemToExpression = function(expressionStr,finalExpressionStr,index){
        // var itemNamesArr = setArr(str);
        // var finalExpressionStr = changeItemName(itemNamesArr);
        $("#expression").val(expressionStr);
        $("#finalExpression").val(finalExpressionStr);
        layer.close(index);
    }

}();