/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-17 10:45:23
 * @LastEditTime: 2021-03-05 11:04:49
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var mOperationType = null,mFinanceIndexClass = null,formAddSubmit = null,formEditSubmit = null,layerIndex = null, mIndexClassCodes = null, mClassNames = null;

    window.initClassForm = function (index, financeIndexClass, operationType, indexClassCodes, classNames,addSubmitClass,editSubmitClass){
        mOperationType = operationType;
        mFinanceIndexClass = financeIndexClass;
        layerIndex = index;
        formAddSubmit = addSubmitClass;
        formEditSubmit = editSubmitClass;
        mIndexClassCodes = indexClassCodes;
        mClassNames = classNames;
        if(mOperationType == 0){
            $("input[name=indexClassCode]").attr("disabled",false);
            $(".relation-model-window input[name=indexClassCode]").focus();
        }else if(mOperationType == 1){
            initEditFinanceIndexClassForm(financeIndexClass);
            $(".relation-model-window textarea[name=indexClassName]").focus();
        }

        bindElementEvent();
    }

    function initEditFinanceIndexClassForm(financeIndexClass){
        $("input[name=indexClassCode]").attr("disabled",true);
        form.val("formWindow",{
            "indexClassCode": financeIndexClass.indexClassCode,
            "indexClassName": financeIndexClass.indexClassName,
        });
    }

    function bindElementEvent(){

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        form.on('submit(formSubmit)', function(data){
            if(mOperationType == 1){
                if (validate(data)) {
                    if (changed(data)) {
                        $Utils.loading.open();
                        var financeIndexClass = new FinanceIndexClass();
                        financeIndexClass.init(JSON.parse(JSON.stringify(mFinanceIndexClass)));
                        setFinanceIndexClass(data, financeIndexClass);
                        formEditSubmit(financeIndexClass, layerIndex);
                    } else {
                        $Utils.loading.close();
                        layer.close(layerIndex);
                    }
                }
            } else if (mOperationType == 0) {
                $Utils.loading.open();
                setFinanceIndexClass(data, mFinanceIndexClass);
                formAddSubmit(mFinanceIndexClass,layerIndex);
            }
            return false;
        });
    }

    function setFinanceIndexClass(data, financeIndexClass){
        financeIndexClass.indexClassName = data.field.indexClassName;
        if(mOperationType == 0){
            financeIndexClass.indexClassCode = data.field.indexClassCode;
        }
        var tempArr = [];
        for (var i = 0; i < financeIndexClass.financeIndices.count; i++){
            tempArr.push(financeIndexClass.financeIndices.item(i));
        }
        financeIndexClass.financeIndices = tempArr;
    }

    function validate(data){
        if ($Utils.judgeRepeat(mClassNames, data.field.indexClassName)) {
            layer.msg("指标分类名称不能重复。", { icon: 2 });
            return false;
        }
        return true;
    }

    function changed(data){
        if(mFinanceIndexClass.indexClassName != data.field.indexClassName){
            return true
        }
        return false;
    }

}();