!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var uploadExcelTemplates = new UploadExcelTemplates();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){  
        initExcelTemplatesTableHead();
        getAndLoadExcelTemplatesTableBody();
    }

    function initExcelTemplatesTableHead(){
        var excelTemplatesTableHead = [
            [
                {type: "radio"},
                {field: "templateName", title: "名称", sort: true},
                {field: "createUserName",title: "上传者", sort: true},
                {field: "createDate",title: "上传时间", sort: true, width: 130, templet: function(d){
                    if(d.createDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: excelTemplatesTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadExcelTemplatesTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadExcelTemplatesTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Excel上传模版列表",errorStatus,msg);
		};
		uploadExcelTemplates.getItems(4,true,succ,fail);
    }
    

    function setTableBody(){
        var excelTemplatesTableBody = [];
        for(var i = 0; i < uploadExcelTemplates.count; i++){
            var tempObj = {};
            for(var key in uploadExcelTemplates.item(i)){
                if(typeof uploadExcelTemplates.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                // }else{
                    tempObj[key] = uploadExcelTemplates.item(i)[key];
                // }
            }
            excelTemplatesTableBody.push(tempObj);
        }
        return excelTemplatesTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadExcelTemplatesTableBody(data,obj);
            }
        });
    }

    function loadExcelTemplatesTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".add-excel").click(function(){
        // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
        //     layer.open({
        //         type: 0,
        //         title: "上传Excel",
        //         closeBtn: 1,
        //         shadeClose: true,
        //         resize: false,
        //         area: ["480px","270px"],
        //         skin: "delete-window",
        //         content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>因IE浏览器不支持某些方法，上传Excel请使用Chrome、Firefox、360（急速模式）等浏览器。</div></div>",
        //         btn: ["确定"]
        //     });
        // }else{
            getAndLoadExcelUploadForm();
        // }
    });

    $(".edit-excel").click(function(){
        if(table.checkStatus('dataList').data.length){
            $Utils.loading.open();
            var uploadExcelTemplate = uploadExcelTemplates.item(table.checkStatus('dataList').data[0].templateID);
            getAndLoadEditUploadExcelTemplateForm(uploadExcelTemplate);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-excel").click(function(){
        if(table.checkStatus('dataList').data.length){
            deleteWindow();
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadExcelTemplatesTableBody();
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].templateName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadExcelUploadForm(){
        $.ajax({
            url: "html/iDataOrganize/excelTemplate/excelTemplate.html",
            type: 'GET',
            success: function(data){
                loadExcelUploadForm(data);
            }
        });
    }

    function loadExcelUploadForm(strHtml){
        layer.open({
            type: 1,
            title: ["Excel模版上传向导","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initUploadExcel(addSubmit,index);
            }
        });
    }

    function getAndLoadEditUploadExcelTemplateForm(uploadExcelTemplate){
        $.ajax({
            url: "html/iDataOrganize/excelTemplate/editExcelTemplate.html",
            type: 'GET',
            success: function(data){
                loadEditUploadExcelTemplateForm(data,uploadExcelTemplate);
            }
        });
    }

    function loadEditUploadExcelTemplateForm(strHtml,uploadExcelTemplate){
        layer.open({
            type: 1,
            title: [uploadExcelTemplate.templateName + " 属性","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["800px","600px"],
            content: strHtml,
            success: function(layero,index){
                initEditUploadExcelTemplate(index,uploadExcelTemplate,editSubmit);
            }
        });
    }

    function deleteWindow(){
        layer.open({
            type: 0,
            title: "删除Excel模版",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('dataList').data[0].templateName+" ？</div></div>",
            btn: ["是","否"],
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteExcelFile(table.checkStatus('dataList').data[0].templateID);
            }
        });
    }

    function deleteExcelFile(templateID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadExcelTemplatesTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除Excel模版",errorStatus,msg);
		};
		uploadExcelTemplates.deleteItem(templateID,true,succ,fail);
    }

    var addSubmit = function(excel,uploadExcelTemplate,index){
        $Utils.loading.open();
        var file = new FormData();
        file.append("file", excel[0]);
        var succ = function(data){
            addExcelSubmit(file,data,index);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增Excel文件对象",errorStatus,msg);
        };
		uploadExcelTemplates.addItem(uploadExcelTemplate,true,succ,fail);
    };

    function addExcelSubmit(file,templateID,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadExcelTemplatesTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("上传Excel文件",errorStatus,msg);
        };
		uploadExcelTemplates.addExcel(file,templateID,true,succ,fail);
    }

    var editSubmit = function(uploadExcelTemplate,index){
        var succ = function(){
            layer.close(index);
            getAndLoadEditList(uploadExcelTemplate);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改业务模型",errorStatus,msg);
        };
        
        uploadExcelTemplates.editItem(uploadExcelTemplate,true,succ,fail);
    };

    function getAndLoadEditList(editUploadExcelTemplate){
        var uploadExcelTemplate = new UploadExcelTemplate();
        var succ = function(){
            $Utils.loading.close();
            editListItem(uploadExcelTemplate);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+editUploadExcelTemplate.templateName+" 的属性",errorStatus,msg);
        };
        uploadExcelTemplate.initByTemplateID(editUploadExcelTemplate.templateID,true,succ,fail);
    }

    function editListItem(uploadExcelTemplate){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].templateID == uploadExcelTemplate.templateID){
                for(var key in currentTableBodyData[i]){
                    if(key == "createDate"){
                        currentTableBodyData[i][key] = uploadExcelTemplate[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplate[key])):"";
                        tempTableBody[i][key] = uploadExcelTemplate[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplate[key])):"";

                    }else if(key == "lastModifyDate"){
                        currentTableBodyData[i][key] = uploadExcelTemplate[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplate[key])):"";
                        tempTableBody[i][key] = uploadExcelTemplate[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplate[key])):"";
                    }else{
                        currentTableBodyData[i][key] = uploadExcelTemplate[key];
                        tempTableBody[i][key] = uploadExcelTemplate[key];
                    }
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("dataList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();