function UploadExcelTemplate() {
    var me = this;

    this.templateID = null;
    this.organizationID = null;
    this.templateName = null;
    this.templateURL = null;
    this.excelFileName = null;
    this.sheetName = null;
    this.range = null;
    this.rangeType = null;
    this.columns = null;
    this.targetTable = null;
    this.uploadMethod = null;
    this.mappings = new Mappings;
    this.identity = null;
    this.createUserID = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyDate = null;

    this.init = function (options) {
        for (var key in options) {
            if(key == "mappings"){
                this[key].setMappings(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
    this.initByTemplateID = function(templateID,asyncOrSync, succ, fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "/" + templateID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.uploadExcelData = function(templateData,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "/" + this.templateID + "/excelDatas";
        var obj = JSON.stringify(templateData);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback, 1);
    };
}

function UploadExcelTemplates() {
    var me = this;
    this.aryUploadExcelTemplates = [];
    this.dicUploadExcelTemplates = {};

    this.add = function (uploadExcelTemplate) {
        this.aryUploadExcelTemplates.push(uploadExcelTemplate);
        this.dicUploadExcelTemplates[uploadExcelTemplate.templateID] = uploadExcelTemplate;
        this.count = this.aryUploadExcelTemplates.length;
    };
    this.remove = function (uploadExcelTemplate) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryUploadExcelTemplates[i].templateID == uploadExcelTemplate.templateID) {
                k = i;
                break;
            }
        }
        this.aryUploadExcelTemplates.splice(k, 1);
        delete this.dicUploadExcelTemplates[uploadExcelTemplate.templateID];
        this.count = this.aryUploadExcelTemplates.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryUploadExcelTemplates[indexOrKey];
        } else {
            return this.dicUploadExcelTemplates[indexOrKey];
        }
    };
    this.getItems = function (moduleID,asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "?moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setUploadExcelTemplates(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (uploadExcelTemplate, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath;
        var obj = JSON.stringify(uploadExcelTemplate);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                var templateID = request.getResponseHeader('location').split('/uploadExcelTemplates/')[1];
                uploadExcelTemplate.templateID = templateID;
                me.add(uploadExcelTemplate);
                succ(templateID);
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addExcel = function(excel,templateID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "/" + templateID + "/file";
        var obj = excel;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function (uploadExcelTempalte, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "/" + uploadExcelTempalte.templateID;
        var obj = JSON.stringify(uploadExcelTempalte);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (templateID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelTempaltesPath + "/" + templateID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(templateID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setUploadExcelTemplates(data) {
        me.count = 0;
        me.aryUploadExcelTemplates = [];
        me.dicUploadExcelTemplates = {};
        for (var i = 0; i < data.length; i++) {
            var uploadExcelTemplate = new UploadExcelTemplate();
            uploadExcelTemplate.init(data[i]);
            me.add(uploadExcelTemplate);
        }
    }
}

function BDAColumn(){
    this.columnName = null;
    this.valueRange = null;
    this.dataType = null;
    this.custom = false;
    this.dataTypeEnum = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UploadExcelLog(){
    this.uploadExcelLogID = null;
    this.organizationID = null;
    this.templateID = null;
    this.startDate = null;
    this.endDate = null;
    this.uploadUserID = null;
    this.message = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function UploadExcelLogs(){
    var me = this;
    this.count = 0;
    this.aryUploadExcelLogs = [];
    this.dicUploadExcelLogs = {};

    this.add = function (uploadExcelLog) {
        this.aryUploadExcelLogs.push(uploadExcelLog);
        this.dicUploadExcelLogs[uploadExcelLog.uploadExcelLogID] = uploadExcelLog;
        this.count = this.aryUploadExcelLogs.length;
    };
    this.remove = function (uploadExcelLog) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUploadExcelLogs[i].uploadExcelLogID==uploadExcelLog.uploadExcelLogID){
                k = i;
                break;
            }
        }
        this.aryUploadExcelLogs.splice(k,1);
        delete this.dicUploadExcelLogs[uploadExcelLog.uploadExcelLogID];
        this.count = this.aryUploadExcelLogs.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUploadExcelLogs[indexOrKey];
        }else{
            return this.dicUploadExcelLogs[indexOrKey];
        }
    };
    this.getItems = function (parameters, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelLogsPath + "?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setUploadExcelLogs(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {
            
            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getCount = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.uploadExcelLogsPath + "/recordCount?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUploadExcelLogs(data){
        me.count = 0;
        me.aryUploadExcelLogs = [];
        me.dicUploadExcelLogs = {};
        for(var i = 0; i < data.length; i++){
            var uploadExcelLog = new UploadExcelLog();
            uploadExcelLog.init(data[i]);
            me.add(uploadExcelLog);
        }
    }
}

function Mapping(){
    this.columnName = null;
    this.fieldName = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function Mappings(){
    var me = this;
    this.count = 0;
    this.aryMappings = [];
    this.dicMappings = {};

    this.add = function (mapping) {
        this.aryMappings.push(mapping);
        this.dicMappings[mapping.columnName] = mapping;
        this.count = this.aryMappings.length;
    };
    this.remove = function (mapping) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryMappings[i].columnName==mapping.columnName){
                k = i;
                break;
            }
        }
        this.aryMappings.splice(k,1);
        delete this.dicMappings[mapping.columnName];
        this.count = this.aryMappings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryMappings[indexOrKey];
        }else{
            return this.dicMappings[indexOrKey];
        }
    };

    this.setMappings = function (data){
        me.count = 0;
        me.aryMappings = [];
        me.dicMappings = {};
        for(var i = 0; i < data.length; i++){
            var mapping = new Mapping();
            mapping.init(data[i]);
            me.add(mapping);
        }
    }
}

function Table(){
    var me = this;
    this.tableName = null;
    this.tableFields = new TableFields();

    this.initByTableName = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tablesPath + "/" + encodeURIComponent(this.tableName);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            if(key == "tableFields"){
                this[key].setTableFields(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    }

}

function Tables(){
    var me = this;
    this.count = 0;
    this.aryTables = [];
    this.dicTables = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTables[indexOrKey];
        }else{
            return this.dicTables[indexOrKey];
        }
    };
    this.add = function (table) {
        this.aryTables.push(table);
        this.dicTables[table.tableName] = table;
        this.count = this.aryTables.length;
    };
    this.remove = function (table) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTables[i].tableName==table.tableName){
                k = i;
                break;
            }
        }
        this.aryTables.splice(k,1);
        delete this.dicTables[table.tableName];
        this.count = this.aryTables.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tablesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setTables(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setTables(data){
        me.count = 0;
        me.aryTables = [];
        me.dicTables = {};
        for(var i = 0; i < data.length; i++){
            var table = new Table();
            table.init(data[i]);
            me.add(table);
        }
    }
}

function TableField(){
    this.fieldName = null;
    this.dataType = null;
    this.length = null;
    this.dataTypeEnum = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function TableFields(){
    var me = this;
    this.count = 0;
    this.aryTableFields = [];
    this.dicTableFields = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableFields[indexOrKey];
        }else{
            return this.dicTableFields[indexOrKey];
        }
    };
    this.add = function (tableField) {
        this.aryTableFields.push(tableField);
        this.dicTableFields[tableField.fieldName] = tableField;
        this.count = this.aryTableFields.length;
    };
    this.remove = function (tableField) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableFields[i].fieldName==tableField.fieldName){
                k = i;
                break;
            }
        }
        this.aryTableFields.splice(k,1);
        delete this.dicTableFields[tableField.fieldName];
        this.count = this.aryTableFields.length;
    };
    this.setTableFields = function(data){
        this.count = 0;
        this.aryTableFields = [];
        this.dicTableFields = {};
        for(var i = 0; i < data.length; i++){
            var tableField = new TableField();
            tableField.init(data[i]);
            this.add(tableField);
        }
    };
}