!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form, excel = layui.excel;
    var selectFiles = {};
    var columns = [];
    var formAddSubmit = null;
    var layerIndex = null;
    var tables = new Tables();
    var fieldDetailsList = [];

    window.initUploadExcel = function(addSubmit,index){
        $Utils.windowLoading.open();
        layerIndex = index;
        formAddSubmit = addSubmit;

        $(".cancel").click(function(){
            layer.close(layerIndex);
        });
        initSelectExcel();
    };

    function initSelectExcel(){
        $Utils.windowLoading.close();
        $(".select-excel-file .next-step").click(function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                initSelectExcelSheels();
            }
            return false;
        });

        bindSelectFileEvent();
    }

    function bindSelectFileEvent(){
        
        $("#LAY-excel-import-excel").change(function(e) {
            if(e.target.files[0].name.indexOf(".csv") != -1 || e.target.files[0].name.indexOf(".xlsx") != -1 || e.target.files[0].name.indexOf(".xls") != -1){
                // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
                //     layer.msg("因IE浏览器不支持某些方法，上传Excel请使用Chrome等浏览器。",{icon:3});
                // }else{
                    if (!Object.values) {
                        Object.values = function values(obj) {
                            return Object.keys(obj).map(function(e){
                                return obj[e];
                            })
                        };
                    }
                    var files = Object.values(e.target.files);
                    selectFiles.files = files;
                    selectFiles.excelFileName = files[0].name;
                    e.target.value = '';
                    excelContent(files);
                // }
            }else{
                layer.msg("不是一个Excel文件。",{icon:2});
            }
        });

        $(".reset-select").click(function(){
            $("#LAY-excel-import-excel").click();
        });
    }

    function excelContent(files){
        uploadExcel(files);
        showSelectedBox(files[0].name);
        $(".select-excel-file .next-step").attr("disabled",false);
    }

    function uploadExcel(files) {
        try {
            excel.importExcel(files, {}, function(data) {
                selectFiles.data = data[0];
            });
        } catch (e) {
            $Utils.openWindow.failWindow("读取Excel文件",e.message);
        }
    };

    function showSelectedBox(name){
        $(".init-select").addClass("uploaded");
        $(".selected-box").show();
        form.val("addExcelFile",{
            "excelName": name
        });
        form.render();
    }

    function initSelectExcelSheels(){
        $(".select-excel-file").hide();
        $(".sheel-list").show();
        $(".sheel-list .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                selectFiles.sheelName = $("#sheelName").val();
                initSheelRang();
            }
            return false;
        });
        $(".sheel-list .last-step").off("click").on("click",function(){
            $(".sheel-list").hide();
            $(".select-excel-file").show();
            return false;
        });

        initSheelSelectForm();

        form.render();

        $Utils.windowLoading.close();
    }

    function initSheelSelectForm(){
        var tempArr = [];
        for(var key in selectFiles.data){
            tempArr.push(key);
        }

        var sheelName = document.getElementById("sheelName");
        for(var i = 0; i < tempArr.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",tempArr[i]);
            if(i == 0){
                option.setAttribute("selected",true);
            }
            option.innerText = tempArr[i];
            sheelName.appendChild(option);
        }
    }

    function initSheelRang(){
        $(".sheel-list").hide();
        $(".sheel-range").show();
        $(".sheel-range .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                if(validateData()){
                    selectFiles.rangeType = $('input[name="rangeType"]:checked').val();
                    if(selectFiles.rangeType == 1){
                        selectFiles.range = $(".range").val();
                    }else{
                        var rowColumnLength = [];
                        for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                            var columnIndex = 0;
                            for(var key in selectFiles.data[selectFiles.sheelName][i]){
                                columnIndex ++;
                            }
                            rowColumnLength.push(columnIndex);
                        }
                        var maxColumn = Math.max.apply(null, rowColumnLength);
                        var maxRow = selectFiles.data[selectFiles.sheelName][selectFiles.data[selectFiles.sheelName].length - 1]["__rowNum__"];
                        selectFiles.range = "A2:"+createCellPos(maxColumn-1) + "2";
                    }
                    $Utils.windowLoading.open();
                    initColumnList();
                }
            }
            return false;
        });
        $(".sheel-range .last-step").off("click").on("click",function(){
            $(".sheel-list").show();
            $(".sheel-range").hide();
            return false;
        });

        form.render();

        bindRadioEvent();

        $Utils.windowLoading.close();
    }

    function bindRadioEvent(){
        form.on("radio(rangeType)", function (data) {
            if(this.value == '0'){
                $("input[name=range]").attr("disabled",true);
                $(".sheel-range .next-step").attr("disabled",false);
            }else if(this.value == '1'){
                $("input[name=range]").attr("disabled",false);
                if(!$("input[name=range]").val().length){
                    $(".sheel-range .next-step").attr("disabled",true);
                }
            }
        });

        $(".sheel-range .range").bind("input propertychange",function(){
            if($(this).val().length){
                $(".sheel-range .next-step").attr("disabled",false);
            }else{
                $(".sheel-range .next-step").attr("disabled",true);
            }
        });
    }

    function validateData(){
        if($('input[name="rangeType"]:checked').val() == 0){
            if(selectFiles.data[selectFiles.sheelName].length > 1){
                return true;
            }else{
                layer.msg("工作表"+selectFiles.sheelName+"的可用数据行数小于2，无法确定范围。",{icon:2});
                return false;
            }
        }
        return true;
    }

    function initColumnList(){
        $(".sheel-range").hide();
        $(".sheel-columns").show();
        $(".sheel-columns .last-step").off("click").on("click",function(){
            $(".sheel-range").show();
            $(".sheel-columns").hide();
            return false;
        });

        $(".sheel-columns .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                selectFiles.columns = saveColumn();
                $Utils.windowLoading.open();
        
                getTables();
            }
            return false;
        });

        initSheelColumnTableHead();
        initSheelColumnTableBody();

        bindButtonEvent();

        $Utils.windowLoading.close();
    }

    function initSheelColumnTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "columnName", title: "列名"},
                {field: "valueRange", title: "取值单元格"}
            ]
        ];

        table.render({
            elem: '#columnDetailsList',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function initSheelColumnTableBody(){
        var tableBody = [];
        if(selectFiles.rangeType == 0){
            var rowColumnLength = [];
            for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                var columnIndex = 0;
                for(var key in selectFiles.data[selectFiles.sheelName][i]){
                    columnIndex ++;
                }
                rowColumnLength.push(columnIndex);
            }
            var maxColumn = Math.max.apply(null, rowColumnLength);
            var maxRow = selectFiles.data[selectFiles.sheelName][selectFiles.data[selectFiles.sheelName].length - 1]["__rowNum__"];
            var headIndex = null;
            for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                if(selectFiles.data[selectFiles.sheelName][i]["__rowNum__"] == 0){
                    headIndex = i;
                    break;
                }
            }
            if(headIndex != null){
                for(var i = 0; i < maxColumn; i++){
                    var obj = {};
                    obj.key = createCellPos(i);
                    obj.columnName = selectFiles.data[selectFiles.sheelName][headIndex][createCellPos(i)]?selectFiles.data[selectFiles.sheelName][headIndex][createCellPos(i)]:("column_" + createCellPos(i));
                    obj.valueRange = createCellPos(i)+(headIndex+2)+":";
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
            }else{
                for(var i = 0; i < maxColumn; i++){
                    var obj = {};
                    obj.key = createCellPos(i);
                    obj.columnName = "column_" + createCellPos(i);
                    obj.valueRange = createCellPos(i)+2+":";
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
            }
        }
        if(selectFiles.rangeType == 1){
            var tempArr = selectFiles.range.split(":");
            var startObj = {};
            startObj.key = tempArr[0].split(tempArr[0].replace(/[^0-9]/ig,""))[0];
            startObj.rowNum = tempArr[0].replace(/[^0-9]/ig,"");
            var endObj = {};
            endObj.key = tempArr[1].split(tempArr[1].replace(/[^0-9]/ig,""))[0];
            endObj.rowNum = tempArr[1].replace(/[^0-9]/ig,"");
            var isStart = false;
            for(var key in selectFiles.data[selectFiles.sheelName][(Number(startObj.rowNum)-1)]){
                if(key == startObj.key){
                    isStart = true;
                }
                if(isStart){
                    var obj = {};
                    obj.key = key;
                    obj.columnName = selectFiles.data[selectFiles.sheelName][(Number(startObj.rowNum)-1)][key];
                    // obj.valueRange = key+""+(Number(startObj.rowNum)+1)+":"+endObj.key+endObj.rowNum;
                    obj.valueRange = key+""+(Number(startObj.rowNum)+1)+":";
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
                if(key == endObj.key){
                    isStart = false;
                }
            }
        }
        columns = tableBody;
        table.reload("columnDetailsList",{data:tableBody,limit:tableBody.length});
    }

    function createCellPos(n){
        var ordA = 'A'.charCodeAt(0);
        var ordZ = 'Z'.charCodeAt(0);
        var len = ordZ - ordA + 1;
        var s = "";
        while( n >= 0 ) {
            s = String.fromCharCode(n % len + ordA) + s;
            n = Math.floor(n / len) - 1;
        }
     
        return s;
    }

    function bindButtonEvent(){
        var rowObj = {};
        rowObj.rowIndex = null;
        table.on("radio(columnDetailsList)",function(data){
            rowObj.rowIndex = $(this).parents("tr").index();
        });
        $(".add-column").off("click").on("click",function(){
            var column = {};
            getAndLoadColumnForm(0,column,null);
        });
        $(".edit-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                var column = table.checkStatus('columnDetailsList').data[0];
                getAndLoadColumnForm(1,column,rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".up-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                upRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".down-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                downRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".delete-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                deleteRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function getAndLoadColumnForm(operationType,column,selectRow){
        $.ajax({
            url: "html/iDataOrganize/excelTemplate/column.html",
            type: 'GET',
            success: function(data){
                loadColumnForm(operationType,column,data,selectRow)
            }
        });
    }

    function loadColumnForm(operationType,column,strHtml,selectRow){
        layer.open({
            type: 1,
            title: ["列","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["400px","300px"],
            content: strHtml,
            success: function(layero,index){
                initColumnForm(operationType,column,index,selectRow,addSubmit,editSubmit);
            }
        });
    }

    function upRow(rowObj){
        if(rowObj.rowIndex != 0){
            var tempArr = $.extend(true,[],columns);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            columns[rowObj.rowIndex] = columns.splice(rowObj.rowIndex-1, 1, columns[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex-1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex != 0){ rowObj.rowIndex--;}
        }
    }

    function downRow(rowObj){
        if(rowObj.rowIndex != columns.length - 1){
            var tempArr = $.extend(true,[],columns);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            columns[rowObj.rowIndex] = columns.splice(rowObj.rowIndex+1, 1, columns[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex+1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex < columns.length - 1){ rowObj.rowIndex++;}
        }
    }

    function deleteRow(rowObj){
        for(var i = 0; i < columns.length; i++){
            if(i == rowObj.rowIndex){
                columns.splice(i,1);
                break;
            }
        }

        table.reload("columnDetailsList",{data: columns, limit: columns.length});
    }

    var addSubmit = function(column,layerIndex){
        columns.push(column);
        layer.close(layerIndex);
        table.reload("columnDetailsList",{data: columns, limit: columns.length});
    };

    var editSubmit = function(column,layerIndex,selectRow){
        var tempArr = $.extend(true,[],columns);
        for(var i = 0; i < tempArr.length; i++){
            if(i == selectRow.rowIndex){
                tempArr[i].columnName = column.columnName;
                tempArr[i].valueRange = column.valueRange;
                columns[i].columnName = column.columnName;
                columns[i].valueRange = column.valueRange;
                tempArr[i].LAY_CHECKED = true;
            }
        }
        layer.close(layerIndex);
        table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
    };

    function saveColumn(){
        var tempArr = [];
        for(var i = 0; i < columns.length; i++){
            var column = new BDAColumn();
            column.columnName = columns[i].columnName;
            column.valueRange = columns[i].valueRange;
            column.custom = columns[i].custom;
            tempArr.push(column);
        }
        return tempArr;
    }

    function initTableList(){
        $(".sheel-columns").hide();
        $(".table-list").show();
        $("#filterContent").val("");
        $(".table-list .next-step").attr("disabled",true);
        $(".table-list .last-step").off("click").on("click",function(){
            $(".sheel-columns").show();
            $(".table-list").hide();
            return false;
        });
        $(".table-list-box").off('click').on("click","li",function(){
            if(!$(this).hasClass("selected")){
                $(this).addClass("selected").siblings("li").removeClass("selected");
                if($(".table-list .next-step").prop("disabled") == true){
                    $(".table-list .next-step").attr("disabled",false);
                }
            }
        });

        $(".filter-button").off("click").on("click",function(){
            loadTableList($("#filterContent").val())
        });

        $(".table-list .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                selectFiles.targetTable = $(".table-list-box").find("li.selected").text();
                getAndLoadTableField();
            }
            return false;
        });

        loadTableList();
        $Utils.windowLoading.close();
    }

    function getTables(){
        var succ = function(){
            $Utils.windowLoading.close();
            initTableList();
		};
		var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
			$Utils.openWindow.failWindow("获取数据库表列表",errorStatus,msg);
        };
        tables.getItems(true,succ,fail);
    }

    function loadTableList(filterStr){
        $(".table-list-box").html("");
        var str = "";
        for(var i = 0; i < tables.count; i++){
            if(filterStr && tables.item(i).tableName.toUpperCase().indexOf(filterStr.toUpperCase()) != -1){
                str += "<li><i class='iconfont bda-verticalTable'></i><span>"+tables.item(i).tableName+"</span></li>";
            }else if(!filterStr){
                str += "<li><i class='iconfont bda-verticalTable'></i><span>"+tables.item(i).tableName+"</span></li>";
            }
        }
        $(".table-list-box").html(str);
        $(".table-list .next-step").attr("disabled",true);
    }

    function getAndLoadTableField(){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            initMaps();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取目标表的字段",errorStatus,msg);
        };
        tables.item(selectFiles.targetTable).initByTableName(true,succ,fail);
    }

    function initMaps(){
        $(".table-list").hide();
        $(".filed-columns").show();
        $(".filed-columns .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                editColumnAndsaveMaps();
                $Utils.windowLoading.open();
                initUploadMethod();
            }
            return false;
        });
        $(".filed-columns .last-step").off("click").on("click",function(){
            $(".table-list").show();
            $(".filed-columns").hide();
            return false;
        });

        initTableField();
        initFieldDetailsListTableEvent();

        $Utils.windowLoading.close();
    }

    function initTableField(){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "fieldName", title: "目标字段",templet: "#selectFieldName"},
                {field: "dataType", title: "类型"},
                {field: "length", title: "长度"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < selectFiles.columns.length; i++){
            var obj = {};
            obj.columnName = selectFiles.columns[i].columnName;
            obj.fieldName = tables.item(selectFiles.targetTable).tableFields.item(0).fieldName;
            obj.dataType = tables.item(selectFiles.targetTable).tableFields.item(0).dataType;
            obj.length = tables.item(selectFiles.targetTable).tableFields.item(0).length;
            obj.dataTypeEnum = tables.item(selectFiles.targetTable).tableFields.item(0).dataTypeEnum;
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#tableDetailsList',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: tableBody,
            cols: tableHead,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function initTableSelectEvent(){
        $("select[name='fieldName']").html(createOptions());
        layui.each($("select[name='fieldName']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(){
        var str = "";
        for(var i = 0; i < tables.item(selectFiles.targetTable).tableFields.count; i++){
            var tableField = tables.item(selectFiles.targetTable).tableFields.item(i);
            if(i == 0){
                str += "<option value="+tableField.fieldName+" checked>"+tableField.fieldName+"</option>";
            }else{
                str += "<option value="+tableField.fieldName+">"+tableField.fieldName+"</option>";
            }
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(fieldName)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            var tdElem = elem.parents('td');
            var selectTableField = tables.item(selectFiles.targetTable).tableFields.item(obj.value);
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            fieldDetailsList[trElem.data('index')]["dataType"] = selectTableField.dataType;
            fieldDetailsList[trElem.data('index')]["length"] = selectTableField.length;
            fieldDetailsList[trElem.data('index')]["dataTypeEnum"] = selectTableField.dataTypeEnum;
            trElem.find("td").each(function(){
                if($(this).attr("data-field") == "dataType"){
                    $(this).find("div").text(selectTableField.dataType);
                }
                if($(this).attr("data-field") == "length"){
                    $(this).find("div").text(selectTableField.length || "");
                }
            });
            form.render('select');
        });
    }

    function editColumnAndsaveMaps(){
        var arr = [];
        for(var i = 0; i < selectFiles.columns.length; i++){
            for(var j = 0; j < fieldDetailsList.length; j++){
                if(selectFiles.columns[i].columnName == fieldDetailsList[j].columnName){
                    selectFiles.columns[i].dataType = fieldDetailsList[j].dataType;
                    selectFiles.columns[i].dataTypeEnum = fieldDetailsList[j].dataTypeEnum;
                    var mapping = new Mapping();
                    mapping.columnName = fieldDetailsList[j].columnName;
                    mapping.fieldName = fieldDetailsList[j].fieldName;
                    arr.push(mapping);
                }
            }
        }
        selectFiles.mappings = arr;
    }

    function initUploadMethod(){
        $(".filed-columns").hide();
        $(".upload-method").show();
        form.val("addExcelFile",{
            "uploadMethod": 0
        })
        $(".table-mark").show();
        $(".upload-method .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                // editColumnAndsaveMaps();
                // $Utils.windowLoading.open();
                var formData = form.val("addExcelFile");
                if(formData.uploadMethod == 0){
                    selectFiles.uploadMethod = 0;
                    initTemplateName();
                }else if(formData.uploadMethod == 1){
                    selectFiles.identity = setIdentity(table.checkStatus("fieldList").data);
                    selectFiles.uploadMethod = 1;
                    initTemplateName();
                }
            }
            return false;
        });
        $(".upload-method .last-step").off("click").on("click",function(){
            $(".filed-columns").show();
            $(".upload-method").hide();
            return false;
        });

        loadFieldNameTable();

        bindMethodRadioEvent();

        $Utils.windowLoading.close();
    }

    function loadFieldNameTable(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "fieldName", title: "字段名"}
            ]
        ];
        var tableBody = [];
        var tempNameArr = [];
        for(var i = 0; i < selectFiles.mappings.length; i++){
            if(tempNameArr.indexOf(selectFiles.mappings[i].fieldName) == -1){
                tableBody.push({fieldName: selectFiles.mappings[i].fieldName});
                tempNameArr.push(selectFiles.mappings[i].fieldName);
            }
        }
        table.render({
            elem: '#fieldList',
            height: 280,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: tableBody,
            cols: tableHead,
            toolbar: false,
            limit: tableBody.length
        });
    }

    function bindMethodRadioEvent(){
        form.on("radio(uploadMethod)",function(){
            if(this.value == "0"){
                $(".table-mark").show();
            }else if(this.value == "1"){
                $(".table-mark").hide();
            }
        });
    }

    function setIdentity(data){
        var arr = [];
        for(var i = 0; i < data.length; i++){
            arr.push(data[i].fieldName);
        }
        return arr;
    }

    function initTemplateName(){
        $(".upload-method").hide();
        $(".excel-template-name").show();

        $(".excel-template-name input").val("");
        var fileName = selectFiles.excelFileName;
        if(fileName.indexOf(".csv") != -1){
            fileName = fileName.split(".csv")[0] + "上报模版";
        }
        if(fileName.indexOf(".xlsx") != -1){
            fileName = fileName.split(".xlsx")[0] + "上报模版";
        }
        if(fileName.indexOf(".xls") != -1){
            fileName = fileName.split(".xls")[0] + "上报模版";
        }
        form.val("addExcelFile",{
            "templateName": fileName
        });
        $("#templateName").on("input propertychange",function(){
            if($(this).val() == ""){
                $(".excel-template-name .next-step").attr("disabled",true);
            }else{
                $(".excel-template-name .next-step").attr("disabled",false);
            }
        });
        
        $(".excel-template-name .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                var formData = form.val("addExcelFile");
                selectFiles.templateName = formData.templateName;
                var template = saveTemplate();
                formAddSubmit(template.files,template.uploadExcelTemplate,layerIndex);
            }
            return false;
        });
        $(".excel-template-name .last-step").off("click").on("click",function(){
            $(".upload-method").show();
            $(".excel-template-name").hide();
            return false;
        });
    }

    function saveTemplate(){
        var obj = {};
        obj.templateName = selectFiles.templateName;
        obj.excelFileName = selectFiles.excelFileName;
        obj.sheetName = selectFiles.sheelName;
        obj.range = selectFiles.range;
        obj.rangeType = selectFiles.rangeType;
        obj.targetTable = selectFiles.targetTable;
        obj.uploadMethod = selectFiles.uploadMethod;
        obj.columns = selectFiles.columns;
        obj.mappings = selectFiles.mappings;
        obj.identity = selectFiles.uploadMethod==1?selectFiles.identity:[];

        return {files: selectFiles.files,uploadExcelTemplate: obj};
    }

}();