!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, form = layui.form, element = layui.element;
    var formEditSubmit = null;
    var layerIndex = null;
    var mUploadExcelTemplate = null;
    var fieldDetailsList = [];
    var targetTable = new Table();
    var selectFiles = {};
    
    window.initEditUploadExcelTemplate = function(index,uploadExcelTemplate,editSubmit){
        layerIndex = index;
        mUploadExcelTemplate = uploadExcelTemplate;
        formEditSubmit = editSubmit;

        getBusinessObjects();
    }

    function getBusinessObjects(){
        var succ = function(){
            getTableFields();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+mUploadExcelTemplate.templateName+" 属性",errorStatus,msg);
        };
		mUploadExcelTemplate.initByTemplateID(mUploadExcelTemplate.templateID,true,succ,fail);
    }

    function getTableFields(){
        targetTable.tableName = mUploadExcelTemplate.targetTable;
        var succ = function(){
            $Utils.loading.close();
            if(targetTable.tableFields.count == 0){
                layer.msg("目标表字段不存在或被删除。",{icon:3});
            }
            initEditSqlModelForm();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+targetTable.tableName+" 表字段",errorStatus,msg);
        };
		targetTable.initByTableName(true,succ,fail);
    }

    function initEditSqlModelForm(){
        form.val("editExcelTemplate",{
            "templateName": mUploadExcelTemplate.templateName,
            "targetTable": mUploadExcelTemplate.targetTable,
            "excelFileName": mUploadExcelTemplate.excelFileName,
            "uploadMethod": mUploadExcelTemplate.uploadMethod,
            "sheetName": mUploadExcelTemplate.sheetName,
            "identity": mUploadExcelTemplate.identity.join(", ")
        });
        $(".edit-excel-model input[name=templateName]").focus();
        
        loadFieldDetailsList(mUploadExcelTemplate);

        form.render('select');
        initFieldDetailsListTableEvent();

        form.on("submit(editModelSubmit)",function(obj){
            if(change(obj)){
                var excelTemplateObj = setEditSaveExcelTemplate(obj);
                formEditSubmit(excelTemplateObj,layerIndex);
            }else{
                layer.close(layerIndex);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
    }

    function loadFieldDetailsList(uploadExcelTemplate){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "fieldName", title: "目标字段",templet: "#selectFieldName"},
                {field: "dataType", title: "类型"},
                {field: "length", title: "长度"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < uploadExcelTemplate.mappings.count; i++){
            var obj = {};
            var fieldName = uploadExcelTemplate.mappings.item(i).fieldName;
            obj.columnName = uploadExcelTemplate.mappings.item(i).columnName;
            obj.fieldName = targetTable.tableFields.item(fieldName)?targetTable.tableFields.item(fieldName).fieldName:"";
            obj.dataType = targetTable.tableFields.item(fieldName)?targetTable.tableFields.item(fieldName).dataType:"";
            obj.length = targetTable.tableFields.item(fieldName)?targetTable.tableFields.item(fieldName).length:"";
            obj.dataTypeEnum = targetTable.tableFields.item(fieldName)?targetTable.tableFields.item(fieldName).dataTypeEnum:"";
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function initTableSelectEvent(){
        $("select[name='fieldName']").html(createOptions());
        layui.each($("select[name='fieldName']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(){
        var str = "";
        for(var i = 0; i < targetTable.tableFields.count; i++){
            str += "<option value="+targetTable.tableFields.item(i).fieldName+">"+targetTable.tableFields.item(i).fieldName+"</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(fieldName)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            var tdElem = elem.parents('td');
            var selectTableField = targetTable.tableFields.item(obj.value);
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            fieldDetailsList[trElem.data('index')]["dataType"] = selectTableField.dataType;
            fieldDetailsList[trElem.data('index')]["length"] = selectTableField.length;
            fieldDetailsList[trElem.data('index')]["dataTypeEnum"] = selectTableField.dataTypeEnum;
            trElem.find("td").each(function(){
                if($(this).attr("data-field") == "dataType"){
                    $(this).find("div").text(selectTableField.dataType);
                }
                if($(this).attr("data-field") == "length"){
                    $(this).find("div").text(selectTableField.length || "");
                }
            });
            form.render('select');
        });
    }

    function change(obj){
        if(obj.field.templateName != mUploadExcelTemplate.templateName){
            return true;
        }
        if(mappingsChange()){
            return true;
        }
        return false;
    }

    function mappingsChange(){
        for(var i = 0; i < mUploadExcelTemplate.mappings.count; i++){
            for(var j = 0; j < fieldDetailsList.length; j++){
                if(mUploadExcelTemplate.mappings.item(i).columnName == fieldDetailsList[j].columnName){
                    if(mUploadExcelTemplate.mappings.item(i).fieldName != fieldDetailsList[j].fieldName){
                        return true;
                    }else{
                        break;
                    }
                }
            }
        }
        return false;
    }

    function setEditSaveExcelTemplate(obj){
        var excelTemplateObj = {};
        excelTemplateObj.templateID = mUploadExcelTemplate.templateID;
        excelTemplateObj.templateName = obj.field.templateName;
        excelTemplateObj.templateURL = mUploadExcelTemplate.templateURL;
        excelTemplateObj.excelFileName = mUploadExcelTemplate.excelFileName;
        excelTemplateObj.sheetName = mUploadExcelTemplate.sheetName;
        excelTemplateObj.range = mUploadExcelTemplate.range;
        excelTemplateObj.rangeType = mUploadExcelTemplate.rangeType;
        excelTemplateObj.columns = mUploadExcelTemplate.columns;
        excelTemplateObj.targetTable = mUploadExcelTemplate.targetTable;
        excelTemplateObj.uploadMethod = mUploadExcelTemplate.uploadMethod;
        excelTemplateObj.identity = mUploadExcelTemplate.identity;
        if(targetTable.tableFields.count){
            var mappings = [];
            for(var i = 0; i < fieldDetailsList.length; i++){
                for(var j = 0; j < mUploadExcelTemplate.columns.length; j++){
                    if(fieldDetailsList[i].columnName == mUploadExcelTemplate.columns[j].columnName){
                        var mapping = new Mapping();
                        var fieldName = mUploadExcelTemplate.mappings.item(fieldDetailsList[i].columnName).fieldName;
                        mapping.columnName = fieldDetailsList[i].columnName;
                        
                        if(targetTable.tableFields.item(fieldName)){
                            mUploadExcelTemplate.columns[j].dataType = fieldDetailsList[i].dataType;
                            mUploadExcelTemplate.columns[j].dataTypeEnum = fieldDetailsList[i].dataTypeEnum;
                            mapping.fieldName = fieldDetailsList[i].fieldName;
                        }else{
                            mapping.fieldName = mUploadExcelTemplate.columns[j].fieldName;
                        }
                        mappings.push(mapping);
                        break;  
                    }
                }
            }
            excelTemplateObj.mappings = mappings;
        }else{
            var mappings = [];
            for(var i = 0; i < mUploadExcelTemplate.mappings.count; i++){
                mappings.push(mUploadExcelTemplate.mappings.item(i));
            }
            excelTemplateObj.mappings = mappings;
        }
        return excelTemplateObj;
    }
    
}();