/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-14 16:47:43
 * @LastEditTime: 2020-11-30 18:45:51
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, form = layui.form, layer = layui.layer;
    var bizDbSettings = new BizDbSettings();
    var databaseTypes = new DatabaseTypes();
    var isFirst = true;
    
    $Utils.loading.open();
    form.render();
    getAndInitSettings();

    function getAndInitSettings(){
        var succ = function(){
            getDataBaseTypes();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务数据库设置",errorStatus,msg);
		};
		bizDbSettings.getItems(true,succ,fail);
    }

    function getDataBaseTypes(){
        var succ = function(){
            $Utils.loading.close();
            initSettings();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库类型列表",errorStatus,msg);
		};
		databaseTypes.getItems(true,succ,fail);
    }

    function initSettings(){

        initForm();

        $(".database-name .layui-edge").off("click").click(function(){
            var data = form.val("databaseSettings");
            if(data.databaseTypeName == "MySql" || data.databaseTypeName == "SQLServer"){
                if(isFirst && !$(".database-name-input").hasClass("database-name-selected")){
                    if(validateDatabaseParameters()){
                        $Utils.loading.open();
                        getAndLoadDatabase();
                    }
                }else{
                    if($(".database-name-input").hasClass("database-name-selected")){
                        $(".database-name-input").removeClass("database-name-selected");
                    }else{
                        $(".database-name-input").addClass("database-name-selected");
                    }
                }
            }
        });

        $(document).click(function(e){
            var target = $(e.target);
            if(target.closest(".database-name-input").length != 0 && $(".database-name-input").hasClass("database-name-selected")) return;
            $(".database-name-input").removeClass("database-name-selected");
        })

        $(".database-name input").focus(function(){
            $(".database-name-input").removeClass("database-name-selected");
        });

        $(".database-name .database-name-list").off("click").on("click","dd",function(){
            $(this).addClass("layui-this").siblings("dd").removeClass("layui-this");
            $(".database-name-input").removeClass("database-name-selected");
            form.val("databaseSettings",{
                databaseName: $(this).text()
            });
        });

        form.on("submit(formDatabaseSubmit)",function(data){
            if(change(data)){
                $Utils.loading.open();
                var bizDbSetting = setSetting(data);
                var succ = function(){
                    $Utils.loading.close();
                    layer.msg("修改成功。",{icon: 1});
                    getAndInitSettings();
                };
                var fail = function(errorStatus,msg){
                    $Utils.loading.close();
                    $Utils.openWindow.failWindow("修改业务数据库设置",errorStatus,msg);
                };
                bizDbSettings.editItem(bizDbSetting,true,succ,fail);
            }
            return false;
        });
    }

    function initForm(){
        initAddDatabaseLinkForm();
        if(bizDbSettings.count){
            form.val("databaseSettings",{
                "bizSystemName": bizDbSettings.item(0).bizSystemName,
                "databaseIP": bizDbSettings.item(0).databaseIP,
                "databasePort": bizDbSettings.item(0).databasePort,
                "userName": bizDbSettings.item(0).userName,
                "password": bizDbSettings.item(0).password,
                "databaseName": bizDbSettings.item(0).databaseName
            });
            if(bizDbSettings.item(0).databaseTypeName == "Access"){
                $(".acc-type").css("opacity",0);
                $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
            }
        }
        form.render();

        $(".data-organize-database").off("click").on("click",".test-link a",function(){
            var data = form.val("databaseSettings");
            if(validateLinkParameters(data)){
                $Utils.loading.open();
                formTestConnections(data);
            }
        });
    }

    function initAddDatabaseLinkForm(){
        var defaultSelectIndex = 0; //加载时，默认选择第一个数据库类型和第一个数据库类型对应的第一个数据库版本；
        var databaseTypeName = document.getElementById("databaseTypeName");
        for(var i = 0; i < databaseTypes.count; i++){
            var databaseType = databaseTypes.item(i);
            // if(databaseType.databaseTypeName == "SQLServer"){
                var option = document.createElement("option");
                option.setAttribute("value",databaseType.databaseTypeName);
                if(bizDbSettings.count == 0){
                    if(i == 0){
                        option.setAttribute("selected",true);
                        defaultSelectIndex = 0;
                    }
                }else{
                    if(bizDbSettings.item(0).databaseTypeName == databaseType.databaseTypeName){
                        option.setAttribute("selected",true);
                        defaultSelectIndex = i;
                    }
                }
                option.innerText = databaseType.databaseTypeName;
                databaseTypeName.appendChild(option);
            // }
        }
        
        if(databaseTypes.item(defaultSelectIndex).databaseTypeName == "Access"){
            $(".acc-type").css("opacity",0);
            $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
        }

        bindLinkageEven();
    }

    function bindLinkageEven(){
        form.on("select(databaseTypeName)",function(data){
            if(data.value == "Access"){
                $(".acc-type").css("opacity",0);
                $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
            }else{
                $(".acc-type").css("opacity",1);
                $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password],input[name=databaseName]").attr("lay-verify","required");
            }
            
            form.render();
        });
    }

    function validateDatabaseParameters(){
        var data = form.val("databaseSettings");
        if(data.databaseIP == ""){
            $Utils.loading.close();
            layer.msg("请输入主机名！",{icon:2});
            return false;
        }
        if(data.databasePort == ""){
            $Utils.loading.close();
            layer.msg("请输入端口！",{icon:2});
            return false;
        }
        if(data.userName == ""){
            $Utils.loading.close();
            layer.msg("请输入用户名！",{icon:2});
            return false;
        }
        if(data.password == ""){
            $Utils.loading.close();
            layer.msg("请输入密码！",{icon:2});
            return false;
        }
        return true;
    }

    function getAndLoadDatabase(){
        var data = form.val("databaseSettings");
        var parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
        "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password);
        var succ = function(data){
            $Utils.loading.close();
            isFirst = false;
            showDatabases(data);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库列表",errorStatus,msg);
        };
        bizDbSettings.getDatabaseNames(parameters,true,succ,fail);
    }

    function showDatabases(data){
        var databaseName = document.getElementById("databaseName");
        for(var i = 0; i < data.length; i++){
            var dd = document.createElement("dd");
            dd.setAttribute("data-value",data[i]);
            if(bizDbSettings.count){
                if(data[i] == bizDbSettings.item(0).databaseName){
                    dd.className = "layui-this";
                }
            }
            dd.innerText = data[i];
            databaseName.appendChild(dd);
        }
        $(".database-name-input").addClass("database-name-selected");
    }

    function formTestConnections(data){
        var bizDbSetting = new BizDbSetting();
        var parameters = "";
        parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
        "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password)+"&databaseName="+encodeURIComponent(data.databaseName);
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        bizDbSetting.testConnections(parameters,true,succ,fail);
    }

    function change(data){
        if(bizDbSettings.count){
            if(data.field.bizSystemName != bizDbSettings.item(0).bizSystemName){
                return true;
            }
            if(data.field.databaseTypeName != bizDbSettings.item(0).databaseTypeName){
                return true;
            }
            if(data.field.databaseIP != bizDbSettings.item(0).databaseIP){
                return true;
            }
            if(data.field.databasePort != bizDbSettings.item(0).databasePort){
                return true;
            }
            if(data.field.userName != bizDbSettings.item(0).userName){
                return true;
            }
            if(data.field.password != bizDbSettings.item(0).password){
                return true;
            }
            if(data.field.databaseName != bizDbSettings.item(0).databaseName){
                return true;
            }
            return false;
        }else{
            return true;
        }
    }

    function validateLinkParameters(data){
        if(data.databaseTypeName == ""){
            layer.msg("请输入数据库类型！",{icon:2});
            return false;
        }
        if(data.databaseIP == ""){
            layer.msg("请输入主机名！",{icon:2});
            return false;
        }
        if(data.databasePort == ""){
            layer.msg("请输入端口！",{icon:2});
            return false;
        }
        if(data.userName == ""){
            layer.msg("请输入用户名！",{icon:2});
            return false;
        }
        if(data.databaseName == ""){
            layer.msg("请输入数据库名称！",{icon:2});
            return false;
        }
        return true;
    }

    function setSetting(data){
        var bizDbSetting = new BizDbSetting();
        bizDbSetting.bizSystemName = data.field.bizSystemName;
        bizDbSetting.databaseIP = data.field.databaseIP;
        bizDbSetting.databasePort = data.field.databasePort;
        bizDbSetting.databaseTypeName = data.field.databaseTypeName;
        bizDbSetting.databaseName = data.field.databaseName;
        bizDbSetting.userName = data.field.userName;
        bizDbSetting.password = data.field.password;

        return bizDbSetting;
    }
    
}();