/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-07-14 16:23:15
 * @LastEditTime: 2021-03-30 10:48:32
 * @LastModifyUser: 
 * @Remark: 
 */ 
!function(){
    var $ = layui.jquery, layer = layui.layer;
    var menus = new Menus();

    // $Utils.loading.open();
    initBusinessModel();

    function initBusinessModel(){
        loadModuleTitle();
        getAndLoadBusinessModelMenus();

        $(".left-menu-cnt .menu-list > ul").on("click","div",function(){
            $(".left-menu-cnt .menu-list > ul").find(".select-menu").removeClass("select-menu");
            if($(this).parent("li").hasClass("folder")){
                if($(this).siblings("ul").is(":hidden")){
                    $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    $(this).siblings("ul").show(200);
                    $(this).parents("li").addClass("select-menu");
                }else{
                    $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                    $(this).siblings("ul").hide(200);
                    $(this).parents("li").addClass("select-menu");
                }
            }else{
                if(!$(this).parent("li").hasClass("select-menu")){
                    $(this).parents("li").addClass("select-menu");
                    loadMenuList($(this).parent("li").attr("data-menucode"));
                    setBread(this);
                }
            }
        });
    }

    function loadModuleTitle(){
        var nameCn = "数据整理";
        var nameOther = "iDO";
        $(".module-title p").html("<span class='module-name'>"+nameCn+"</span> / <span class='module-name-other-language'>"+nameOther+"</span>");
    }

    function setBread(elem){
        var folderNameArr = [];
        folderNameArr.push($(elem).text());
        getFolderNameByDomTree($(elem).parent(),folderNameArr);
        var str = "<span>数据整理</span>";
        for(var i = folderNameArr.length-1; i >= 0; i--){
            str += "<span><i class='iconfont bda-bread'></i>"+folderNameArr[i]+"</span>"
        }
        $(".bread").html(str);
    }

    function getFolderNameByDomTree(elem,folderNameArr){
        if(elem.parent()[0].tagName == "UL" && elem.parent().siblings("div").length){
            folderNameArr.push(elem.parent().siblings("div").text());
            getFolderNameByDomTree(elem.parent().parent(),folderNameArr);
        }
    }

    function getAndLoadBusinessModelMenus(){
        var succ = function(){
            $Utils.loading.close();
			loadMenus();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据整理菜单",errorStatus,msg);
		};
		menus.getItems(4,true,succ,fail);
    }

    function loadMenus(){
        $(".menu-list > ul").html("");
        var str = "";
        for(var i = 0; i < menus.count; i++){
            if(menus.item(i).menuParentID == -1){
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-"+(menus.item(i).menuCode==21000?"dataBase":"moxing")+"'></i>"+menus.item(i).menuName+"<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-"+(menus.item(i).menuCode==41000?"dataBase":(menus.item(i).menuCode==42000?"zhuanhuan2":(menus.item(i).menuCode==43000?"caiwubaobiao":(menus.item(i).menuCode==44000?"caiwuzhibiao":(menus.item(i).menuCode==45000?"dingshizuoye":(menus.item(i).menuCode==47000?"21excel":"rizhi"))))))+"'></i><span>"+menus.item(i).menuName+"</span></div></li>"
                }
                $(".menu-list > ul").append(str);
            }else{
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-wenjianjia'></i>"+menus.item(i).menuName+"<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+">"+menus.item(i).menuName+"</div></li>";
                }
                $(".menu-list > ul").find("li").each(function(){
                    if($(this).attr("data-menuid") == menus.item(i).menuParentID){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
        $(".menu-list > ul > li:first-child > div").trigger("click");
        $(".menu-list > ul > li:first-child ul li:first-child div").trigger("click");
        $(".data-organize-list li").each(function(){
            if($(this).attr("data-menucode") == 43000){
                if(!$AppVars.gOrganizationSystemSettings.item("showFinanceReport") || ($AppVars.gOrganizationSystemSettings.item("showFinanceReport") && $AppVars.gOrganizationSystemSettings.item("showFinanceReport").systemSettingValue == 0)){
                    $(this).remove();
                }
            }
            if($(this).attr("data-menucode") == 44000){
                if(!$AppVars.gOrganizationSystemSettings.item("showFinanceIndex") || ($AppVars.gOrganizationSystemSettings.item("showFinanceIndex") && $AppVars.gOrganizationSystemSettings.item("showFinanceIndex").systemSettingValue == 0)){
                    $(this).remove();
                }
            }
        });
    }

    function loadMenuList(menuCode){
        switch(Number(menuCode)){
            case 41000:
                getListHtml("html/iDataOrganize/databaseSetting/databaseSetting.html");
                break;
            case 42000:
                getListHtml("html/iDataOrganize/transform/transforms.html");
                break;
            case 43000:
                getListHtml("html/iDataOrganize/financeReport/financeReports.html");
                break;
            case 44000:
                getListHtml("html/iDataOrganize/financeIndex/financeIndexs.html");
                break;
            case 45000:
                getListHtml("html/iDataOrganize/job/jobs.html");
                break;
            case 46000:
                getListHtml("html/iDataOrganize/transformLog/transformLog.html");
                break;
            case 47000:
                getListHtml("html/iDataOrganize/excelTemplate/excelTemplates.html");
                break;
        }
    }

    function getListHtml(url){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                $(".main-content").html("");
                $(".main-content").html(data);
            }
        });
    }

}();