/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 18:31:02
 * @LastEditTime: 2020-09-10 16:01:22
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var mIncludedUsers = null;
    var mTableBody = [];
    var backupArr = [];
    var lazyArr = [];
    var selectUsers = [];

    window.initUserList = function(index,includedUsers,users,addUserList){
        mIncludedUsers = includedUsers;
        initUserListHead();
        setTableBody(users)

        buttonEvent(index,addUserList,users);
    };

    function initUserListHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "userName", title: "用户名"},
                {field: "fullName", title: "全名"}
            ]
        ];

        table.render({
            elem: '#userList',
            height: 360,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function setTableBody(users){
        var includedUserIDs = setIncludedUserIDs();
        var tableBody = [];
        for(var i = 0; i < users.count; i++){
            if(includedUserIDs.indexOf(users.item(i).userID) == -1){
                var obj = {};
                obj.userID = users.item(i).userID;
                obj.userName = users.item(i).userName;
                obj.fullName = users.item(i).fullName;
                tableBody.push(obj);
            }
        }
        $.extend(true,mTableBody,tableBody);
        loadUserListBody(tableBody);
    }

    function loadUserListBody(tableBody){
        if(tableBody.length > 100){
            lazyArr = tableBody.splice(100,tableBody.length);
        }
        backupArr = tableBody;
        if(selectUsers.length){
            setSelect(tableBody);
        }
        table.reload("userList",{data:tableBody,limit:tableBody.length,skin: "nob",done:function(){
            $(".user-list .layui-table-main").scroll(function(){
                var scrollTop = $(this)[0].scrollTop;
                var clientHeight = $(this)[0].clientHeight;
                var scrollHeight = $(this)[0].scrollHeight;
                
                if(lazyArr.length > 0 && scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
                    loadmore(scrollTop);
                }
            });
        }});
    }

    function setSelect(currentData){
        var selectUserIDs = [];
        for(var i = 0; i < selectUsers.length; i++){
            selectUserIDs.push(selectUsers[i].userID);
        }
        for(var i = 0; i < currentData.length; i++){
            if(selectUserIDs.indexOf(currentData[i].userID) != -1){
                currentData[i].LAY_CHECKED = true;
            }else if(currentData[i].LAY_CHECKED){
                currentData[i].LAY_CHECKED = false;
            }
        }
    }

    function setIncludedUserIDs(){
        var tempArr = [];
        for(var i = 0; i < mIncludedUsers.length; i++){
            tempArr.push(mIncludedUsers[i].userID);
        }

        return tempArr;
    }

    function buttonEvent(index,addUserList,users){
        $(".list-filter-button").click(function(){
            var searchValue = $(".list-filter input").val();
            if(searchValue == ""){
                searchData = mTableBody;
            }else{
                searchData = setSearchData(searchValue);
            }
            loadUserListBody(searchData);
        });

        $(".list-filter input").keypress(function (e) {
            if (e.which == 13) {
                $(".list-filter-button").click();
            }
        });

        $(".user-list-button .layui-btn-determine").click(function(){
            // if(table.checkStatus('userList').data.length){
            //     var transmitData = setTransmitData(table.checkStatus('userList').data,users);
            //     addUserList(transmitData,index);
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            var transmitData = setTransmitData(selectUsers,users);
            addUserList(transmitData,index);
        });

        table.on('checkbox(userList)', function(obj){
            if(obj.checked){
                selectUsers.push(obj.data);
            }else{
                for(var i = selectUsers.length - 1; i >= 0 ; i--){
                    if(selectUsers[i].userID == obj.data.userID){
                        selectUsers.splice(i,1);
                    }
                }
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
        
    }

    function setSearchData(searchValue){
        var searchData = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].userName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBody[i].fullName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                searchData.push(mTableBody[i]);
            }
        }
        return searchData;
    }

    function setTransmitData(data,users){
        var tempArr = [];
        var userIDsArr = [];
        for(var i = 0; i < data.length; i++){
            if(userIDsArr.indexOf(data[i].userID) == -1){
                userIDsArr.push(data[i].userID)
            }
        }
        for(var i = 0; i < users.count; i++){
            if(userIDsArr.indexOf(users.item(i).userID) != -1){
                tempArr.push(users.item(i));
            }
        }

        return  tempArr;
    }

    function loadmore(scrollTop){
        if(lazyArr.length > 100){
            var tempArr = lazyArr.splice(0,100);
            backupArr = backupArr.concat(tempArr);
        }else{
            backupArr = backupArr.concat(lazyArr);
            lazyArr = [];
        }
        if(selectUsers.length){
            setSelect(backupArr)
        }
        table.reload("userList",{data:backupArr,limit:backupArr.length,skin: "nob"});
        $(".user-list .layui-table-main").scrollTop(scrollTop);
    }

}();