/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-10 18:04:22
 * @LastEditTime: 2021-02-21 18:25:34
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, form = layui.form, laypage = layui.laypage;
    var users = new Users();
    var organizationUsers = new OrganizationUsers();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initUsersTableHead();
        getAndLoadUsersTableBody();

        bindTableEvent();
    }

    function initUsersTableHead(){
        var userTableHead = [
            [
                {type: "radio"},
                {field: "userName",title: "用户名", sort: true},
                {field: "fullName",title: "全名", sort: true},
                {field: "mobileNumber",title: "手机号", sort: true},
                {field: "emailAddress",title: "邮箱地址", sort: true},
                {field: "createDate",title: "加入时间", sort: true},
                {field: "userForbidden",title: "状态",templet: "#forbidden",unresize: true,align: "center", sort: true},
                {title: "操作",toolbar: "#operation",align: "center", width:178}
            ]
        ];
    
        table.render({
            elem: '#userList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: userTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadUsersTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadUsersTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
        organizationUsers.getItems(true,succ,fail);
    }

    function setTableBody(){
        var usersTableBody = [];
        for (var i = 0; i < organizationUsers.count; i++){
            var tempObj = {};
            for (var key in organizationUsers.item(i)){
                if (typeof organizationUsers.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = organizationUsers.item(i)[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(organizationUsers.item(i)[key])):"";
                }else{
                    tempObj[key] = organizationUsers.item(i)[key];
                }
            }
            usersTableBody.push(tempObj);
        }
        return usersTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadUsersTableBody(data,obj);
            }
        });
    }

    function loadUsersTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("userList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("userList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("userList",{height: tableBodyHeight});
        });
    }

    function bindTableEvent(){
        table.on('sort(userList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        form.on("switch(forbidden)", function(obj){
            changeUserForbidden(obj);
        });

        table.on("tool(userList)", function(obj){
            var user = new User();
            user.userID = obj.data.userID;
            var succ = function () {
                if (obj.event == "addGroup") {
                    getAndLoadUserAddGroupForm(user);
                } else if (obj.event == "editPassword") {
                    if (user.userID != $AppVars.gUser.userID) {
                        getAndLoadEditPasswordForm(user);
                    } else {
                        layer.msg("不能重置当前登录用户的密码。", { icon: 2 });
                    }
                }
            };
            var fail = function (errorStatus, msg) {
                $Utils.openWindow.failWindow("获取用户信息", errorStatus, msg);
            };
            user.getItemByID(user.userID, true, succ, fail);
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].userName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].fullName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            (mTableBodyData[i].mobileNumber && (mTableBodyData[i].mobileNumber.toLowerCase().indexOf(searchValue.toLowerCase()) != -1)) ||
            (mTableBodyData[i].emailAddress && (mTableBodyData[i].emailAddress.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function changeUserForbidden(objData){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            changeList(objData.value,forbidden);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改状态",errorStatus,msg);
            $(objData.elem).prop("checked",(objData.elem.checked?false:true));
            form.render('checkbox');
        };
        var forbidden = objData.elem.checked?0:1;
        organizationUsers.changeForbidden(objData.value,forbidden,true,succ,fail);
    }

    function changeList(userID,forbidden){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].userID == userID){
                for(var key in currentTableBodyData[i]){
                    if(key == "userForbidden"){
                        currentTableBodyData[i][key] = forbidden;
                        tempTableBody[i][key] = forbidden;
                    }
                }
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("userList",{data:tempTableBody,limit:tempTableBody.length});
    }

    function getAndLoadUserAddGroupForm(user){
        $.ajax({
            url: "html/iControl/userAndGroup/user/userAddGroup.html",
            type: 'GET',
            success: function(data){
                loadUserAddGroupForm(data,user)
            }
        });
    }

    function loadUserAddGroupForm(strHtml,user){
        layer.open({
            type: 1,
            title: [user.userName+" 隶属于","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initUserAddGroupForm(index,user);
            }
        });
    }

    function getAndLoadEditPasswordForm(user){
        $.ajax({
            url: "html/iControl/userAndGroup/user/editPassword.html",
            type: 'GET',
            success: function(data){
                loadEditPasswordForm(data,user)
            }
        });
    }

    function loadEditPasswordForm(strHtml,user){
        layer.open({
            type: 1,
            title: ["重置密码","font-size: 14px"],
            area: ['440px','330px'], //宽高
            content: strHtml,
            success: function(layero, index){
                initEditPasswordForm(index,user);
            }
        });
    }

    $(".add-user").click(function(){
        var user = new User();
        getAndLoadUserForm(0,user);
    });

    $(".edit-user").click(function(){
        if(table.checkStatus('userList').data.length){
            var user = new User();
            user.userID = table.checkStatus('userList').data[0].userID;
            var succ = function () {
                getAndLoadUserForm(1, user);
            };
            var fail = function (errorStatus, msg) {
                $Utils.openWindow.failWindow("获取用户信息", errorStatus, msg);
            };
            user.getItemByID(user.userID, true, succ, fail);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-user").click(function(){
        if(table.checkStatus('userList').data.length){
            layer.open({
                type: 0,
                title: "删除用户",
                closeBtn: 1,
                shadeClose: true,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('userList').data[0].userName+" ？</div></div>",
                btn: ["是","否"],
                yes: function(index,layero){
                    layer.close(index);
                    removeUser(table.checkStatus('userList').data[0].organizationUserID);
                }
            });
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadUsersTableBody();
    });

    function getAndLoadUserForm(operationType,user){
        $.ajax({
            url: "html/iControl/userAndGroup/user/user.html",
            type: 'GET',
            success: function(data){
                loadUserForm(data,operationType,user)
            }
        });
    }

    function loadUserForm(strHtml,operationType,user){
        layer.open({
            type: 1,
            title: [operationType?(user.userName+" 属性"):"新增用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initUserForm(index,operationType,user,addSubmit,editSubmit,0);
            }
        });
    }

    function removeUser(organizationUserID){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功。",{icon:1});
            getAndLoadUsersTableBody();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除用户",errorStatus,msg);
        };
        organizationUsers.deleteItem(organizationUserID,true,succ,fail);
    }

    var addSubmit = function(user,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadUsersTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增用户",errorStatus,msg);
        };
        
		users.addItem(user,true,succ,fail);
    };

    var editSubmit = function(user,index){
        $Utils.loading.open();
        var succ = function(){
            layer.close(index);
            getAndLoadEditList(user);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改用户",errorStatus,msg);
        };
		users.editItem(user,true,succ,fail);
    };

    function getAndLoadEditList(user){
        var organizationUserID = "";
        for(var i = 0; i < organizationUsers.count; i++){
            if(organizationUsers.item(i).userID == user.userID){
                organizationUserID = organizationUsers.item(i).organizationUserID;
            }
        }
        var succ = function(){
            $Utils.loading.close();
            editListItem(organizationUsers.item(organizationUserID));
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 的属性",errorStatus,msg);
        };
        organizationUsers.item(organizationUserID).getItemByID(organizationUserID,true,succ,fail);
    }

    function editListItem(organizationUser){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if (currentTableBodyData[i].userID == organizationUser.userID){
                for(var key in currentTableBodyData[i]){
                    if(key == "createDate"){
                        currentTableBodyData[i][key] = organizationUser[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(organizationUser[key])):"";
                        tempTableBody[i][key] = organizationUser[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(organizationUser[key])):"";

                    }else if(key == "lastModifyDate"){
                        currentTableBodyData[i][key] = organizationUser[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(organizationUser[key])):"";
                        tempTableBody[i][key] = organizationUser[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(organizationUser[key])):"";
                    }else{
                        currentTableBodyData[i][key] = organizationUser[key];
                        tempTableBody[i][key] = organizationUser[key];
                    }
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("userList",{data:tempTableBody,limit:tempTableBody.length});
    }
    
}();