/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-11 14:09:28
 * @LastEditTime: 2020-05-07 14:00:58
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, form = layui.form, table = layui.table, layer = layui.layer;
    var userGroups = new UserGroups();
    var groups = new Groups();
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mUser = null;
    var selectGroup = null;

    window.initUserAddGroupForm = function(index,user){
        mUser = user;
        loadGroupListTableHead();
        getAndLoadGroups(user);

        buttonEvent(index);

    };

    function loadGroupListTableHead(){
        var tableHead = [
            [
                {field: "groupName", title: "组名"},
                {field: "description", title: "描述"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadGroups(user){
        var succ = function(){
            $Utils.loading.close();
			getUserGroupsAndLoadGroups(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function getUserGroupsAndLoadGroups(user){
        var succ = function(data){
            $Utils.loading.close();
			loadGroups(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取"+user.userName+"所属组",errorStatus,msg);
		};
		userGroups.getItemsByUserID(user.userID,true,succ,fail);
    }

    function loadGroups(data){
        var tableBody = [];
        for(var i = 0; i < groups.count; i++){
            if(data.indexOf(groups.item(i).groupID) != -1){
                var tempObj = {};
                for(var key in groups.item(i)){
                    if(typeof groups.item(i)[key] === "function"){ continue;}
                    tempObj[key] = groups.item(i)[key];
                }
                tableBody.push(tempObj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add").click(function(){
            getAndLoadGroupsListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteUsers();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectGroup){
                deleteGroups([selectGroup.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        table.on('row(list)', function(obj){
            selectGroup = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });

        form.on("submit(formSubmit)",function(){
            if(change()){
                $Utils.loading.open();
                addGroupSubmit(index);
            }else{
                layer.close(index);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function getAndLoadGroupsListForm(){
        $.ajax({
            url: "html/iControl/groupList.html",
            type: 'GET',
            success: function(data){
                loadGroupsListForm(data)
            }
        });
    }

    function loadGroupsListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                initGroupList(index,mTableBody,groups,addGroupList);
            }
        });
    }

    function deleteGroups(selectUsers){
        for(var i = 0; i < selectUsers.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectUsers[i].groupID == mTableBody[j].groupID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    }

    function change(){
        var groupIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            groupIDs.push(mTableBody[i].groupID);
        }
        
        if(mBackupsTableBody.length == 0 && groupIDs.length == 0){
            return false;
        }
        
        if(mBackupsTableBody.length != groupIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsTableBody.length; i++){
            if(groupIDs.indexOf(mBackupsTableBody[i].groupID) == -1){
                return true;
            }
        }
        return false;
    }

    function addGroupSubmit(index){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            tempArr.push(mTableBody[i].groupID);
        }
        var tempObj = {};
        tempObj.userID = mUser.userID;
        tempObj.groupIDs = tempArr;

        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属组",errorStatus,msg);
        };
		userGroups.updateGroup(tempObj,true,succ,fail);
    }

    var addGroupList = function(groupList,index){
        layer.close(index);
        mTableBody = mTableBody.concat(groupList);
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };

}();