!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var groups = new Groups();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initGroupsTableHead();
        getAndLoadGroupsTableBody();

        bindTableEvent();
    }

    function initGroupsTableHead(){
        var groupTableHead = [
            [
                {type: "radio"},
                {field: "groupName",title: "组名", sort: true},
                {field: "description",title: "描述", sort: true},
                {field: "preseted",title: "预设",templet: "#preseted", sort: true},
                {title: "操作",templet: "#operation",align: "center"}
            ]
        ];
    
        table.render({
            elem: '#groupList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: groupTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadGroupsTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadGroupsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function setTableBody(){
        var groupsTableBody = [];
        for(var i = 0; i < groups.count; i++){
            var tempObj = {};
            for(var key in groups.item(i)){
                if(typeof groups.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = groups.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(groups.item(i)[key])):"";
                }else{
                    tempObj[key] = groups.item(i)[key];
                }
            }
            groupsTableBody.push(tempObj);
        }
        return groupsTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadGroupsTableBody(data,obj);
            }
        });
    }

    function loadGroupsTableBody(tableBodyData,obj){
        var groupsTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("groupList",{data:groupsTableBody,limit:groupsTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("groupList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("groupList",{height: tableBodyHeight});
        });
    }

    function bindTableEvent(){
        table.on('sort(groupList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(groupList)", function(obj){
            var group = groups.item(obj.data.groupID);
            if(obj.event == "addUser"){
                getAndLoadGroupAddUserForm(group);
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].groupName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadGroupAddUserForm(group){
        $.ajax({
            url: "html/iControl/userAndGroup/group/groupAddUser.html",
            type: 'GET',
            success: function(data){
                loadGroupAddUserForm(data,group)
            }
        });
    }

    function loadGroupAddUserForm(strHtml,group){
        layer.open({
            type: 1,
            title: [group.groupName + " 成员","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initGroupAddUserForm(index,group);
            }
        });
    }

    $(".add-group").click(function(){
        var group = new Group();
        getAndLoadGroupForm(0,group);
    });

    $(".edit-group").click(function(){
        if(table.checkStatus('groupList').data.length){
            var group = groups.item(table.checkStatus('groupList').data[0].groupID);
            getAndLoadGroupForm(1,group);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-group").click(function(){
        if(table.checkStatus('groupList').data.length){
            layer.open({
                type: 0,
                title: "删除组",
                closeBtn: 1,
                shadeClose: true,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('groupList').data[0].groupName+" ？</div></div>",
                btn: ["是","否"],
                yes: function(index,layero){
                    layer.close(index);
                    deleteGroup(table.checkStatus('groupList').data[0].groupID);
                }
            });
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadGroupsTableBody();
    });

    function getAndLoadGroupForm(operationType,group){
        $.ajax({
            url: "html/iControl/userAndGroup/group/group.html",
            type: 'GET',
            success: function(data){
                loadGroupForm(data,operationType,group)
            }
        });
    }

    function loadGroupForm(strHtml,operationType,group){
        layer.open({
            type: 1,
            title: [operationType?(group.groupName+" 属性"):"新增组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initGroupForm(index,operationType,group,addSubmit,editSubmit);
            }
        });
    }

    function deleteGroup(groupID){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功。",{icon:1});
            getAndLoadGroupsTableBody();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除组",errorStatus,msg);
        };
        groups.deleteItem(groupID,true,succ,fail);
    }

    var addSubmit = function(group,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadGroupsTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增组",errorStatus,msg);
        };
        
		groups.addItem(group,true,succ,fail);
    };

    var editSubmit = function(group,index){
        $Utils.loading.open();
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadGroupsTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改组",errorStatus,msg);
        };
		groups.editItem(group,true,succ,fail);
    };
    
}();