/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-13 11:08:57
 * @LastEditTime: 2020-05-07 13:59:21
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var groupUsers = new GroupUsers();
    var organizationUsers = new OrganizationUsers();
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mGroup = null;
    var selectUser = null;

    window.initGroupAddUserForm = function(index,group){
        mGroup = group;
        loadUserListTableHead();
        getAndLoadOrganizationUsers(group);

        buttonEvent(index);
    };

    function loadUserListTableHead(){
        var tableHead = [
            [
                {field: "userName", title: "用户名"},
                {field: "fullName", title: "全名"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadOrganizationUsers(group){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadUsers(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
		organizationUsers.getItems(true,succ,fail);
    }

    function getAndLoadUsers(group){
        var succ = function(data){
            $Utils.loading.close();
			loadGroups(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取"+group.groupName+"包含的用户",errorStatus,msg);
		};
		groupUsers.getItemsByGroupID(group.groupID,true,succ,fail);
    }

    function loadGroups(data){
        var tableBody = [];
        for(var i = 0; i < organizationUsers.count; i++){
            if(data.indexOf(organizationUsers.item(i).userID) != -1){
                var tempObj = {};
                for(var key in organizationUsers.item(i)){
                    if(typeof organizationUsers.item(i)[key] === "function"){ continue;}
                    tempObj[key] = organizationUsers.item(i)[key];
                }
                tableBody.push(tempObj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add").click(function(){
            getAndLoadUsersListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteUsers();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectUser){
                deleteUsers([selectUser.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        table.on('row(list)', function(obj){
            selectUser = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });

        form.on("submit(formSubmit)",function(){
            if(change()){
                $Utils.loading.open();
                addUserSubmit(index);
            }else{
                layer.close(index);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function getAndLoadUsersListForm(){
        $.ajax({
            url: "html/iControl/userList.html",
            type: 'GET',
            success: function(data){
                loadUsersListForm(data)
            }
        });
    }

    function loadUsersListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                initUserList(index,mTableBody,organizationUsers,addUserList);
            }
        });
    }

    function deleteUsers(selectUsers){
        for(var i = 0; i < selectUsers.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectUsers[i].userID == mTableBody[j].userID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function change(){
        var userIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            userIDs.push(mTableBody[i].userID);
        }
        
        if(mBackupsTableBody.length == 0 && userIDs.length == 0){
            return false;
        }

        if(mBackupsTableBody.length != userIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsTableBody.length; i++){
            if(userIDs.indexOf(mBackupsTableBody[i].userID) == -1){
                return true;
            }
        }
        
        return false;
    }

    function addUserSubmit(index){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            tempArr.push(mTableBody[i].userID);
        }
        var tempObj = {};
        tempObj.groupID = mGroup.groupID;
        tempObj.userIDs = tempArr;

        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改包含的用户",errorStatus,msg);
        };
		groupUsers.updateUser(tempObj,true,succ,fail);
    }

    var addUserList = function(userList,index){
        layer.close(index);
        mTableBody = mTableBody.concat(userList);
        table.reload("list",{data:mTableBody,limit:mTableBody.length,skin: "nob"});
    };
    
}();