!function(){
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage, form = layui.form;
    var uploadExcelLogs = new UploadExcelLogs();
    var mLimit = 20;
    var mCurrentPage = 1;
    var totalCount = 0;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var parameters = "moduleID=1&fromDate=" + encodeURIComponent(setStartDate(0)) + "&endDate=" + encodeURIComponent(setEndDate());
    
    initMain();

    function initMain(){
        initLogsTableHead();

        getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
        getAndLoadLogsCount(parameters);
        form.render();

        $(".refresh").click(function(){
            var formDate = form.val("dateRange");
            parameters = null;
            parameters = "moduleID=1&fromDate=" + encodeURIComponent(setStartDate(formDate.timeFrame)) + "&endDate=" + encodeURIComponent(setEndDate());
            getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
            getAndLoadLogsCount(parameters);
        });

        form.on("select(timeFrame)",function(obj){
            parameters = null;
            parameters = "moduleID=1&fromDate=" + encodeURIComponent(setStartDate(obj.value)) + "&endDate=" + encodeURIComponent(setEndDate());
            mCurrentPage = 1;
            getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
            getAndLoadLogsCount(parameters);
        });
    }

    function setStartDate(index){
        var currentDate = new Date();
        var formDate = null;
        var lastDate = null;
        var before_year = null;
        var before_month = null;
        var before_date = null;
        if(index == 0){
            lastDate = getDateRange(currentDate,7);
        }
        if(index == 1){
            lastDate = getDateRange(currentDate,30);
        }
        if(index == 2){
            lastDate = getDateRange(currentDate,180);
        }
        if(index == 3){
            lastDate = getDateRange(currentDate,365);
        }
        if(index == 4){
            lastDate = getDateRange(currentDate,1095);
        }
        before_year = lastDate.getFullYear();
        before_month = lastDate.getMonth() + 1 <=9 ? "0"+(lastDate.getMonth()+1) : lastDate.getMonth()+1;
        before_date = lastDate.getDate() <=9 ? "0"+lastDate.getDate() : lastDate.getDate(); 
        formDate = before_year+"-"+before_month+"-"+before_date;

        return formDate;
    }

    function getDateRange(dateNow,intervalDays){
        var oneDay = 24 * 60 * 60 * 1000;
        lastDay = new Date(dateNow.getTime() - intervalDays * oneDay);
        return lastDay;
    }

    function setEndDate(){
        var myDate = new Date(); 
        var now_year = myDate.getFullYear(); //获取当前年
        var now_month = myDate.getMonth()+1 <=9 ? "0"+(myDate.getMonth()+1) : myDate.getMonth()+1; //获取当前月
        var now_date = myDate.getDate() <=9 ? "0"+myDate.getDate() : myDate.getDate(); //获取当前日
        var endDate = now_year+"-"+now_month+"-"+now_date

        return endDate;
    }

    function initLogsTableHead(){
        var logTableHead = [
            [
                {field: "templateName",title: "模版名称",width: 200, sort: true},
                {field: "startDate",title: "开始时间",width: 142, sort: true},
                {field: "endDate",title: "结束时间",width: 142, sort: true},
                {field: "takeUpTime",title: "耗时（毫秒）",width: 120, sort: true},
                {field: "message",title: "详细信息"}
            ]
        ];
    
        table.render({
            elem: '#upLoadExcelDataLogs',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: logTableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadLogsTableBody(parameters,curPage,limit){
        $Utils.loading.open();
        parameters = parameters + "&pageNumber=" + encodeURIComponent(curPage) + "&recordCountPerPage=" + encodeURIComponent(limit);
        var succ = function(){
            $Utils.loading.close();
			loadLogsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取上报日志列表",errorStatus,msg);
        };

		uploadExcelLogs.getItems(parameters,true,succ,fail);
    }

    function getAndLoadLogsCount(parameters){
        var succ = function(data){
            totalCount = data.property;
            initPagingBar();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取上报日志列表总记录数",errorStatus,msg);
        };

		uploadExcelLogs.getCount(parameters,true,succ,fail);
    }

    function initPagingBar(){
        //执行一个laypage实例
        laypage.render({
            elem: "pageBox", //注意，这里的 pageList 是 ID，不用加 # 号
            layout: ["prev", "page", "next", "limit"],
            limit: mLimit,
            limits: [10,20, 30, 40, 50],
            curr: mCurrentPage,
            count: totalCount, //数据总数，从服务端得到
            jump: function(obj, first){
                //obj包含了当前分页的所有参数，比如：
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>totalCount?totalCount:(obj.curr*obj.limit))+" ，共 "+totalCount+" 条记录");

                //首次不执行
                if(!first){
                    mCurrentPage = obj.curr;
                    mLimit = obj.limit;
                    getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
                }
            }
        });
    }

    function loadLogsTableBody(){
        var logsTableBody = [];
        for(var i = 0; i < uploadExcelLogs.count; i++){
            var tempObj = {};
            tempObj.takeUpTime = uploadExcelLogs.item(i).endDate - uploadExcelLogs.item(i).startDate;
            for(var key in uploadExcelLogs.item(i)){
                if(typeof uploadExcelLogs.item(i)[key] === "function"){ continue;}
                if(key == "startDate"){
                    tempObj[key] = uploadExcelLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelLogs.item(i)[key])):"";
                }else if(key == "endDate"){
                    tempObj[key] = uploadExcelLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelLogs.item(i)[key])):"";
                }else if(key == "message"){
                    tempObj[key] = uploadExcelLogs.item(i)[key]?("<xmp>" + uploadExcelLogs.item(i)[key] + "</xmp>"):"";
                }else{
                    tempObj[key] = uploadExcelLogs.item(i)[key];
                }
            }
            logsTableBody.push(tempObj);
        }
        table.reload("upLoadExcelDataLogs",{data:logsTableBody,limit:logsTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("upLoadExcelDataLogs",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("upLoadExcelDataLogs",{height: tableBodyHeight});
        });
    }
    
}();