/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-13 18:54:46
 * @LastEditTime: 2020-11-06 15:21:35
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage, form = layui.form;
    var reportQueryLogs = new ReportQueryLogs();
    var mLimit = 20;
    var mCurrentPage = 1;
    var totalCount = 0;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var parameters = "fromDate=" + encodeURIComponent(setStartDate(0)) + "&endDate=" + encodeURIComponent(setEndDate());
    
    initMain();

    function initMain(){
        initLogsTableHead();

        getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
        getAndLoadLogsCount(parameters);
        form.render();

        $(".refresh").click(function(){
            var formDate = form.val("dateRange");
            parameters = null;
            parameters = "fromDate=" + encodeURIComponent(setStartDate(formDate.timeFrame)) + "&endDate=" + encodeURIComponent(setEndDate());
            getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
            getAndLoadLogsCount(parameters);
        });

        form.on("select(timeFrame)",function(obj){
            parameters = null;
            parameters = "fromDate=" + encodeURIComponent(setStartDate(obj.value)) + "&endDate=" + encodeURIComponent(setEndDate());
            mCurrentPage = 1;
            getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
            getAndLoadLogsCount(parameters);
        });
    }

    function setStartDate(index){
        var currentDate = new Date();
        var formDate = null;
        var lastDate = null;
        var before_year = null;
        var before_month = null;
        var before_date = null;
        if(index == 0){
            lastDate = getDateRange(currentDate,7);
        }
        if(index == 1){
            lastDate = getDateRange(currentDate,30);
        }
        if(index == 2){
            lastDate = getDateRange(currentDate,180);
        }
        if(index == 3){
            lastDate = getDateRange(currentDate,365);
        }
        if(index == 4){
            lastDate = getDateRange(currentDate,1095);
        }
        before_year = lastDate.getFullYear();
        before_month = lastDate.getMonth() + 1 <=9 ? "0"+(lastDate.getMonth()+1) : lastDate.getMonth()+1;
        before_date = lastDate.getDate() <=9 ? "0"+lastDate.getDate() : lastDate.getDate(); 
        formDate = before_year+"-"+before_month+"-"+before_date;

        return formDate;
    }

    function getDateRange(dateNow,intervalDays){
        var oneDay = 24 * 60 * 60 * 1000;
        lastDay = new Date(dateNow.getTime() - intervalDays * oneDay);
        return lastDay;
    }

    function setEndDate(){
        var myDate = new Date(); 
        var now_year = myDate.getFullYear(); //获取当前年
        var now_month = myDate.getMonth()+1 <=9 ? "0"+(myDate.getMonth()+1) : myDate.getMonth()+1; //获取当前月
        var now_date = myDate.getDate() <=9 ? "0"+myDate.getDate() : myDate.getDate(); //获取当前日
        var endDate = now_year+"-"+now_month+"-"+now_date

        return endDate;
    }

    function initLogsTableHead(){
        var logTableHead = [
            [
                {field: "statusCode",title: "状态码",width: 70, sort: true,templet: function(d){
                    var str = "";
                    if(d.statusCode >= 200 && d.statusCode <= 299){
                        str = "<i class='iconfont bda-tips'></i>" + d.statusCode;
                    }else{
                        str = "<i class='iconfont bda-fail'></i>" + d.statusCode;
                    }
                    return str;
                }},
                {field: "reportName",title: "报表名称", sort: true},
                {field: "userName",title: "用户名", width: 90, sort: true},
                {field: "deviceTypeName",title: "设备", width: 70, sort: true},
                {field: "accessStartDate",title: "访问开始时间",width: 122, sort: true},
                {field: "accessEndDate",title: "访问结束时间",width: 122, sort: true},
                {field: "takeUpTime",title: "耗时（毫秒）",width: 100, sort: true},
                {field: "message",title: "详细信息"}
            ]
        ];
    
        table.render({
            elem: '#reportLogList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: logTableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadLogsTableBody(parameters,curPage,limit){
        $Utils.loading.open();
        parameters = parameters + "&pageNumber=" + encodeURIComponent(curPage) + "&recordCountPerPage=" + encodeURIComponent(limit);
        var succ = function(){
            $Utils.loading.close();
            // mTableBodyData = setTableBody();
            // mSortBodyData = mTableBodyData;
            // setTablePage(mTableBodyData);
			loadLogsTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表日志列表",errorStatus,msg);
        };

		reportQueryLogs.getItems(parameters,true,succ,fail);
    }

    function getAndLoadLogsCount(parameters){
        var succ = function(data){
            totalCount = data.property;
            initPagingBar();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表日志列表总记录数",errorStatus,msg);
        };

		reportQueryLogs.getCount(parameters,true,succ,fail);
    }

    function setTableBody(){
        var logsTableBody = [];
        for(var i = 0; i < reportQueryLogs.count; i++){
            var tempObj = {};
            tempObj.takeUpTime = reportQueryLogs.item(i).accessEndDate - reportQueryLogs.item(i).accessStartDate;
            for(var key in reportQueryLogs.item(i)){
                if(typeof reportQueryLogs.item(i)[key] === "function"){ continue;}
                if(key == "accessStartDate"){
                    tempObj[key] = reportQueryLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(reportQueryLogs.item(i)[key])):"";
                }else if(key == "accessEndDate"){
                    tempObj[key] = reportQueryLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(reportQueryLogs.item(i)[key])):"";
                }else{
                    tempObj[key] = reportQueryLogs.item(i)[key];
                }
            }
            logsTableBody.push(tempObj);
        }
        return logsTableBody;
    }

    function initPagingBar(){
        //执行一个laypage实例
        laypage.render({
            elem: "pageBox", //注意，这里的 pageList 是 ID，不用加 # 号
            layout: ["prev", "page", "next", "limit"],
            limit: mLimit,
            limits: [20, 30, 40, 50],
            curr: mCurrentPage,
            count: totalCount, //数据总数，从服务端得到
            jump: function(obj, first){
                //obj包含了当前分页的所有参数，比如：
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>totalCount?totalCount:(obj.curr*obj.limit))+" ，共 "+totalCount+" 条记录");

                //首次不执行
                if(!first){
                    mCurrentPage = obj.curr;
                    mLimit = obj.limit;
                    getAndLoadLogsTableBody(parameters,mCurrentPage,mLimit);
                }
            }
        });
    }

    // function setTablePage(data){
    //     laypage.render({
    //         elem: "pageBox",
    //         count: data.length,
    //         limit: mLimit,
    //         limits: [10, 20, 30, 40, 50],
    //         curr: mCurrentPage,
    //         layout: ["prev", "page", "next", "limit"],
    //         jump: function(obj, first){
    //             $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
    //             loadLogsTableBody(data,obj);
    //         }
    //     });
    // }

    function loadLogsTableBody(tableBodyData){
        var logsTableBody = [];
        for(var i = 0; i < reportQueryLogs.count; i++){
            var tempObj = {};
            tempObj.takeUpTime = reportQueryLogs.item(i).accessEndDate - reportQueryLogs.item(i).accessStartDate;
            for(var key in reportQueryLogs.item(i)){
                if(typeof reportQueryLogs.item(i)[key] === "function"){ continue;}
                if(key == "accessStartDate"){
                    tempObj[key] = reportQueryLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(reportQueryLogs.item(i)[key])):"";
                }else if(key == "accessEndDate"){
                    tempObj[key] = reportQueryLogs.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(reportQueryLogs.item(i)[key])):"";
                }else if(key == "message"){
                    tempObj[key] = reportQueryLogs.item(i)[key]?("<xmp>" + reportQueryLogs.item(i)[key] + "</xmp>"):"";
                }else{
                    tempObj[key] = reportQueryLogs.item(i)[key];
                }
            }
            logsTableBody.push(tempObj);
        }
        // var logsTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("reportLogList",{data:logsTableBody,limit:logsTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("reportLogList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("reportLogList",{height: tableBodyHeight});
        });
    }

    // table.on('sort(reportLogList)', function (obj) {
    //     var type = obj.type,
    //         field = obj.field,
    //         data = mSortBodyData,//表格的配置Data
    //         thisData = [];
    //     if(type === 'asc'){ //升序
    //         thisData = $Utils.sorter(data, field);
    //     }else if(type === 'desc'){ //降序
    //         thisData = $Utils.sorter(data, field, true);
    //     }else{ //清除排序
    //         thisData = data;
    //     }
    //     setTablePage(thisData);
    // });
    
}();