/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-13 18:03:50
 * @LastEditTime: 2020-10-28 20:21:37
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage;
    var logins = new Logins();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    
    $Utils.loading.open();
    initMain();

    function initMain(){
        initUsersTableHead();
        getAndLoadUsersTableBody();

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadUsersTableBody();
        });
    }

    function initUsersTableHead(){
        var userTableHead = [
            [
                {field: "userName",title: "用户名", sort: true},
                {field: "deviceTypeName",title: "设备", sort: true},
                {field: "osName",title: "操作系统", sort: true},
                {field: "loginDate",title: "登录时间", sort: true},
            ]
        ];
    
        table.render({
            elem: '#onlineUsersList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: userTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadUsersTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadUsersTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取登录信息列表",errorStatus,msg);
		};
		logins.getItems(true,succ,fail);
    }

    function setTableBody(){
        var usersTableBody = [];
        for(var i = 0; i < logins.count; i++){
            var tempObj = {};
            for(var key in logins.item(i)){
                if(typeof logins.item(i)[key] === "function"){ continue;}
                if(key == "loginDate"){
                    tempObj[key] = logins.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(logins.item(i)[key])):"";
                }else{
                    tempObj[key] = logins.item(i)[key];
                }
            }
            usersTableBody.push(tempObj);
        }
        return usersTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadUsersTableBody(data,obj);
            }
        });
    }

    function loadUsersTableBody(tableBodyData,obj){
        var usersTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("onlineUsersList",{data:usersTableBody,limit:usersTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("onlineUsersList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("onlineUsersList",{height: tableBodyHeight});
        });
    }

    table.on('sort(onlineUsersList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].userName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].deviceTypeName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].osName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }
    
}();