/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 13:55:42
 * @LastEditTime: 2021-02-21 18:33:45
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var linkShares = new LinkShares();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "reportName",title:"报表名称",width:120,sort:true},
                {field: "shareLink",title:"分享链接",sort:true},
                {field: "shareType",title:"分享类型",width:100,sort:true},
                {field: "shareEndDate",title:"失效时间",width:150,sort:true},
                {field: "sharePassword",title:"密码", width: 80,sort:true},
                {field: "shareDate",title:"分享时间",width:150,sort:true}
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取分享列表",errorStatus,msg);
		};
		linkShares.getItems(1,true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < linkShares.count; i++){
            var obj = {};
            obj.reportName = linkShares.item(i).reportName;
            obj.shareLink = $AppConstants.hostName + $AppConstants.port+"/Report/linkShares/"+linkShares.item(i).shareID+"/reportJSP";
            obj.shareType = linkShares.item(i).shareType?"实时页面":"历史快照";
            obj.shareDate = linkShares.item(i).shareDate?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(linkShares.item(i).shareDate)):"";
            obj.shareEndDate = linkShares.item(i).shareDays?($Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(linkShares.item(i).shareEndDate))):"不控制";
            obj.sharePassword = linkShares.item(i).sharePassword?linkShares.item(i).sharePassword:"不控制";
            obj.shareID = linkShares.item(i).shareID;
            tableBody.push(obj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                layer.open({
                    type: 0,
                    title: "删除对报表分享",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteLinkShare(table.checkStatus('objectList').data[0].shareID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }
    

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].reportName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function deleteLinkShare(shareID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除对 "+linkShares.item(shareID).reportName+" 的分享",errorStatus,msg);
        };
        linkShares.deleteItem(shareID,true,succ,fail);
    }
}();