/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-19 10:43:46
 * @LastEditTime: 2021-05-11 09:18:21
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var reportFolders = new ReportFolders();
    var reports = new Reports();
    var mFolderID = null;
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadFoldersMenus();
        treeEvent();
        bindTableEvent();
    }

    function getAndLoadFoldersMenus(){
        var succ = function () {
            getReportLists();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取报表文件列表",errorStatus,msg);
        };
        reportFolders.getItems(true,succ,fail);
    }

    function getReportLists(){
        var succ = function(){
            $Utils.loading.close();
            loadMenus();
            loadReportList("-1");
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
		};
        reports.getItems(1,true,succ,fail);
    }

    function loadMenus(){
        $(".report-folder-tree > ul").html("");
        var folderArr = setFolderTree();
        for(var i = 0; i < folderArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderid="+folderArr[i].folderID+"><div title="+folderArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+folderArr[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".report-folder-tree > ul").append(str);
            if(folderArr[i].children){
                createChildrenMenu(folderArr[i].children);
            }
        }
        $(".report-folder-tree > ul > li:first-child > div").trigger("click");
    }

    function createChildrenMenu(menuArr){
        for(var i = 0; i < menuArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderid="+menuArr[i].folderID+"><div title="+menuArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+menuArr[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".report-folder-tree > ul").find("li").each(function(){
                if($(this).attr("data-folderid") == menuArr[i].folderParentID){
                    $(this).children("ul").append(str);
                }
            });
            if(menuArr[i].children){
                createChildrenMenu(menuArr[i].children);
            }
        }
    }

    function setFolderTree(){
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{name: "组织分析",folderID:"-1",folderParentID:"-1"});
        for(var i = 0; i < reportFolders.count; i++){
            hashTable.add(reportFolders.item(i).folderID,{name:reportFolders.item(i).folderName,folderID:reportFolders.item(i).folderID,folderParentID:reportFolders.item(i).folderParentID});
        }
        for(var i = 0; i < reportFolders.count; i++){
            var parentFolder = hashTable.getValue(reportFolders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(reportFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {
                    field: "reportName", title: "名称", sort: true, templet: function (d) {
                        var str = "";
                        str = "<i class='iconfont bda-shilitubiao'></i>" + d.reportName
                        return str;
                    }
                },
                { field: "folderURL", title: "所属文件夹"},
                // {field: "createUserName",title: "创建者", sort: true},
                // { field: "createDate", title: "创建时间", sort: true, templet: function(d){
                //     if(d.createDate){
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                //     }else{
                //         return "";
                //     }
                // }},
                // {field: "lastModifyUserName",title: "修改者", sort: true},
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }},
                {title: "权限",templet: "#setAuthority",width: 80, align:"center"} 
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function treeEvent(){

        $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);

        $(".report-folder-tree > ul").on("click", "div", function () {
            if ($(this).siblings("ul").is(":hidden")) {
                $(this).siblings("ul").show(200);
                $(".report-folder-tree li").removeClass("click-folder");
                $(this).parent("li").addClass("click-folder");
                $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            } else {
                $(this).siblings("ul").hide(200);
                $(this).siblings("ul").find("ul").hide(200);
                $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                $(this).siblings("ul").find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
            }
            if ($(this).parents("ul").is(":hidden")) {
                $(this).parents("ul").show(200);
                $(this).parents("ul").siblings("div").find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            }
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").siblings("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");
            loadReportList($(this).parent("li").attr("data-folderid"));
        });
    }

    function loadReportList(folderID){
        mFolderID = folderID;
        mTableBodyData = setTableBody(folderID);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody(folderID){
        var reportsTableBody = [];
        if (folderID == "-1") {
            for (var i = 0; i < reports.count; i++) {
                var tempObj = {};
                for (var key in reports.item(i)) {
                    if (typeof reports.item(i)[key] === "function") { continue; }
                    tempObj[key] = reports.item(i)[key];
                }
                tempObj.folderURL = setFolderURL(reports.item(i).folderID);
                reportsTableBody.push(tempObj);
            }
        } else {
            var folderIDs = getFolderIDs(folderID);
            for (var i = 0; i < reports.count; i++) {
                if (folderIDs.indexOf(reports.item(i).folderID) != -1) {
                    var tempObj = {};
                    for (var key in reports.item(i)) {
                        if (typeof reports.item(i)[key] === "function") { continue; }
                        tempObj[key] = reports.item(i)[key];
                    }
                    tempObj.folderURL = setFolderURL(reports.item(i).folderID);
                    reportsTableBody.push(tempObj);
                }
            }
        }
        return reportsTableBody;
    }

    function setFolderURL(folderID) {
        var folderURL = "";
        if (folderID == "-1") {
            return "/组织分析/";
        } else {
            folderURL = reportFolders.item(folderID).folderName + "/";
            folderURL = setParentFolderURL(reportFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function setParentFolderURL(folderID, folderURL) {
        if (folderID == "-1") {
            folderURL = "/组织分析/" + folderURL
            return folderURL;
        } else {
            folderURL = reportFolders.item(folderID).folderName + "/" + folderURL;
            folderURL = setParentFolderURL(reportFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function getFolderIDs(folderID) {
        var tempArr = [];
        tempArr.push(folderID);
        if (folderID == "-1") {
            return tempArr;
        } else {
            for (var i = 0; i < reportFolders.count; i++) {
                if (reportFolders.item(i).folderParentID == folderID) {
                    tempArr.push(reportFolders.item(i).folderID);
                    return getChildrenFolderID(reportFolders.item(i).folderID, tempArr);
                }
            }
            return tempArr;
        }
    }

    function getChildrenFolderID(folderID, tempArr) {
        for (var i = 0; i < reportFolders.count; i++) {
            if (reportFolders.item(i).folderParentID == folderID) {
                tempArr.push(reportFolders.item(i).folderID);
                return getChildrenFolderID(reportFolders.item(i).folderID, tempArr);
            }
        }
        return tempArr;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        $Utils.loading.close();
        var reportsTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:reportsTableBody,limit:reportsTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            $(".object-reports-main").css("top",$(".header-box").outerHeight()+20);
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindTableEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type, field = obj.field, data = mSortBodyData, thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        table.on("tool(objectList)", function(obj){
            var report = reports.item(obj.data.reportID);
            if(obj.event == "empower" && obj.data.reportID){
                getAndLoadAuthorityListForm(report);
            }else if(obj.event == "empower" && obj.data.folderID){
                layer.msg("不能对文件夹授权。",{icon: 3});
            }else if(obj.event == "drillDown"){
                mOpenChildFolder(obj.data.folderID);
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
			getAndLoadFoldersMenus();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].reportID){
                layer.open({
                    type: 0,
                    title: "删除报表",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].reportName+" ？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteReport(table.checkStatus('objectList').data[0].reportID);
                    }
                });
            }else if(table.checkStatus('objectList').data.length && table.checkStatus('objectList').data[0].folderID){
                if(validateFolder(table.checkStatus('objectList').data[0].folderID)){
                    loadDeleteFolderWindow();
                }
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".delete-folder").click(function () {
            if (mFolderID != "-1") {
                if (validateFolder(mFolderID)) {
                    loadDeleteFolderWindow(mFolderID);
                }
            } else {
                layer.msg("不能删除根文件夹。", { icon: 2 });
            }
        });
    }

    function mOpenChildFolder(folderID){
        $(".report-folder-tree > ul").find("li").each(function(){
            if($(this).attr("data-folderid") == folderID){
                $(this).find("div").eq(0).trigger("click");
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].reportName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function validateFolder(folderID){
        for(var i = 0; i < reportFolders.count; i++){
            if(reportFolders.item(i).folderParentID == folderID){
                layer.msg("文件夹 "+reportFolders.item(i).folderName+" 包含子文件夹，不能删除。",{icon:2});
                return false;
            }
        }

        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).folderID == folderID){
                layer.msg("文件夹 "+reportFolders.item(folderID).folderName+" 包含报表，不能删除。",{icon:2});
                return false;
            }
        }

        return true;
    }

    function loadDeleteFolderWindow(folderID){
        layer.open({
            type: 0,
            title: "删除文件夹",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px", "270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 " + reportFolders.item(folderID).folderName + " ？</div></div>",
            btn: ["是", "否"],
            success: function (layero, index) {
                $(layero).find('.layui-layer-content').css('height', '137px');
            },
            yes: function (index, layero) {
                layer.close(index);
                $Utils.loading.open();
                deleteFolder(folderID);
            }
        });
    }

    function deleteFolder(folderID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            loadReportList(mFolderID);
            $(".report-folder-tree li").each(function(){
                if ($(this).attr("data-folderid") == folderID) {
                    $(this).parents("li").eq(0).children("div").trigger("click");
                    $(this).remove();
                }
            });
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除文件夹",errorStatus,msg);
		};
		reportFolders.deleteItem(folderID,true,succ,fail);
    }

    function deleteReport(reportID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            // getReportLists(mFolderID);
            loadReportList(mFolderID);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除报表",errorStatus,msg);
        };
        reports.deleteItem(reportID,true,succ,fail);
    }

    function getAndLoadAuthorityListForm(report){
        $.ajax({
            url: "html/iControl/objectSupervise/report/report.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,report)
            }
        });
    }

    function loadAuthorityListForm(strHtml,report){
        layer.open({
            type: 1,
            title: ["设置 " +report.reportName + " 的权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["600px","600px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,report);
            }
        });
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();