!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var uploadExcelTemplates = new UploadExcelTemplates();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "templateName", title: "模版名称", sort: true},
                // {field: "createUserName",title: "创建者", sort: true},
                // {field: "createDate",title: "创建时间", sort: true},
                // {field: "lastModifyUserName",title: "最后修改者", sort: true},
                {field: "createUserName",title: "上传者", sort: true},
                {field: "createDate",title: "上传时间", sort: true, width: 130, templet: function(d){
                    if(d.createDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                    }else{
                        return "";
                    }
                }},
                {title: "权限",templet: "#setAuthority",width: 80, align:"center"} 
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据源列表",errorStatus,msg);
		};
		uploadExcelTemplates.getItems(1,true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < uploadExcelTemplates.count; i++){
            var tempObj = {};
            for(var key in uploadExcelTemplates.item(i)){
                if(typeof uploadExcelTemplates.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = uploadExcelTemplates.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(uploadExcelTemplates.item(i)[key])):"";
                // }else{
                    tempObj[key] = uploadExcelTemplates.item(i)[key];
                // }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(objectList)", function(obj){
            var uploadExcelTemplate = uploadExcelTemplates.item(obj.data.templateID);
            if(obj.event == "empower"){
                getAndLoadAuthorityListForm(uploadExcelTemplate);
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                deleteWindow();
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if((mTableBodyData[i].templateName && (mTableBodyData[i].templateName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadAuthorityListForm(uploadExcelTemplate){
        $.ajax({
            url: "html/iControl/objectSupervise/excelTemplate/excelTemplate.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,uploadExcelTemplate)
            }
        });
    }

    function loadAuthorityListForm(strHtml,uploadExcelTemplate){
        layer.open({
            type: 1,
            title: ["设置 " +uploadExcelTemplate.templateName + " 的权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,uploadExcelTemplate);
            }
        });
    }

    function deleteWindow(){
        layer.open({
            type: 0,
            title: "删除Excel模版",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 "+table.checkStatus('objectList').data[0].templateName+" ？</div></div>",
            btn: ["是","否"],
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteUploadExcelTemplate(table.checkStatus('objectList').data[0].templateID);
            }
        });
    }

    function deleteUploadExcelTemplate(templateID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除数据源",errorStatus,msg);
        };
        uploadExcelTemplates.deleteItem(templateID,true,succ,fail);
    }

}();