!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var groups = new Groups();
    var organizationUsers = new OrganizationUsers();
    var groupUploadExcelTemplates = new GroupUploadExcelTemplates();
    var userUploadExcelTemplates = new UserUploadExcelTemplates();
    var mUploadExcelTemplate = null;
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mBackupsGroupUploadExcelTemplates = [];
    var mBackupsUserUploadExcelTemplates = [];
    var selectUserOrGroup = null;

    window.initAuthorityListForm = function(index,uploadExcelTemplate){
        mUploadExcelTemplate = uploadExcelTemplate;
        loadListTableHead();
        getRequisiteDataAndLoadList(uploadExcelTemplate);

        buttonEvent(index);
    };

    function loadListTableHead(){
        var tableHead = [
            [
                {field: "name", title: "名称"},
                {field: "type", title: "类型",templet:"#listType"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getRequisiteDataAndLoadList(uploadExcelTemplate){
        var succ = function(){
            $Utils.loading.close();
			getGroupsAndLoadList(uploadExcelTemplate);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
		organizationUsers.getItems(true,succ,fail);
    }

    function getGroupsAndLoadList(uploadExcelTemplate){
        var succ = function(){
            $Utils.loading.close();
			getUserUploadExcelTemplatesAndLoadList(uploadExcelTemplate);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function getUserUploadExcelTemplatesAndLoadList(uploadExcelTemplate){
        var succ = function(data){
            $Utils.loading.close();
            getGroupUploadExcelTemplatesAndLoadList(data,uploadExcelTemplate);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+uploadExcelTemplate.templateName+" 所属用户权限",errorStatus,msg);
		};
		userUploadExcelTemplates.getItemsByTemplateID(uploadExcelTemplate.templateID,true,succ,fail);
    }

    function getGroupUploadExcelTemplatesAndLoadList(userUploadExcelTemplateList,uploadExcelTemplate){
        var succ = function(data){
            $Utils.loading.close();
			loadList(userUploadExcelTemplateList,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+uploadExcelTemplate.templateName+" 所属组权限",errorStatus,msg);
		};
		groupUploadExcelTemplates.getItemsByTemplateID(uploadExcelTemplate.templateID,true,succ,fail);
    }

    function loadList(userUploadExcelTemplateList,groupUploadExcelTemplateList){
        mBackupsGroupUploadExcelTemplates = groupUploadExcelTemplateList;
        mBackupsUserUploadExcelTemplates = userUploadExcelTemplateList;
        var tableBody = [];
        for(var i = 0; i < groups.count; i++){
            if(groupUploadExcelTemplateList.indexOf(groups.item(i).groupID) != -1){
                var obj = {};
                obj.name = groups.item(i).groupName;
                obj.type = 0;
                obj.dataID = groups.item(i).groupID;
                tableBody.push(obj);
            }
        }
        for(var i = 0; i < organizationUsers.count; i++){
            if(userUploadExcelTemplateList.indexOf(organizationUsers.item(i).userID) != -1){
                var obj = {};
                obj.name = organizationUsers.item(i).userName;
                obj.type = 1;
                obj.dataID = organizationUsers.item(i).userID;
                obj.organizationUserID = organizationUsers.item(i).organizationUserID;
                tableBody.push(obj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add-group").click(function(){
            getAndLoadGroupListForm();
        });

        $(".add-user").click(function(){
            getAndLoadUsersListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteDataItem();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectUserOrGroup){
                deleteDataItem([selectUserOrGroup.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        table.on('row(list)', function(obj){
            selectUserOrGroup = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });

        $(".data-source-button .layui-btn-determine").click(function(){
            $Utils.loading.open();
            if(changeUser()){
                editUserSubmit();
            }
            if(changeGroup()){
                editGroupSubmit();
            }
            if(changeUser() || changeGroup()){
                $Utils.loading.close();
            }
            layer.close(index);
        });

        $(".data-source-button .layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function getAndLoadGroupListForm(){
        $.ajax({
            url: "html/iControl/groupList.html",
            type: 'GET',
            success: function(data){
                loadGroupsListForm(data)
            }
        });
    }

    function loadGroupsListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 0){
                        transmitData.push(groups.item(mTableBody[i].dataID));
                    }
                }
                initGroupList(index,transmitData,groups,addGroupList);
            }
        });
    }

    function getAndLoadUsersListForm(){
        $.ajax({
            url: "html/iControl/userList.html",
            type: 'GET',
            success: function(data){
                loadUsersListForm(data)
            }
        });
    }

    function loadUsersListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 1){
                        transmitData.push(organizationUsers.item(mTableBody[i].organizationUserID));
                    }
                }
                initUserList(index,transmitData,organizationUsers,addUserList);
            }
        });
    }

    function deleteDataItem(selectData){
        for(var i = 0; i < selectData.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectData[i].dataID == mTableBody[j].dataID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function changeUser(){
        var userIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                userIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsUserUploadExcelTemplates.length == 0 && userIDs.length == 0){
            return false;
        }
        

        if(mBackupsUserUploadExcelTemplates.length != userIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsUserUploadExcelTemplates.length; i++){
            if(userIDs.indexOf(mBackupsUserUploadExcelTemplates[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function changeGroup(){
        var groupIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                groupIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsGroupUploadExcelTemplates.length == 0 && groupIDs.length == 0){
            return false;
        }
        

        if(mBackupsGroupUploadExcelTemplates.length != groupIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsGroupUploadExcelTemplates.length; i++){
            if(groupIDs.indexOf(mBackupsGroupUploadExcelTemplates[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function editUserSubmit(index){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                tempArr.push(mTableBody[i].dataID);
            }
        }
        var tempObj = {};
        tempObj.templateID = mUploadExcelTemplate.templateID;
        tempObj.userIDs = tempArr;

        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改 "+mUploadExcelTemplate.templateName+" 所属用户权限",errorStatus,msg);
        };
		userUploadExcelTemplates.updateByTemplateID(tempObj,true,succ,fail);
    }

    function editGroupSubmit(index){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                tempArr.push(mTableBody[i].dataID);
            }
        }
        var tempObj = {};
        tempObj.templateID = mUploadExcelTemplate.templateID;
        tempObj.groupIDs = tempArr;

        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改 "+mUploadExcelTemplate.templateName+" 所属组权限",errorStatus,msg);
        };
		groupUploadExcelTemplates.updateByTemplateID(tempObj,true,succ,fail);
    }

    var addGroupList = function(groupList,index){
        layer.close(index);
        for(var i = 0; i < groupList.length; i++){
            var obj = {};
            obj.name = groupList[i].groupName;
            obj.type = 0;
            obj.dataID = groupList[i].groupID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };

    var addUserList = function(userList,index){
        layer.close(index);
        for(var i = 0; i < userList.length; i++){
            var obj = {};
            obj.name = userList[i].userName;
            obj.type = 1;
            obj.dataID = userList[i].userID;
            obj.organizationUserID = userList[i].organizationUserID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };
    
}();