/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 18:30:09
 * @LastEditTime: 2021-05-10 17:08:56
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var dataSources = new DataSources();
    var businessModels = new BusinessModels();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "dataSourceName", title: "名称", sort: true, templet: function(d){
                    var str = "";
                    if(d.dataSourceType == 0){
                        str = "<i class='iconfont bda-dataBase'></i>" + d.dataSourceName
                    }
                    if(d.dataSourceType == 1){
                        str = "<i class='iconfont bda-21excel'></i>" + d.dataSourceName
                    }
                    return str;
                }},
                {field: "dataSourceType", title: "数据源类型",templet: "#type", width: 100, sort: true},
                // {field: "createUserName",title: "创建者", sort: true},
                // {field: "createDate",title: "创建时间", sort: true},
                // {field: "lastModifyUserName",title: "修改者", sort: true},
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }},
                {title: "操作",templet: "#setAuthority",width: 120, align:"left"} 
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据源列表",errorStatus,msg);
		};
		dataSources.getItems(1,true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < dataSources.count; i++){
            var tempObj = {};
            for(var key in dataSources.item(i)){
                if(typeof dataSources.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = dataSources.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(dataSources.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = dataSources.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(dataSources.item(i)[key])):"";
                // }else{
                    tempObj[key] = dataSources.item(i)[key];
                // }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(objectList)", function(obj){
            var dataSource = dataSources.item(obj.data.dataSourceID);
            if(obj.event == "empower"){
                getAndLoadAuthorityListForm(dataSource);
            }else if(obj.event == "downloadExcel"){
                downLoadExcelFile(dataSource);
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                judgeIncludeModelCount();
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if((mTableBodyData[i].dataSourceName && (mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadAuthorityListForm(dataSource){
        $.ajax({
            url: "html/iControl/objectSupervise/dataSource/dataSource.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,dataSource)
            }
        });
    }

    function loadAuthorityListForm(strHtml,dataSource){
        layer.open({
            type: 1,
            title: ["设置 " +dataSource.dataSourceName + " 的权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,dataSource);
            }
        });
    }

    function downLoadExcelFile(dataSource){
        var excelFile = new ExcelFile();
        var succ = function(data){
            $Utils.loading.close();
            if (window.navigator.msSaveOrOpenBlob) {
                navigator.msSaveBlob(data[0], dataSource.dataSourceName);
            } else{
                var t = new Blob(data);
                var a = document.createElement('a');
                a.href = URL.createObjectURL(t);
                a.download = dataSource.dataSourceName;
                a.click();
                $(a).remove();
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("下载Excel文件",errorStatus,msg);
        };
        excelFile.download(dataSource.dataSourceID,true,succ,fail);
    }

    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                if(table.checkStatus('objectList').data[0].dataSourceType == 0){
                    var str = "当前数据库连接已有模型引用，如果删除将导致引用此数据库连接的模型不可用，您确定要删除该数据库连接吗？";
                }else if(table.checkStatus('objectList').data[0].dataSourceType == 1){
                    var str = "当前Excel文件已有模型引用，如果删除将导致引用此Excel文件的模型不可用，您确定要删除该Excel文件吗？";
                }
                deleteWindow(str,"bda-tips"); 
            }else{
                var str = "是否删除 "+table.checkStatus('objectList').data[0].dataSourceName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除数据库连接",errorStatus,msg);
		};
		businessModels.getUsedCount(table.checkStatus('objectList').data[0].dataSourceID,true,succ,fail);
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除数据源",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteDataSource(table.checkStatus('objectList').data[0].dataSourceID,table.checkStatus('objectList').data[0].dataSourceType);
            }
        });
    }

    function deleteDataSource(dataSourceID,dataSourceType){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除数据源",errorStatus,msg);
        };
        if(dataSourceType == 0){
            var databaseLinks = new DatabaseLinks();
            databaseLinks.deleteItem(dataSourceID,true,succ,fail);
        }else{
            var excelFiles = new ExcelFiles();
            excelFiles.deleteItem(dataSourceID,true,succ,fail);
        }
    }

}();