/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 23:51:38
 * @LastEditTime: 2021-05-10 17:08:23
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var businessModels = new BusinessModels();
    var reports = new Reports();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();
        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "businessModelName", title: "名称", sort: true, templet: function(d){
                    var str = "";
                    if(d.businessModelType == 0){
                        str = "<i class='iconfont bda-xingxingfenbu'></i>" + d.businessModelName
                    }
                    if(d.businessModelType == 1){
                        str = "<i class='iconfont bda-biao'></i>" + d.businessModelName
                    }
                    if(d.businessModelType == 2){
                        str = "<i class='iconfont bda-sql'></i>" + d.businessModelName
                    }
                    if (d.businessModelType == 3) {
                        str = "<i class='iconfont bda-excel'></i>" + d.businessModelName
                    }
                    if (d.businessModelType == 4) {
                        str = "<i class='iconfont bda-cunchuguocheng'></i>" + d.businessModelName
                    }
                    return str;
                }},
                {field: "businessModelType", title: "类型",templet: "#type", width: 100, sort: true},
                {field: "dataSourceName", title: "数据源", sort: true, width: 150},
                // {field: "description", title: "描述", sort: true},
                // {field: "createUserName",title: "创建者", sort: true},
                // {field: "createDate",title: "创建时间", sort: true},
                // {field: "lastModifyUserName",title: "最后修改者", sort: true},
                {field: "lastModifyDate",title: "最后修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }},
                {title: "权限",templet: "#setAuthority",width: 80, align:"center"} 
            ]
        ];
        table.render({
            elem: '#objectList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < businessModels.count; i++){
            var tempObj = {};
            for(var key in businessModels.item(i)){
                if(typeof businessModels.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = businessModels.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(businessModels.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = businessModels.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(businessModels.item(i)[key])):"";
                // }else{
                    tempObj[key] = businessModels.item(i)[key];
                // }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("objectList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("objectList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("objectList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(objectList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(objectList)", function(obj){
            var businessModel = businessModels.item(obj.data.businessModelID);
            if(obj.event == "empower"){
                getAndLoadAuthorityListForm(businessModel);
            }
        });

        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        $(".delete").click(function(){
            if(table.checkStatus('objectList').data.length){
                judgeIncludeModelCount();
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if((mTableBodyData[i].businessModelName && (mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1)) ||
            (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1)) ||
            (mTableBodyData[i].dataSourceName && (mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadAuthorityListForm(businessModel){
        $.ajax({
            url: "html/iControl/objectSupervise/businessModel/businessModel.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,businessModel)
            }
        });
    }

    function loadAuthorityListForm(strHtml,businessModel){
        layer.open({
            type: 1,
            title: ["设置 " +businessModel.businessModelName + " 的权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,businessModel);
            }
        });
    }
    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                var str = "当前模型已有报表引用，如果删除将导致引用此模型的报表不可用，您确定要删除该模型吗？";
                deleteWindow(str,"bda-tips");
            }else{
                var str = "是否删除业务模型 "+table.checkStatus('objectList').data[0].businessModelName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除业务模型",errorStatus,msg);
		};
		reports.getUsedCount(table.checkStatus('objectList').data[0].businessModelID,true,succ,fail);
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除业务模型",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteBusinessModel(table.checkStatus('objectList').data[0].businessModelID,table.checkStatus('objectList').data[0].businessModelType);
            }
        });
    }

    function deleteBusinessModel(businessModelID,businessModelType){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除业务模型",errorStatus,msg);
        };
        if(businessModelType == 0){
            var relationModels = new RelationModels();
            relationModels.deleteItem(businessModelID,true,succ,fail);
        }
        if(businessModelType == 1){
            var tableModels = new TableModels();
            tableModels.deleteItem(businessModelID,1,true,succ,fail);
        }
        if(businessModelType == 2){
            var sqlModels = new SqlModels();
            sqlModels.deleteItem(businessModelID,1,true,succ,fail);
        }
        if(businessModelType == 3){
            var excelModels = new ExcelModels();
            excelModels.deleteItem(businessModelID,1,true,succ,fail);
        }
    }
}();