/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-15 00:12:03
 * @LastEditTime: 2020-05-07 14:21:39
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var groups = new Groups();
    var organizationUsers = new OrganizationUsers();
    var groupBusinessModels = new GroupBusinessModels();
    var userBusinessModels = new UserBusinessModels();
    var mBusinessModel = null;
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mBackupsGroupBusinessModels = [];
    var mBackupsUserBusinessModels = [];
    var selectUserOrGroup = null;

    window.initAuthorityListForm = function(index,businessModel){
        mBusinessModel = businessModel;
        loadListTableHead();
        getRequisiteDataAndLoadList(businessModel);

        buttonEvent(index);
    };

    function loadListTableHead(){
        var tableHead = [
            [
                {field: "name", title: "名称"},
                {field: "type", title: "类型",templet:"#listType"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getRequisiteDataAndLoadList(businessModel){
        var succ = function(){
            $Utils.loading.close();
			getGroupsAndLoadList(businessModel);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
		organizationUsers.getItems(true,succ,fail);
    }

    function getGroupsAndLoadList(businessModel){
        var succ = function(){
            $Utils.loading.close();
			getUserBusinessModelsAndLoadList(businessModel);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function getUserBusinessModelsAndLoadList(businessModel){
        var succ = function(data){
            $Utils.loading.close();
            getGroupBusinessModelsAndLoadList(data,businessModel);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+businessModel.businessModelName+" 所属用户权限",errorStatus,msg);
		};
		userBusinessModels.getItemsByBusinessModelID(businessModel.businessModelID,true,succ,fail);
    }

    function getGroupBusinessModelsAndLoadList(userBusinessModelList,businessModel){
        var succ = function(data){
            $Utils.loading.close();
			loadList(userBusinessModelList,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+businessModel.businessModelName+" 所属组权限",errorStatus,msg);
		};
		groupBusinessModels.getItemsByBusinessModelID(businessModel.businessModelID,true,succ,fail);
    }

    function loadList(userBusinessModelList,groupBusinessModelList){
        mBackupsGroupBusinessModels = groupBusinessModelList;
        mBackupsUserBusinessModels = userBusinessModelList;
        var tableBody = [];
        for(var i = 0; i < groups.count; i++){
            if(groupBusinessModelList.indexOf(groups.item(i).groupID) != -1){
                var obj = {};
                obj.name = groups.item(i).groupName;
                obj.type = 0;
                obj.dataID = groups.item(i).groupID;
                tableBody.push(obj);
            }
        }
        for(var i = 0; i < organizationUsers.count; i++){
            if(userBusinessModelList.indexOf(organizationUsers.item(i).userID) != -1){
                var obj = {};
                obj.name = organizationUsers.item(i).userName;
                obj.type = 1;
                obj.dataID = organizationUsers.item(i).userID;
                obj.organizationUserID = organizationUsers.item(i).organizationUserID;
                tableBody.push(obj);
            }
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add-group").click(function(){
            getAndLoadGroupListForm();
        });

        $(".add-user").click(function(){
            getAndLoadUsersListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteDataItem();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectUserOrGroup){
                deleteDataItem([selectUserOrGroup.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        table.on('row(list)', function(obj){
            selectUserOrGroup = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });

        $(".business-model-button .layui-btn-determine").click(function(){
            $Utils.loading.open();
            if(changeUser()){
                editUserSubmit();
            }
            if(changeGroup()){
                editGroupSubmit();
            }
            if(changeUser() || changeGroup()){
                $Utils.loading.close();
            }
            layer.close(index);
        });

        $(".business-model-button .layui-btn-cancel").click(function(){
            layer.close(index);
        });
    }

    function getAndLoadGroupListForm(){
        $.ajax({
            url: "html/iControl/groupList.html",
            type: 'GET',
            success: function(data){
                loadGroupsListForm(data)
            }
        });
    }

    function loadGroupsListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 0){
                        transmitData.push(groups.item(mTableBody[i].dataID));
                    }
                }
                initGroupList(index,transmitData,groups,addGroupList);
            }
        });
    }

    function getAndLoadUsersListForm(){
        $.ajax({
            url: "html/iControl/userList.html",
            type: 'GET',
            success: function(data){
                loadUsersListForm(data)
            }
        });
    }

    function loadUsersListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 1){
                        transmitData.push(organizationUsers.item(mTableBody[i].organizationUserID));
                    }
                }
                initUserList(index,transmitData,organizationUsers,addUserList);
            }
        });
    }

    function deleteDataItem(selectData){
        for(var i = 0; i < selectData.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectData[i].dataID == mTableBody[j].dataID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function changeUser(){
        var userIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                userIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsUserBusinessModels.length == 0 && userIDs.length == 0){
            return false;
        }
        

        if(mBackupsUserBusinessModels.length != userIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsUserBusinessModels.length; i++){
            if(userIDs.indexOf(mBackupsUserBusinessModels[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function changeGroup(){
        var groupIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                groupIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsGroupBusinessModels.length == 0 && groupIDs.length == 0){
            return false;
        }
        

        if(mBackupsGroupBusinessModels.length != groupIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsGroupBusinessModels.length; i++){
            if(groupIDs.indexOf(mBackupsGroupBusinessModels[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function editUserSubmit(){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                tempArr.push(mTableBody[i].dataID);
            }
        }
        var tempObj = {};
        tempObj.businessModelID = mBusinessModel.businessModelID;
        tempObj.userIDs = tempArr;

        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改 "+mBusinessModel.businessModelName+" 所属用户权限",errorStatus,msg);
        };
		userBusinessModels.updateByBusinessModelID(tempObj,true,succ,fail);
    }

    function editGroupSubmit(){
        var tempArr = [];

        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                tempArr.push(mTableBody[i].dataID);
            }
        }
        var tempObj = {};
        tempObj.businessModelID = mBusinessModel.businessModelID;
        tempObj.groupIDs = tempArr;

        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改 "+mBusinessModel.businessModelName+" 所属组权限",errorStatus,msg);
        };
		groupBusinessModels.updateByBusinessModelID(tempObj,true,succ,fail);
    }

    var addGroupList = function(groupList,index){
        layer.close(index);
        for(var i = 0; i < groupList.length; i++){
            var obj = {};
            obj.name = groupList[i].groupName;
            obj.type = 0;
            obj.dataID = groupList[i].groupID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };

    var addUserList = function(userList,index){
        layer.close(index);
        for(var i = 0; i < userList.length; i++){
            var obj = {};
            obj.name = userList[i].userName;
            obj.type = 1;
            obj.dataID = userList[i].userID;
            obj.organizationUserID = userList[i].organizationUserID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };
    
}();