function ReportQueryLog(){
    this.logID = null;
    this.organizationID = null;
    this.userID = null;
    this.moduleID = null;
    this.deviceTypeID = null;
    this.osID = null;
    this.reportID = null;
    this.statusCode = null;
    this.message = null;
    this.accessStartDate = null;
    this.accessEndDate = null;
    this.moduleName = null;
    this.userName = null;
    this.reportName = null;
    this.deviceTypeName = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function ReportQueryLogs(){
    var me = this;
    this.count = 0;
    this.aryReportQueryLogs = [];
    this.dicReportQueryLogs = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReportQueryLogs[indexOrKey];
        }else{
            return this.dicReportQueryLogs[indexOrKey];
        }
    };
    this.add = function (reportQueryLog) {
        this.aryReportQueryLogs.push(reportQueryLog);
        this.dicReportQueryLogs[reportQueryLog.logID] = reportQueryLog;
        this.count = this.aryReportQueryLogs.length;
    };
    this.remove = function (reportQueryLog) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReportQueryLogs[i].logID==reportQueryLog.logID){
                k = i;
                break;
            }
        }
        this.aryReportQueryLogs.splice(k,1);
        delete this.dicReportQueryLogs[reportQueryLog.logID];
        this.count = this.aryReportQueryLogs.length;
    };
    this.getItems = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportQueryLog + "?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReportQueryLogs(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getCount = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportQueryLog + "/recordCount?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReportQueryLogs(data){
        me.count = 0;
        me.aryReportQueryLogs = [];
        me.dicReportQueryLogs = {};
        for(var i = 0; i < data.length; i++){
            var reportQueryLog = new ReportQueryLog();
            reportQueryLog.init(data[i]);
            me.add(reportQueryLog);
        }
    }
}

function GroupModule(){
    this.groupID = null;
    this.moduleID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GroupModules(){
    var me = this;
    this.count = 0;
    this.aryGroupModules = [];
    this.dicGroupModules = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGroupModules[indexOrKey];
        }else{
            return this.dicGroupModules[indexOrKey];
        }
    };
    this.add = function (groupModule) {
        this.aryGroupModules.push(groupModule);
        this.dicGroupModules[groupModule.moduleID] = groupModule;
        this.count = this.aryGroupModules.length;
    };
    this.remove = function (groupModule) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGroupModules[i].moduleID==groupModule.moduleID){
                k = i;
                break;
            }
        }
        this.aryGroupModules.splice(k,1);
        delete this.dicGroupModules[groupModule.moduleID];
        this.count = this.aryGroupModules.length;
    };
    this.getItems = function(groupID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupID + "/groupModules/moduleIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.update = function(groupModulesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupModulesObj.groupID + "/groupModules";
        var obj = JSON.stringify(groupModulesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGroupModules(data){
        me.count = 0;
        me.aryGroupModules = [];
        me.dicGroupModules = {};
        for(var i = 0; i < data.length; i++){
            var groupModule = new GroupModule();
            groupModule.init(data[i]);
            me.add(groupModule);
        }
    }
}

function UserModule(){
    this.userID = null;
    this.moduleID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UserModules(){
    var me = this;
    this.count = 0;
    this.aryUserModules = [];
    this.dicUserModules = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserModules[indexOrKey];
        }else{
            return this.dicUserModules[indexOrKey];
        }
    };
    this.add = function (userModule) {
        this.aryUserModules.push(userModule);
        this.dicUserModules[userModule.moduleID] = userModule;
        this.count = this.aryUserModules.length;
    };
    this.remove = function (userModule) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserModules[i].moduleID==userModule.moduleID){
                k = i;
                break;
            }
        }
        this.aryUserModules.splice(k,1);
        delete this.dicUserModules[userModule.moduleID];
        this.count = this.aryUserModules.length;
    };
    this.getSelfModules = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userSelf/userModules/moduleIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getInheritModules = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userGroups/userModules/moduleIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.update = function(userModulesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userModulesObj.userID + "/userModules";
        var obj = JSON.stringify(userModulesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserModules(data){
        me.count = 0;
        me.aryUserModules = [];
        me.dicUserModules = {};
        for(var i = 0; i < data.length; i++){
            var userModule = new UserModule();
            userModule.init(data[i]);
            me.add(userModule);
        }
    }
}

function GroupDataSource(){
    this.groupID = null;
    this.dataSourceID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GroupDataSources(){
    var me = this;
    this.count = 0;
    this.aryGroupDataSources = [];
    this.dicGroupDataSources = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGroupDataSources[indexOrKey];
        }else{
            return this.dicGroupDataSources[indexOrKey];
        }
    };
    this.add = function (groupDataSource) {
        this.aryGroupDataSources.push(groupDataSource);
        this.dicGroupDataSources[groupDataSource.dataSourceID] = groupDataSource;
        this.count = this.aryGroupDataSources.length;
    };
    this.remove = function (groupDataSource) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGroupDataSources[i].dataSourceID==groupDataSource.dataSourceID){
                k = i;
                break;
            }
        }
        this.aryGroupDataSources.splice(k,1);
        delete this.dicGroupDataSources[groupDataSource.dataSourceID];
        this.count = this.aryGroupDataSources.length;
    };
    this.getItems = function(groupID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupID + "/groupDataSources/dataSourceIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByDataSourceID = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlDataSourcePath + "/" + dataSourceID + "/dataSourceGroups/groupIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByGroupID = function(groupDataSourcesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupDataSourcesObj.groupID + "/groupDataSources";
        var obj = JSON.stringify(groupDataSourcesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByDataSourceID = function(dataSourceGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlDataSourcePath + "/" + dataSourceGroupsObj.dataSourceID + "/dataSourceGroups";
        var obj = JSON.stringify(dataSourceGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGroupDataSources(data){
        me.count = 0;
        me.aryGroupDataSources = [];
        me.dicGroupDataSources = {};
        for(var i = 0; i < data.length; i++){
            var groupDataSource = new GroupDataSource();
            groupDataSource.init(data[i]);
            me.add(groupDataSource);
        }
    }
}

function UserDataSource(){
    this.userID = null;
    this.dataSourceID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UserDataSources(){
    var me = this;
    this.count = 0;
    this.aryUserDataSources = [];
    this.dicUserDataSources = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserDataSources[indexOrKey];
        }else{
            return this.dicUserDataSources[indexOrKey];
        }
    };
    this.add = function (userDataSource) {
        this.aryUserDataSources.push(userDataSource);
        this.dicUserDataSources[userDataSource.dataSourceID] = userDataSource;
        this.count = this.aryUserDataSources.length;
    };
    this.remove = function (userDataSource) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserDataSources[i].dataSourceID==userDataSource.dataSourceID){
                k = i;
                break;
            }
        }
        this.aryUserDataSources.splice(k,1);
        delete this.dicUserDataSources[userDataSource.dataSourceID];
        this.count = this.aryUserDataSources.length;
    };
    this.getSelfDataSources = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userSelf/userDataSources/dataSourceIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getInheritDataSources = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userGroups/userDataSources/dataSourceIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByDataSourceID = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlDataSourcePath + "/" + dataSourceID + "/dataSourceUsers/userIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByUserID = function(userDataSourcesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userDataSourcesObj.userID + "/userDataSources";
        var obj = JSON.stringify(userDataSourcesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByDataSourceID = function(dataSourceGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlDataSourcePath + "/" + dataSourceGroupsObj.dataSourceID + "/dataSourceUsers";
        var obj = JSON.stringify(dataSourceGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserDataSources(data){
        me.count = 0;
        me.aryUserDataSources = [];
        me.dicUserDataSources = {};
        for(var i = 0; i < data.length; i++){
            var userDataSource = new UserDataSource();
            userDataSource.init(data[i]);
            me.add(userDataSource);
        }
    }
}

function GroupBusinessModel(){
    this.groupID = null;
    this.businessModelID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GroupBusinessModels(){
    var me = this;
    this.count = 0;
    this.aryGroupBusinessModels = [];
    this.dicGroupBusinessModels = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGroupBusinessModels[indexOrKey];
        }else{
            return this.dicGroupBusinessModels[indexOrKey];
        }
    };
    this.add = function (groupBusinessModel) {
        this.aryGroupBusinessModels.push(groupBusinessModel);
        this.dicGroupBusinessModels[groupBusinessModel.businessModelID] = groupBusinessModel;
        this.count = this.aryGroupBusinessModels.length;
    };
    this.remove = function (groupBusinessModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGroupBusinessModels[i].businessModelID==groupBusinessModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryGroupBusinessModels.splice(k,1);
        delete this.dicGroupBusinessModels[groupBusinessModel.businessModelID];
        this.count = this.aryGroupBusinessModels.length;
    };
    this.getItems = function(groupID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupID + "/groupBusinessModels/businessModelIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByBusinessModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlBusinessModelPath + "/" + businessModelID + "/businessModelGroups/groupIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByGroupID = function(groupBusinessModelsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupBusinessModelsObj.groupID + "/groupBusinessModels";
        var obj = JSON.stringify(groupBusinessModelsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByBusinessModelID = function(businessModelGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlBusinessModelPath + "/" + businessModelGroupsObj.businessModelID + "/businessModelGroups";
        var obj = JSON.stringify(businessModelGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGroupBusinessModels(data){
        me.count = 0;
        me.aryGroupBusinessModels = [];
        me.dicGroupBusinessModels = {};
        for(var i = 0; i < data.length; i++){
            var groupBusinessModel = new GroupBusinessModel();
            groupBusinessModel.init(data[i]);
            me.add(groupBusinessModel);
        }
    }
}

function UserBusinessModel(){
    this.userID = null;
    this.businessModelID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UserBusinessModels(){
    var me = this;
    this.count = 0;
    this.aryUserBusinessModels = [];
    this.dicUserBusinessModels = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserBusinessModels[indexOrKey];
        }else{
            return this.dicUserBusinessModels[indexOrKey];
        }
    };
    this.add = function (userBusinessModel) {
        this.aryUserBusinessModels.push(userBusinessModel);
        this.dicUserBusinessModels[userBusinessModel.businessModelID] = userBusinessModel;
        this.count = this.aryUserBusinessModels.length;
    };
    this.remove = function (userBusinessModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserBusinessModels[i].businessModelID==userBusinessModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryUserBusinessModels.splice(k,1);
        delete this.dicUserBusinessModels[userBusinessModel.businessModelID];
        this.count = this.aryUserBusinessModels.length;
    };
    this.getSelfBusinessModels = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userSelf/userBusinessModels/businessModelIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getInheritBusinessModels = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userGroups/userBusinessModels/businessModelIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByBusinessModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlBusinessModelPath + "/" + businessModelID + "/businessModelUsers/userIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByUserID = function(userBusinessModelsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userBusinessModelsObj.userID + "/userBusinessModels";
        var obj = JSON.stringify(userBusinessModelsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByBusinessModelID = function(businessModelGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlBusinessModelPath + "/" + businessModelGroupsObj.businessModelID + "/businessModelUsers";
        var obj = JSON.stringify(businessModelGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserBusinessModels(data){
        me.count = 0;
        me.aryUserBusinessModels = [];
        me.dicUserBusinessModels = {};
        for(var i = 0; i < data.length; i++){
            var userBusinessModel = new UserBusinessModel();
            userBusinessModel.init(data[i]);
            me.add(userBusinessModel);
        }
    }
}

function GroupReport(){
    this.groupID = null;
    this.reportID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GroupReports(){
    var me = this;
    this.count = 0;
    this.aryGroupReports = [];
    this.dicGroupReports = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGroupReports[indexOrKey];
        }else{
            return this.dicGroupReports[indexOrKey];
        }
    };
    this.add = function (groupReport) {
        this.aryGroupReports.push(groupReport);
        this.dicGroupReports[groupReport.reportID] = groupReport;
        this.count = this.aryGroupReports.length;
    };
    this.remove = function (groupReport) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGroupReports[i].reportID==groupReport.reportID){
                k = i;
                break;
            }
        }
        this.aryGroupReports.splice(k,1);
        delete this.dicGroupReports[groupReport.reportID];
        this.count = this.aryGroupReports.length;
    };
    this.getItems = function(groupID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupID + "/groupReports/reportIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByReportID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlReportModelPath + "/" + reportID + "/reportGroups/groupIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByGroupID = function(groupReportsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupReportsObj.groupID + "/groupReports";
        var obj = JSON.stringify(groupReportsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByReportID = function(reportGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlReportModelPath + "/" + reportGroupsObj.reportID + "/reportGroups";
        var obj = JSON.stringify(reportGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGroupReports(data){
        me.count = 0;
        me.aryGroupReports = [];
        me.dicGroupReports = {};
        for(var i = 0; i < data.length; i++){
            var groupReport = new GroupReport();
            groupReport.init(data[i]);
            me.add(groupReport);
        }
    }
}

function UserReport(){
    this.userID = null;
    this.reportID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UserReports(){
    var me = this;
    this.count = 0;
    this.aryUserReports = [];
    this.dicUserReports = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserReports[indexOrKey];
        }else{
            return this.dicUserReports[indexOrKey];
        }
    };
    this.add = function (userReport) {
        this.aryUserReports.push(userReport);
        this.dicUserReports[userReport.reportID] = userReport;
        this.count = this.aryUserReports.length;
    };
    this.remove = function (userReport) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserReports[i].reportID==userReport.reportID){
                k = i;
                break;
            }
        }
        this.aryUserReports.splice(k,1);
        delete this.dicUserReports[userReport.reportID];
        this.count = this.aryUserReports.length;
    };
    this.getSelfReports = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userSelf/userReports/reportIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getInheritReports = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userGroups/userReports/reportIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByReportID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlReportModelPath + "/" + reportID + "/reportUsers/userIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByUserID = function(userReportsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userReportsObj.userID + "/userReports";
        var obj = JSON.stringify(userReportsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByReportID = function(reportGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlReportModelPath + "/" + reportGroupsObj.reportID + "/reportUsers";
        var obj = JSON.stringify(reportGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserReports(data){
        me.count = 0;
        me.aryUserReports = [];
        me.dicUserReports = {};
        for(var i = 0; i < data.length; i++){
            var userReport = new UserReport();
            userReport.init(data[i]);
            me.add(userReport);
        }
    }
}

function OfficeTemplate(){
    this.templateID = null;
    this.templateType = null;
    this.templateURL = null;
    this.templateName = null;

    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;

    this.download = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.officeTemplatePath + "/" + this.templateID + "/file";
        var obj = "";
        var dataType = 'blob';
        var succCallback = function(data){
            succ(data);
        }
        var failCallback = function (status,statusText) {
            
            if(status == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(statusText == "timeout"){
                fail("请求超时。");
            }else if(status || status == 0){
                fail(status,statusText);
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.downLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function OfficeTemplates(){
    var me = this;
    this.count = 0;
    this.aryOfficeTemplates = [];
    this.dicOfficeTemplates = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryOfficeTemplates[indexOrKey];
        }else{
            return this.dicOfficeTemplates[indexOrKey];
        }
    };
    this.add = function (officeTemplate) {
        this.aryOfficeTemplates.push(officeTemplate);
        this.dicOfficeTemplates[officeTemplate.templateID] = officeTemplate;
        this.count = this.aryOfficeTemplates.length;
    };
    this.remove = function (officeTemplate) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryOfficeTemplates[i].templateID==officeTemplate.templateID){
                k = i;
                break;
            }
        }
        this.aryOfficeTemplates.splice(k,1);
        delete this.dicOfficeTemplates[officeTemplate.templateID];
        this.count = this.aryOfficeTemplates.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.officeTemplatePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOfficeTemplates(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(officeTemplate,templateType,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.officeTemplatePath + "?templateType=" + templateType;
        var obj = officeTemplate;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(templateID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.officeTemplatePath + "/" + templateID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(templateID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setOfficeTemplates(data){
        me.count = 0;
        me.aryOfficeTemplates = [];
        me.dicOfficeTemplates = {};
        for(var i = 0; i < data.length; i++){
            var officeTemplate = new OfficeTemplate();
            officeTemplate.init(data[i]);
            me.add(officeTemplate);
        }
    }
}

function ReportImage(){
    this.imageID = null;
    this.imageURL = null;
    this.imageName = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function ReportImages(){
    var me = this;
    this.count = 0;
    this.aryReportImages = [];
    this.dicReportImages = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReportImages[indexOrKey];
        }else{
            return this.dicReportImages[indexOrKey];
        }
    };
    this.add = function (reportImage) {
        this.aryReportImages.push(reportImage);
        this.dicReportImages[reportImage.imageID] = reportImage;
        this.count = this.aryReportImages.length;
    };
    this.remove = function (reportImage) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReportImages[i].imageID==reportImage.imageID){
                k = i;
                break;
            }
        }
        this.aryReportImages.splice(k,1);
        delete this.dicReportImages[reportImage.imageID];
        this.count = this.aryReportImages.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportImagePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReportImages(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(reportImage,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportImagePath;
        var obj = reportImage;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(imageID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportImagePath + "/" + imageID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(imageID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReportImages(data){
        me.count = 0;
        me.aryReportImages = [];
        me.dicReportImages = {};
        for(var i = 0; i < data.length; i++){
            var reportImage = new ReportImage();
            reportImage.init(data[i]);
            me.add(reportImage);
        }
    }
}

function GeographyObjectCompare(){
    var me = this;
    this.geoObjectCompareID = null;
    this.geoLevel = null;
    this.businessModelType = null;
    this.businessModelID = null;
    this.businessModelName = null;
    this.businessObjectID = null;
    this.businessObjectName = null;
    this.geographyDataCompares = new GeographyDataCompares();

    this.getDetails = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.geographyComparesPath + "/" + this.geoObjectCompareID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.init = function(options){
        for(var key in options){
            if(key == "geographyDataCompares"){
                this[key].setGeographyDataCompares(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function GeographyObjectCompares(){
    var me = this;
    this.count = 0;
    this.aryGeographyObjectCompares = [];
    this.dicGeographyObjectCompares = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGeographyObjectCompares[indexOrKey];
        }else{
            return this.dicGeographyObjectCompares[indexOrKey];
        }
    };
    this.add = function (geographyObjectCompare) {
        this.aryGeographyObjectCompares.push(geographyObjectCompare);
        this.dicGeographyObjectCompares[geographyObjectCompare.geoObjectCompareID] = geographyObjectCompare;
        this.count = this.aryGeographyObjectCompares.length;
    };
    this.remove = function (geographyObjectCompare) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGeographyObjectCompares[i].geoObjectCompareID==geographyObjectCompare.geoObjectCompareID){
                k = i;
                break;
            }
        }
        this.aryGeographyObjectCompares.splice(k,1);
        delete this.dicGeographyObjectCompares[geographyObjectCompare.geoObjectCompareID];
        this.count = this.aryGeographyObjectCompares.length;
    };
    this.addItem = function(geographyObjectCompare,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.geographyComparesPath;
        var obj = JSON.stringify(geographyObjectCompare);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(geographyObjectCompare,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.geographyComparesPath + "/" + geographyObjectCompare.geoObjectCompareID;
        var obj = JSON.stringify(geographyObjectCompare);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(geoObjectCompareID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.geographyComparesPath + "/" + geoObjectCompareID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(geoObjectCompareID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.geographyComparesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setGeographyObjectCompares(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGeographyObjectCompares(data){
        me.count = 0;
        me.aryGeographyObjectCompares = [];
        me.dicGeographyObjectCompares = {};
        for(var i = 0; i < data.length; i++){
            var geographyObjectCompare = new GeographyObjectCompare();
            geographyObjectCompare.init(data[i]);
            me.add(geographyObjectCompare);
        }
    }
}

function GeographyDataCompare(){
    this.geoDataCompareID = null;
    this.geoObjectCompareID = null;
    this.mapGeoName = null;
    this.objectGeoName = null;
    this.parentID = null;
    this.longitude = null;
    this.latitude = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GeographyDataCompares(){
    var me = this;
    this.count = 0;
    this.aryGeographyDataCompares = [];
    this.dicGeographyDataCompares = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGeographyDataCompares[indexOrKey];
        }else{
            return this.dicGeographyDataCompares[indexOrKey];
        }
    };
    this.add = function (geographyDataCompare) {
        this.aryGeographyDataCompares.push(geographyDataCompare);
        this.dicGeographyDataCompares[geographyDataCompare.geoDataCompareID] = geographyDataCompare;
        this.count = this.aryGeographyDataCompares.length;
    };
    this.remove = function (geographyDataCompare) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryGeographyDataCompares[i].geoDataCompareID==geographyDataCompare.geoDataCompareID){
                k = i;
                break;
            }
        }
        this.aryGeographyDataCompares.splice(k,1);
        delete this.dicGeographyDataCompares[geographyDataCompare.geoDataCompareID];
        this.count = this.aryGeographyDataCompares.length;
    };
    this.setGeographyDataCompares = function(data){
        this.count = 0;
        this.aryGeographyDataCompares = [];
        this.dicGeographyDataCompares = {};
        for(var i = 0; i < data.length; i++){
            var geographyDataCompare = new GeographyDataCompare();
            geographyDataCompare.init(data[i]);
            this.add(geographyDataCompare);
        }
    };
}

function Planet(){
    this.planetID = null;
    this.planetCode = null;
    this.planetName = null;
    this.countries = new Countries();
    this.haveMap = null;
    this.haveChildMap = null;

    this.init = function(options){
        for(var key in options){
            if(key == "countries" && options[key]){
                this[key].setCountries(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function Planets(){
    var me = this;
    this.count = 0;
    this.aryPlanets = [];
    this.dicPlanets = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPlanets[indexOrKey];
        }else{
            return this.dicPlanets[indexOrKey];
        }
    };
    this.add = function (planet) {
        this.aryPlanets.push(planet);
        this.dicPlanets[planet.planetID] = planet;
        this.count = this.aryPlanets.length;
    };
    this.remove = function (planet) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPlanets[i].planetID==planet.planetID){
                k = i;
                break;
            }
        }
        this.aryPlanets.splice(k,1);
        delete this.dicPlanets[planet.planetID];
        this.count = this.aryPlanets.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.planetsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setPlanets(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setPlanets(data){
        me.count = 0;
        me.aryPlanets = [];
        me.dicPlanets = {};
        for(var i = 0; i < data.length; i++){
            var planet = new Planet();
            planet.init(data[i]);
            me.add(planet);
        }
    }
}

function County(){
    this.countyID = null;
    this.countyCode = null;
    this.countyName = null;
    this.cityID = null;
    this.haveMap = 0;
    this.haveChildMap = 0;
    this.longitude = null;
    this.latitude = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Counties(){
    var me = this;
    this.count = 0;
    this.aryCounties = [];
    this.dicCounties = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCounties[indexOrKey];
        }else{
            return this.dicCounties[indexOrKey];
        }
    };
    this.add = function (county) {
        this.aryCounties.push(county);
        this.dicCounties[county.countyID] = county;
        this.count = this.aryCounties.length;
    };
    this.remove = function (county) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCounties[i].countyID==county.countyID){
                k = i;
                break;
            }
        }
        this.aryCounties.splice(k,1);
        delete this.dicCounties[county.countyID];
        this.count = this.aryCounties.length;
    };    
    this.setCounties = function(data){
        me.count = 0;
        me.aryCounties = [];
        me.dicCounties = {};
        for(var i = 0; i < data.length; i++){
            var county = new County();
            county.init(data[i]);
            me.add(county);
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.countiesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setCounties(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByCityID = function(cityID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.countiesPath + "?cityID=" + cityID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setCounties(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function GroupUploadExcelTemplate(){
    this.groupID = null;
    this.organizationID = null;
    this.templateID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function GroupUploadExcelTemplates(){
    var me = this;
    this.count = 0;
    this.aryGroupUploadExcelTemplates = [];
    this.dicGroupUploadExcelTemplates = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryGroupUploadExcelTemplates[indexOrKey];
        }else{
            return this.dicGroupUploadExcelTemplates[indexOrKey];
        }
    };
    this.add = function (groupModule) {
        this.aryGroupUploadExcelTemplates.push(groupModule);
        this.dicGroupUploadExcelTemplates[groupModule.templateID] = groupModule;
        this.count = this.aryGroupUploadExcelTemplates.length;
    };
    this.getItems = function(groupID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupID + "/groupUploadExcelTemplates/templateIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByTemplateID = function(templateID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlUploadExcelTempaltesPath + "/" + templateID + "/uploadExcelTemplateGroups/groupIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByGroupID = function(groupUploadExcelTemplatesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.groupsPath + "/" + groupUploadExcelTemplatesObj.groupID + "/groupUploadExcelTemplates";
        var obj = JSON.stringify(groupUploadExcelTemplatesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByTemplateID = function(uploadExcelTemplateGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlUploadExcelTempaltesPath + "/" + uploadExcelTemplateGroupsObj.templateID + "/uploadExcelTemplateGroups";
        var obj = JSON.stringify(uploadExcelTemplateGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setGroupUploadExcelTemplates(data){
        me.count = 0;
        me.aryGroupUploadExcelTemplates = [];
        me.dicGroupUploadExcelTemplates = {};
        for(var i = 0; i < data.length; i++){
            var groupModule = new GroupUploadExcelTemplate();
            groupModule.init(data[i]);
            me.add(groupModule);
        }
    }
}

function UserUploadExcelTemplate(){
    this.userID = null;
    this.templateID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function UserUploadExcelTemplates(){
    var me = this;
    this.count = 0;
    this.aryUserUploadExcelTemplates = [];
    this.dicUserUploadExcelTemplates = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserUploadExcelTemplates[indexOrKey];
        }else{
            return this.dicUserUploadExcelTemplates[indexOrKey];
        }
    };
    this.add = function (userModule) {
        this.aryUserUploadExcelTemplates.push(userModule);
        this.dicUserUploadExcelTemplates[userModule.templateID] = userModule;
        this.count = this.aryUserUploadExcelTemplates.length;
    };
    this.remove = function (userModule) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserUploadExcelTemplates[i].templateID==userModule.templateID){
                k = i;
                break;
            }
        }
        this.aryUserUploadExcelTemplates.splice(k,1);
        delete this.dicUserUploadExcelTemplates[userModule.templateID];
        this.count = this.aryUserUploadExcelTemplates.length;
    };
    this.getSelfUploadExcelTemplates = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userSelf/userUploadExcelTemplates/templateIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
           
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getInheritUploadExcelTemplates = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/userGroups/userUploadExcelTemplates/templateIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByTemplateID = function(templateID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlUploadExcelTempaltesPath + "/" + templateID + "/uploadExcelTemplateUsers/userIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByUserID = function(userUploadExcelTempaltesObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userUploadExcelTempaltesObj.userID + "/userUploadExcelTemplates";
        var obj = JSON.stringify(userUploadExcelTempaltesObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateByTemplateID = function(uploadExcelTempalteGroupsObj,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.controlUploadExcelTempaltesPath + "/" + uploadExcelTempalteGroupsObj.templateID + "/uploadExcelTemplateUsers";
        var obj = JSON.stringify(uploadExcelTempalteGroupsObj);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserUploadExcelTemplates(data){
        me.count = 0;
        me.aryUserUploadExcelTemplates = [];
        me.dicUserUploadExcelTemplates = {};
        for(var i = 0; i < data.length; i++){
            var userModule = new UserUploadExcelTemplate();
            userModule.init(data[i]);
            me.add(userModule);
        }
    }
}

function ResourceFile(){
    this.id = null;
    this.fileType = null;
    this.fileName = null;
    this.folderID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function ResourceFiles(){
    var me = this;
    this.count = 0;
    this.aryResourceFiles = [];
    this.dicResourceFiles = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryResourceFiles[indexOrKey];
        }else{
            return this.dicResourceFiles[indexOrKey];
        }
    };
    this.add = function (resourceFile) {
        this.aryResourceFiles.push(resourceFile);
        this.dicResourceFiles[resourceFile.id] = resourceFile;
        this.count = this.aryResourceFiles.length;
    };
    this.remove = function (resourceFile) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryResourceFiles[i].id==resourceFile.id){
                k = i;
                break;
            }
        }
        this.aryResourceFiles.splice(k,1);
        delete this.dicResourceFiles[resourceFile.id];
        this.count = this.aryResourceFiles.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.resourceFilePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setResourceFiles(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(file,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.resourceFilePath;
        var obj = file;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setResourceFiles(data){
        me.count = 0;
        me.aryResourceFiles = [];
        me.dicResourceFiles = {};
        for(var i = 0; i < data.length; i++){
            var resourceFile = new ResourceFile();
            resourceFile.init(data[i]);
            me.add(resourceFile);
        }
    }
}