/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-09 09:42:02
 * @LastEditTime: 2021-01-14 15:06:35
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer;
    var menus = new Menus();
    
    $Utils.loading.open();
    initControl();

    function initControl(){
        loadModuleTitle();
        getAndLoadControlMenus();

        $(".left-menu-cnt .menu-list > ul").on("click","div",function(){
            $(".left-menu-cnt .menu-list > ul").find(".select-menu").removeClass("select-menu");
            if($(this).parent("li").hasClass("folder")){
                $(this).parents("li").addClass("select-menu");
                if($(this).siblings("ul").is(":hidden")){
                    $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    $(this).siblings("ul").show(200);
                }else{
                    $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                    $(this).siblings("ul").hide(200);
                }
            }else{
                if(!$(this).parent("li").hasClass("select-menu")){
                    $(this).parents("li").addClass("select-menu");
                    loadMenuList($(this).parent("li").attr("data-menucode"),this);
                }
            }
        });
    }

    function loadModuleTitle(){
        var nameCn = "系统管理";
        var nameOther = "iControl";
        $(".module-title p").html("<span class='module-name'>"+nameCn+"</span> / <span class='module-name-other-language'>"+nameOther+"</span>");
    }

    function getAndLoadControlMenus(){
        var succ = function () {
            $Utils.loading.close();
			loadMenus();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取系统管理菜单",errorStatus,msg);
		};
		menus.getItems(1,true,succ,fail);
    }

    function loadMenus(){
        $(".menu-list > ul").html("");
        var str = "";
        var iconClass = "";
        for(var i = 0; i < menus.count; i++){
            if(menus.item(i).menuParentID == -1){
                if(menus.item(i).lastLevel == false){
                    if(menus.item(i).menuCode==11000){
                        iconClass = "bda-biaoshilei_yonghuzu";
                    }
                    if(menus.item(i).menuCode==12000){
                        iconClass = "bda-xitongjiankong";
                    }
                    if(menus.item(i).menuCode==13000){
                        iconClass = "bda-authority";
                    }
                    if(menus.item(i).menuCode==14000){
                        iconClass = "bda-duixiang";
                    }
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont "+iconClass+"'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+">"+menus.item(i).menuName+"</div></li>";
                }
                $(".menu-list > ul").append(str);
            }else{
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-wenjianjia'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+">"+menus.item(i).menuName+"</div></li>";
                }
                $(".menu-list > ul").find("li").each(function(){
                    if($(this).attr("data-menuid") == menus.item(i).menuParentID){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
        $(".menu-list > ul > li:first-child > div").trigger("click");
        $(".menu-list > ul > li:first-child ul li:first-child > div").trigger("click");
        // $(".menu-list > ul > li").each(function(){
        //     if($(this).attr("data-menucode") == 11000){
        //         $(this).children("div").trigger("click");
        //     }
        // });
        // $(".menu-list > ul > li:first-child ul li").each(function(){
        //     if($(this).attr("data-menucode") == 11001){
        //         $(this).children("div").trigger("click");
        //     }
        // });
    }

    function loadMenuList(menuCode,elem){
        switch(Number(menuCode)){
            case 11001:
                // if($AppVars.gLicense.editionID == 3){
                    getListHtml("html/iControl/userAndGroup/user/organizationUsers.html",elem);
                // }else{
                //     getListHtml("html/iControl/userAndGroup/user/users.html",elem);
                // }
                break;
            case 11002:
                getListHtml("html/iControl/userAndGroup/group/groups.html",elem);
                break;
            case 12001:
                getListHtml("html/iControl/systemMonitor/onlineUsers.html",elem);
                break;
            case 12002:
                getListHtml("html/iControl/systemMonitor/reportLog.html",elem);
                break;
            case 12003:
                getListHtml("html/iControl/systemMonitor/upLoadExcelDataLogs.html",elem);
                break;
            case 13101:
                getListHtml("html/iControl/authority/module/groupModules.html",elem);
                break;
            case 13102:
                getListHtml("html/iControl/authority/module/userModules.html",elem);
                break;
            case 13151:
                getListHtml("html/iControl/authority/excelTemplate/groupExcelTemplates.html",elem);
                break;
            case 13152:
                getListHtml("html/iControl/authority/excelTemplate/userExcelTemplates.html",elem);
                break;
            case 13201:
                getListHtml("html/iControl/authority/dataSource/groupDataSources.html",elem);
                break;
            case 13202:
                getListHtml("html/iControl/authority/dataSource/userDataSources.html",elem);
                break;
            case 13301:
                getListHtml("html/iControl/authority/businessModel/groupBusinessModels.html",elem);
                break;
            case 13302:
                getListHtml("html/iControl/authority/businessModel/userBusinessModels.html",elem);
                break;
            case 13401:
                getListHtml("html/iControl/authority/report/groupReports.html",elem);
                break;
            case 13402:
                getListHtml("html/iControl/authority/report/userReports.html",elem);
                break;
            case 13501:
                getListHtml("html/iControl/authority/data/rows.html",elem);
                break;
            case 13502:
                getListHtml("html/iControl/authority/data/columns.html",elem);
                break;
            case 14001:
                getListHtml("html/iControl/objectSupervise/dataSource/dataSources.html",elem);
                break;
            case 14002:
                getListHtml("html/iControl/objectSupervise/businessModel/businessModels.html",elem);
                break;
            case 14003:
                getListHtml("html/iControl/objectSupervise/report/reports.html",elem);
                break;
            case 14004:
                getListHtml("html/iControl/objectSupervise/share/shares.html",elem);
                break;
            case 14005:
                getListHtml("html/iControl/objectSupervise/map/mapMenus.html",elem);
                break;
            case 14006:
                getListHtml("html/iControl/objectSupervise/office/offices.html",elem);
                break;
            case 14007:
                getListHtml("html/iControl/objectSupervise/image/images.html",elem);
                break;
            case 14008:
                getListHtml("html/iControl/objectSupervise/color/colors.html",elem);
                break;
            case 14009:
                getListHtml("html/iControl/objectSupervise/excelTemplate/excelTemplates.html",elem);
                break;
            case 14010:
                getListHtml("html/iControl/objectSupervise/resourceFile/resourceFiles.html",elem);
                break;
        }
    }

    function getListHtml(url,elem){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                $(".business-module-right").children().remove();
                $(".business-module-right").html(data);
                setBread(elem);
            }
        });
    }

    function setBread(elem){
        var folderNameArr = [];
        folderNameArr.push($(elem).text());
        getFolderNameByDomTree($(elem).parent(),folderNameArr);
        var str = "<span>系统管理</span>";
        for(var i = folderNameArr.length-1; i >= 0; i--){
            str += "<span><i class='iconfont bda-bread'></i>"+folderNameArr[i]+"</span>"
        }
        $(".bread").html(str);
    }

    function getFolderNameByDomTree(elem,folderNameArr){
        if(elem.parent()[0].tagName == "UL" && elem.parent().siblings("div").length){
            folderNameArr.push(elem.parent().siblings("div").text());
            getFolderNameByDomTree(elem.parent().parent(),folderNameArr);
        }
    }
    
}();