/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 18:30:47
 * @LastEditTime: 2020-06-12 18:34:43
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var mIncludedGroups = [];
    var mTableBody = [];
    var backupArr = [];
    var lazyArr = [];
    var selectGroups = [];

    window.initGroupList = function(index,includedGroups,groups,addGroupList){
        mIncludedGroups = includedGroups;
        initGroupListHead();
        setTableBody(groups);

        buttonEvent(index,addGroupList);
    };

    function initGroupListHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "groupName", title: "组名"},
                {field: "description", title: "描述"}
            ]
        ];

        table.render({
            elem: '#groupList',
            height: 360,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function setTableBody(groups){
        var includedGroupIDs = setIncludedGroupIDs();
        var tableBody = [];
        for(var i = 0; i < groups.count; i++){
            if(includedGroupIDs.indexOf(groups.item(i).groupID) == -1){
                var obj = {};
                obj.groupID = groups.item(i).groupID;
                obj.groupName = groups.item(i).groupName;
                obj.description = groups.item(i).description;
                tableBody.push(obj);
            }
        }
        $.extend(true,mTableBody,tableBody);
        loadGroupListBody(tableBody);
    }

    function loadGroupListBody(tableBody){
        if(tableBody.length > 100){
            lazyArr = tableBody.splice(100,tableBody.length);
        }
        backupArr = tableBody;
        if(selectGroups.length){
            setSelect(tableBody);
        }
        table.reload("groupList",{data:tableBody,limit:tableBody.length,skin: "nob",done:function(){
            $(".group-list .layui-table-main").scroll(function(){
                var scrollTop = $(this)[0].scrollTop;
                var clientHeight = $(this)[0].clientHeight;
                var scrollHeight = $(this)[0].scrollHeight;
                
                if(lazyArr.length > 0 && scrollHeight > clientHeight && scrollTop + clientHeight === scrollHeight) {
                    loadmore(scrollTop);
                }
            });
        }});
    }

    function setSelect(currentData){
        var selectGroupIDs = [];
        for(var i = 0; i < selectGroups.length; i++){
            selectGroupIDs.push(selectGroups[i].groupID);
        }
        for(var i = 0; i < currentData.length; i++){
            if(selectGroupIDs.indexOf(currentData[i].groupID) != -1){
                currentData[i].LAY_CHECKED = true;
            }else if(currentData[i].LAY_CHECKED){
                currentData[i].LAY_CHECKED = false;
            }
        }
    }

    function setIncludedGroupIDs(){
        var tempArr = [];
        for(var i = 0; i < mIncludedGroups.length; i++){
            tempArr.push(mIncludedGroups[i].groupID);
        }

        return tempArr;
    }

    function buttonEvent(index,addGroupList){
        $(".list-filter-button").click(function(){
            var searchValue = $(".list-filter input").val();
            if(searchValue == ""){
                searchData = mTableBody;
            }else{
                searchData = setSearchData(searchValue);
            }
            loadGroupListBody(searchData);
        });

        $(".list-filter input").keypress(function (e) {
            if (e.which == 13) {
                $(".list-filter-button").click();
            }
        });

        $(".group-list-button .layui-btn-determine").click(function(){
            addGroupList(selectGroups,index);
        });

        table.on('checkbox(groupList)', function(obj){
            if(obj.checked){
                selectGroups.push(obj.data);
            }else{
                for(var i = selectGroups.length - 1; i >= 0 ; i--){
                    if(selectGroups[i].groupID == obj.data.groupID){
                        selectGroups.splice(i,1);
                    }
                }
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });
        
    }

    function setSearchData(searchValue){
        var searchData = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].groupName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            (mTableBody[i].description && (mTableBody[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                searchData.push(mTableBody[i]);
            }
        }
        return searchData;
    }

    function loadmore(scrollTop){
        if(lazyArr.length > 100){
            var tempArr = lazyArr.splice(0,100);
            backupArr = backupArr.concat(tempArr);
        }else{
            backupArr = backupArr.concat(lazyArr);
            lazyArr = [];
        }
        if(selectGroups.length){
            setSelect(backupArr)
        }
        table.reload("groupList",{data:backupArr,limit:backupArr.length,skin: "nob"});
        $(".group-list .layui-table-main").scrollTop(scrollTop);
    }

}();