/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 16:25:20
 * @LastEditTime: 2020-05-14 17:12:29
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, tree = layui.tree, layer = layui.layer;
    var reportFolders = new ReportFolders();
    var reports = new Reports();
    var userReports = new UserReports();
    var backupSelfReportIDsArr = [];
    var backupInheritReportIDsArr = [];

    window.initAuthorityForm = function(index,user){
        getAndLoadAuthorityTree(user);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(user,index);
    };

    function getAndLoadAuthorityTree(user){
        var succ = function(){
            $Utils.loading.close();
			getReportsAndLoadTree(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
		};
		reportFolders.getItems(true,succ,fail);
    }

    function getReportsAndLoadTree(user){
        var succ = function(){
            $Utils.loading.close();
			getSelfAndLoadTree(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
		};
		reports.getItems(1,true,succ,fail);
    }

    function getSelfAndLoadTree(user){
        var succ = function(data){
            $Utils.loading.close();
            getInheritAndLoadTree(data,user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属报表权限",errorStatus,msg);
		};
		userReports.getSelfReports(user.userID,true,succ,fail);
    }

    function getInheritAndLoadTree(selfData,user){
        var succ = function(data){
            $Utils.loading.close();
			loadTree(selfData,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属组报表权限",errorStatus,msg);
		};
		userReports.getInheritReports(user.userID,true,succ,fail);
    }

    function loadTree(selfData,inHeritData){
        backupSelfReportIDsArr = selfData;
        backupInheritReportIDsArr = inHeritData;
        var treeData = transforreportFolders(selfData,inHeritData);
        var reportIDsArr = [];
        for(var i = 0; i < reports.count; i++){
            if(reportIDsArr.indexOf(reports.item(i).reportID) == -1){
                reportIDsArr.push(reports.item(i).reportID);
            }
        }
        tree.render({
            elem: "#treeList",
            data: treeData,
            showCheckbox: true,  //是否显示复选框
            id: "authority",
            isJump: false,
            onlyIconControl: true,
            click: function(obj){
                if(obj.data.reportID && backupInheritReportIDsArr.indexOf(obj.data.reportID) != -1){
                    layer.msg("从组继承的权限不能修改。",{icon:3});
                }
            }
        });

        $("#treeList").find(".layui-tree-iconClick").each(function(){
            if(reportIDsArr.indexOf($(this).siblings("input").attr("value")) == -1){
                $(this).children(".layui-icon-file").hide();
                if($(this).children(".layui-icon-subtraction").length == 0){
                    $(this).css("margin","0 5px");
                }
            }
            if(backupInheritReportIDsArr.indexOf($(this).siblings("input").attr("value")) != -1){
                $(this).siblings("input").attr("disabled",true);
                $(this).siblings(".layui-form-checkbox").addClass("layui-checkbox-disbaled");
            }
            if(!$(this).hasClass("layui-tree-icon")){
                $(this).find(".layui-icon").removeClass().addClass("iconfont bda-shilitubiao");
            }
        });
    }

    function transforreportFolders(selfData,inHeritData){
        var haveReportFolders = [];
        for(var i = 0; i < reports.count; i++){
            var folderID = reports.item(i).folderID;
            while(folderID != -1 && haveReportFolders.indexOf(folderID) == -1){
                haveReportFolders.push(folderID);
                folderID = reportFolders.item(folderID).folderParentID;
            }
        }

		for(var i = reportFolders.count-1;i>=0;i--){
			if(haveReportFolders.indexOf(reportFolders.item(i).folderID) == -1){
				reportFolders.remove(reportFolders.item(i));
			}
        }
        
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "组织分析",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < reportFolders.count; i++){
            hashTable.add(reportFolders.item(i).folderID,{title:reportFolders.item(i).folderName,id:reportFolders.item(i).folderID,folderID:reportFolders.item(i).folderID,folderParentID:reportFolders.item(i).folderParentID});
        }
        for(var i = 0; i < reportFolders.count; i++){
            var parentFolder = hashTable.getValue(reportFolders.item(i).folderParentID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(reportFolders.item(i).folderID));
        }
        for(var i = 0; i < reports.count; i++){
            var parentFolder = hashTable.getValue(reports.item(i).folderID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            if(selfData.indexOf(reports.item(i).reportID) != -1 || inHeritData.indexOf(reports.item(i).reportID) != -1){
                parentFolder.children.push({title:reports.item(i).reportName,id:reports.item(i).reportID,folderParentID:reports.item(i).folderID,reportID:reports.item(i).reportID,checked:true});
            }else{
                parentFolder.children.push({title:reports.item(i).reportName,id:reports.item(i).reportID,folderParentID:reports.item(i).folderID,reportID:reports.item(i).reportID});
            }
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }

        return tempArr;
    }

    function bindEvent(user,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.userID = user.userID;
                tempObj.reportIDs = [];
                var selectData = getCheckReportID();
                for(var i = selectData.length-1; i >= 0; i--){
                    if(backupInheritReportIDsArr.indexOf(selectData[i].moduleID) != -1){
                        selectData.splice(i,1);
                    }
                }
                tempObj.reportIDs = selectData;
                submitAuthority(user,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        var checkedData = getCheckReportID();
        for(var i = checkedData.length-1; i >= 0; i--){
            if(backupInheritReportIDsArr.indexOf(checkedData[i]) != -1){
                checkedData.splice(i,1);
            }
        }
        if(backupSelfReportIDsArr.length == 0 && checkedData.length == 0){
            return false;
        }
        if(backupSelfReportIDsArr.length != checkedData.length){
            return true;
        }
        for(var i = 0; i < checkedData.length; i++){
            if(backupSelfReportIDsArr.indexOf(checkedData[i]) == -1){
                return true;
            }
        }
        return false;
    }

    function getCheckReportID(){
        var reportIDs = [];
        var selectData = tree.getChecked('authority');
        for(var i = 0; i < selectData.length; i++){
            if(selectData[i].children && selectData[i].children.length){
                getChildrenReportID(selectData[i].children,reportIDs);
            }else{
                if(selectData[i].reportID){
                    reportIDs.push(selectData[i].reportID);
                }
            }
        }
        return reportIDs;
    }

    function getChildrenReportID(dataArr,reportIDs){
        for(var i = 0; i < dataArr.length; i++){
            if(dataArr[i].children && dataArr[i].children.length){
                getChildrenReportID(dataArr[i].children,reportIDs);
            }else{
                if(dataArr[i].reportID){
                    reportIDs.push(dataArr[i].reportID);
                }
            }
        }
    }

    function submitAuthority(user,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属报表权限",errorStatus,msg);
		};
		userReports.updateByUserID(authorities,true,succ,fail);
    }
    
    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

}();