/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 14:11:55
 * @LastEditTime: 2020-05-07 16:33:21
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, tree = layui.tree, layer = layui.layer;
    var reportFolders = new ReportFolders();
    var reports = new Reports();
    var groupReports = new GroupReports();
    var backupReportIDsArr = [];

    window.initAuthorityForm = function(index,group){
        getAndLoadAuthorityTree(group);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(group,index);
    };

    function getAndLoadAuthorityTree(group){
        var succ = function(){
            $Utils.loading.close();
			getReportsAndLoadTree(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
		};
		reportFolders.getItems(true,succ,fail);
    }

    function getReportsAndLoadTree(group){
        var succ = function(){
            $Utils.loading.close();
			getGroupReportsAndloadTree(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
		};
		reports.getItems(1,true,succ,fail);
    }

    function getGroupReportsAndloadTree(group){
        var succ = function(data){
            $Utils.loading.close();
			loadTree(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+group.groupName+" 所属报表权限",errorStatus,msg);
		};
		groupReports.getItems(group.groupID,true,succ,fail);
    }


    function loadTree(data){
        backupReportIDsArr = data;
        var treeData = transforreportFolders(data);
        var reportIDsArr = [];
        for(var i = 0; i < reports.count; i++){
            if(reportIDsArr.indexOf(reports.item(i).reportID) == -1){
                reportIDsArr.push(reports.item(i).reportID);
            }
        }
        tree.render({
            elem: "#treeList",
            data: treeData,
            showCheckbox: true,  //是否显示复选框
            id: "authority",
            isJump: false, //是否允许点击节点时弹出新窗口跳转
        });

        $("#treeList").find(".layui-tree-iconClick").each(function(){
            if(reportIDsArr.indexOf($(this).siblings("input").attr("value")) == -1){
                $(this).children(".layui-icon-file").hide();
                if($(this).children(".layui-icon-subtraction").length == 0){
                    $(this).css("margin","0 5px");
                }
            }
            if(!$(this).hasClass("layui-tree-icon")){
                $(this).find(".layui-icon").removeClass().addClass("iconfont bda-shilitubiao");
            }
        });
    }

    function transforreportFolders(data){
        var haveReportFolders = [];
        for(var i = 0; i < reports.count; i++){
            var folderID = reports.item(i).folderID;
            while(folderID != -1 && haveReportFolders.indexOf(folderID) == -1){
                haveReportFolders.push(folderID);
                folderID = reportFolders.item(folderID).folderParentID;
            }
        }

		for(var i = reportFolders.count-1;i>=0;i--){
			if(haveReportFolders.indexOf(reportFolders.item(i).folderID) == -1){
				reportFolders.remove(reportFolders.item(i));
			}
        }
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "组织分析",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < reportFolders.count; i++){
            hashTable.add(reportFolders.item(i).folderID,{title:reportFolders.item(i).folderName,id:reportFolders.item(i).folderID,folderID:reportFolders.item(i).folderID,folderParentID:reportFolders.item(i).folderParentID});
        }
        for(var i = 0; i < reportFolders.count; i++){
            var parentFolder = hashTable.getValue(reportFolders.item(i).folderParentID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(reportFolders.item(i).folderID));
        }
        for(var i = 0; i < reports.count; i++){
            var parentFolder = hashTable.getValue(reports.item(i).folderID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            if(data.indexOf(reports.item(i).reportID) != -1){
                parentFolder.children.push({title:reports.item(i).reportName,id:reports.item(i).reportID,folderParentID:reports.item(i).folderID,reportID:reports.item(i).reportID,checked:true});
            }else{
                parentFolder.children.push({title:reports.item(i).reportName,id:reports.item(i).reportID,folderParentID:reports.item(i).folderID,reportID:reports.item(i).reportID});
            }
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }

        return tempArr;
    }

    function bindEvent(group,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.groupID = group.groupID;
                tempObj.reportIDs = getCheckReportID();
                submitAuthority(group,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        var checkedData = getCheckReportID();
        if(backupReportIDsArr.length == 0 && checkedData.length == 0){
            return false;
        }
        if(backupReportIDsArr.length != checkedData.length){
            return true;
        }
        for(var i = 0; i < checkedData.length; i++){
            if(backupReportIDsArr.indexOf(checkedData[i]) == -1){
                return true;
            }
        }
        return false;
    }

    function getCheckReportID(){
        var reportIDs = [];
        var selectData = tree.getChecked('authority');
        for(var i = 0; i < selectData.length; i++){
            if(selectData[i].children && selectData[i].children.length){
                getChildrenReportID(selectData[i].children,reportIDs);
            }else{
                if(selectData[i].reportID){
                    reportIDs.push(selectData[i].reportID);
                }
            }
        }
        return reportIDs;
    }

    function getChildrenReportID(dataArr,reportIDs){
        for(var i = 0; i < dataArr.length; i++){
            if(dataArr[i].children && dataArr[i].children.length){
                getChildrenReportID(dataArr[i].children,reportIDs);
            }else{
                if(dataArr[i].reportID){
                    reportIDs.push(dataArr[i].reportID);
                }
            }
        }
    }

    function submitAuthority(group,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属报表权限",errorStatus,msg);
		};
		groupReports.updateByGroupID(authorities,true,succ,fail);
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();