/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-13 20:42:49
 * @LastEditTime: 2020-09-10 17:14:10
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var modules = new Modules();
    var userModules = new UserModules();
    var backupSelfModuleIDsArr = [];
    var backupInheritModuleIDsArr = [];

    window.initAuthorityForm = function(index,user){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(user);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(user,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "moduleName",title: "模块名称"},
                {field: "description",title: "描述"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(user){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取模块列表",errorStatus,msg);
		};
		modules.getItems(true,succ,fail);
    }

    function getAndLoadTableBody(user){
        var succ = function(data){
            $Utils.loading.close();
            getInheritAndLoadTableBody(data,user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属模块权限",errorStatus,msg);
		};
		userModules.getSelfModules(user.userID,true,succ,fail);
    }

    function getInheritAndLoadTableBody(selfModulesData,user){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(selfModulesData,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属组模块权限",errorStatus,msg);
		};
		userModules.getInheritModules(user.userID,true,succ,fail);
    }

    function loadTableBody(selfModulesData,inHeritModulesData){
        var tableBody = [];
        for(var i = 0; i < modules.count; i++){
            var obj = {};
            for(var key in modules.item(i)){
                if(typeof modules.item(i)[key] === "function"){ continue;}
                obj[key] = modules.item(i)[key];
            }
            if(selfModulesData.indexOf(modules.item(i).moduleID) != -1 || inHeritModulesData.indexOf(modules.item(i).moduleID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = true;
            tableBody.push(obj);
        }
        backupSelfModuleIDsArr = selfModulesData;
        backupInheritModuleIDsArr = inHeritModulesData;
        table.reload("authority",{data:tableBody,limit:tableBody.length,done:function(res, curr, count){
            for (var i in res.data) {
                var item = res.data[i];
                if(backupInheritModuleIDsArr.indexOf(item.moduleID) != -1) {
                    $('tr[data-index=' + i + '] input[type="checkbox"]').prop('disabled', true);
                }
            }
        }});
    }

    function bindEvent(user,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.userID = user.userID;
                tempObj.moduleIDs = [];
                var selectData = table.checkStatus("authority").data;
                for(var i = selectData.length-1; i >= 0; i--){
                    if(backupInheritModuleIDsArr.indexOf(selectData[i].moduleID) != -1){
                        selectData.splice(i,1);
                    }
                }
                for(var i = 0; i < selectData.length; i++){
                    tempObj.moduleIDs.push(selectData[i].moduleID);
                }
                submitAuthority(user,tempObj,index);
            }else{
                layer.close(index);
            }
        });

        table.on("checkbox(authority)",function(obj){
            if(backupInheritModuleIDsArr.indexOf(obj.data.moduleID) != -1 && obj.data.userOrGroup){
                layer.msg("从组继承的权限不能修改。",{icon:3});
            }
        });
    }

    function change(){
        var selectData = table.checkStatus("authority").data;
        for(var i = selectData.length-1; i >= 0; i--){
            if(backupInheritModuleIDsArr.indexOf(selectData[i].moduleID) != -1){
                selectData.splice(i,1);
            }
        }
        if(selectData.length != backupSelfModuleIDsArr.length){
            return true;
        }
        for(var i = 0; i < selectData.length; i++){
            if(backupSelfModuleIDsArr.indexOf(selectData[i].moduleID) == -1){
                return true;
            }
        }
        return false;
    }

    function submitAuthority(user,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属模块权限",errorStatus,msg);
		};
		userModules.update(authorities,true,succ,fail);
    }
    
}();