/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-13 20:42:49
 * @LastEditTime: 2020-09-10 17:11:36
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var modules = new Modules();
    var groupModules = new GroupModules();
    var backupModuleIDsArr = [];

    window.initAuthorityForm = function(index,group){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(group);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(group,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "moduleName",title: "模块名称"},
                {field: "description",title: "描述"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(group){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取模块列表",errorStatus,msg);
		};
		modules.getItems(true,succ,fail);
    }

    function getAndLoadTableBody(group){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+group.groupName+" 所属模块权限",errorStatus,msg);
		};
		groupModules.getItems(group.groupID,true,succ,fail);
    }

    function loadTableBody(data){
        var tableBody = [];
        for(var i = 0; i < modules.count; i++){
            var obj = {};
            for(var key in modules.item(i)){
                if(typeof modules.item(i)[key] === "function"){ continue;}
                obj[key] = modules.item(i)[key];
            }
            if(data.indexOf(modules.item(i).moduleID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = false;
            tableBody.push(obj);
        }
        backupModuleIDsArr = data;
        table.reload("authority",{data:tableBody,limit:tableBody.length});
    }

    function bindEvent(group,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.groupID = group.groupID;
                tempObj.moduleIDs = [];
                for(var i = 0; i < table.checkStatus('authority').data.length; i++){
                    tempObj.moduleIDs.push(table.checkStatus('authority').data[i].moduleID);
                }
                submitAuthority(group,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        if(backupModuleIDsArr.length == 0 && table.checkStatus('authority').data.length == 0){
            return false;
        }

        for(var i = 0; i < table.checkStatus('authority').data.length; i++){
            if(backupModuleIDsArr.indexOf(table.checkStatus('authority').data[i].moduleID) == -1){
                return true;
            }
        }

        if(backupModuleIDsArr.length > table.checkStatus('authority').data.length){
            return true;
        }
        return false;
    }

    function submitAuthority(group,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属模块权限",errorStatus,msg);
		};
		groupModules.update(authorities,true,succ,fail);
    }
    
}();