!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var uploadExcelTemplates = new UploadExcelTemplates();
    var userUploadExcelTemplates = new UserUploadExcelTemplates();
    var backupSelfTemplateIDsArr = [];
    var backupInheritTemplateIDsArr = [];

    window.initAuthorityForm = function(index,user){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(user);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(user,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "templateName",title: "Excel模版名称"},
                {field: "createUserName",title: "上传者"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(user){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Excel模版列表",errorStatus,msg);
		};
		uploadExcelTemplates.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(user){
        var succ = function(data){
            $Utils.loading.close();
            getInheritAndLoadTableBody(data,user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属Excel模版权限",errorStatus,msg);
		};
		userUploadExcelTemplates.getSelfUploadExcelTemplates(user.userID,true,succ,fail);
    }

    function getInheritAndLoadTableBody(selfUploadExcelTemplatesData,user){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(selfUploadExcelTemplatesData,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属Excel模版权限",errorStatus,msg);
		};
		userUploadExcelTemplates.getInheritUploadExcelTemplates(user.userID,true,succ,fail);
    }

    function loadTableBody(selfUploadExcelTemplatesData,inHeritUploadExcelTemplatesData){
        var tableBody = [];
        for(var i = 0; i < uploadExcelTemplates.count; i++){
            var obj = {};
            for(var key in uploadExcelTemplates.item(i)){
                if(typeof uploadExcelTemplates.item(i)[key] === "function"){ continue;}
                obj[key] = uploadExcelTemplates.item(i)[key];
            }
            if(selfUploadExcelTemplatesData.indexOf(uploadExcelTemplates.item(i).templateID) != -1 || inHeritUploadExcelTemplatesData.indexOf(uploadExcelTemplates.item(i).templateID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = true;
            tableBody.push(obj);
        }
        backupSelfTemplateIDsArr = selfUploadExcelTemplatesData;
        backupInheritTemplateIDsArr = inHeritUploadExcelTemplatesData;
        table.reload("authority",{data:tableBody,limit:tableBody.length,done:function(res, curr, count){
            for (var i in res.data) {
                var item = res.data[i];
                if(backupInheritTemplateIDsArr.indexOf(item.templateID) != -1) {
                    $('tr[data-index=' + i + '] input[type="checkbox"]').prop('disabled', true);
                }
            }
        }});
    }

    function bindEvent(user,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.userID = user.userID;
                tempObj.templateIDs = [];
                var selectData = table.checkStatus("authority").data;
                for(var i = selectData.length-1; i >= 0; i--){
                    if(backupInheritTemplateIDsArr.indexOf(selectData[i].templateID) != -1){
                        selectData.splice(i,1);
                    }
                }
                for(var i = 0; i < selectData.length; i++){
                    tempObj.templateIDs.push(selectData[i].templateID);
                }
                submitAuthority(user,tempObj,index);
            }else{
                layer.close(index);
            }
        });

        table.on("checkbox(authority)",function(obj){
            if(backupInheritTemplateIDsArr.indexOf(obj.data.templateID) != -1 && obj.data.userOrGroup){
                layer.msg("从组继承的权限不能修改。",{icon:3});
            }
        });
    }

    function change(){
        var selectData = table.checkStatus("authority").data;
        for(var i = selectData.length-1; i >= 0; i--){
            if(backupInheritTemplateIDsArr.indexOf(selectData[i].templateID) != -1){
                selectData.splice(i,1);
            }
        }
        if(selectData.length != backupSelfTemplateIDsArr.length){
            return true;
        }
        for(var i = 0; i < selectData.length; i++){
            if(backupSelfTemplateIDsArr.indexOf(selectData[i].templateID) == -1){
                return true;
            }
        }
        return false;
    }

    function submitAuthority(user,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属Excel模版权限",errorStatus,msg);
		};
		userUploadExcelTemplates.updateByUserID(authorities,true,succ,fail);
    }
    
}();