!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var uploadExcelTemplates = new UploadExcelTemplates();
    var groupUploadExcelTemplates = new GroupUploadExcelTemplates();
    var backupTemplateIDsArr = [];

    window.initAuthorityForm = function(index,group){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(group);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(group,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "templateName",title: "Excel模版名称"},
                {field: "createUserName",title: "上传者"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(group){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Excel模版列表",errorStatus,msg);
		};
		uploadExcelTemplates.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(group){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+group.groupName+" 所属Excel模版权限",errorStatus,msg);
		};
		groupUploadExcelTemplates.getItems(group.groupID,true,succ,fail);
    }

    function loadTableBody(data){
        var tableBody = [];
        for(var i = 0; i < uploadExcelTemplates.count; i++){
            var obj = {};
            for(var key in uploadExcelTemplates.item(i)){
                if(typeof uploadExcelTemplates.item(i)[key] === "function"){ continue;}
                obj[key] = uploadExcelTemplates.item(i)[key];
            }
            if(data.indexOf(uploadExcelTemplates.item(i).templateID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = true;
            tableBody.push(obj);
        }
        backupTemplateIDsArr = data;
        table.reload("authority",{data:tableBody,limit:tableBody.length});
    }

    function bindEvent(group,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.groupID = group.groupID;
                tempObj.templateIDs = [];
                for(var i = 0; i < table.checkStatus('authority').data.length; i++){
                    tempObj.templateIDs.push(table.checkStatus('authority').data[i].templateID);
                }
                submitAuthority(group,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        if(backupTemplateIDsArr.length == 0 && table.checkStatus('authority').data.length == 0){
            return false;
        }

        for(var i = 0; i < table.checkStatus('authority').data.length; i++){
            if(backupTemplateIDsArr.indexOf(table.checkStatus('authority').data[i].templateID) == -1){
                return true;
            }
        }

        if(backupTemplateIDsArr.length > table.checkStatus('authority').data.length){
            return true;
        }
        return false;
    }

    function submitAuthority(group,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属Excel模版权限",errorStatus,msg);
		};
		groupUploadExcelTemplates.updateByGroupID(authorities,true,succ,fail);
    }
    
}();