/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 11:05:36
 * @LastEditTime: 2020-09-10 17:18:41
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var dataSources = new DataSources();
    var userDataSources = new UserDataSources();
    var backupSelfDataSourceIDsArr = [];
    var backupInheritDataSourceIDsArr = [];

    window.initAuthorityForm = function(index,user){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(user);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(user,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "dataSourceName",title: "数据源名称"},
                {field: "dataSourceType",title: "类型",templet: "#type"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(user){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据源列表",errorStatus,msg);
		};
		dataSources.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(user){
        var succ = function(data){
            $Utils.loading.close();
            getInheritAndLoadTableBody(data,user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属数据源权限",errorStatus,msg);
		};
		userDataSources.getSelfDataSources(user.userID,true,succ,fail);
    }

    function getInheritAndLoadTableBody(selfDataSourcesData,user){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(selfDataSourcesData,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属组数据源权限",errorStatus,msg);
		};
		userDataSources.getInheritDataSources(user.userID,true,succ,fail);
    }

    function loadTableBody(selfDataSourcesData,inHeritDataSourcesData){
        var tableBody = [];
        for(var i = 0; i < dataSources.count; i++){
            var obj = {};
            for(var key in dataSources.item(i)){
                if(typeof dataSources.item(i)[key] === "function"){ continue;}
                obj[key] = dataSources.item(i)[key];
            }
            if(selfDataSourcesData.indexOf(dataSources.item(i).dataSourceID) != -1 || inHeritDataSourcesData.indexOf(dataSources.item(i).dataSourceID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = true;
            tableBody.push(obj);
        }
        backupSelfDataSourceIDsArr = selfDataSourcesData;
        backupInheritDataSourceIDsArr = inHeritDataSourcesData;
        table.reload("authority",{data:tableBody,limit:tableBody.length,done:function(res, curr, count){
            for (var i in res.data) {
                var item = res.data[i];
                if(backupInheritDataSourceIDsArr.indexOf(item.dataSourceID) != -1) {
                    $('tr[data-index=' + i + '] input[type="checkbox"]').prop('disabled', true);
                }
            }
        }});
    }

    function bindEvent(user,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.userID = user.userID;
                tempObj.dataSourceIDs = [];
                var selectData = table.checkStatus("authority").data;
                for(var i = selectData.length-1; i >= 0; i--){
                    if(backupInheritDataSourceIDsArr.indexOf(selectData[i].dataSourceID) != -1){
                        selectData.splice(i,1);
                    }
                }
                for(var i = 0; i < selectData.length; i++){
                    tempObj.dataSourceIDs.push(selectData[i].dataSourceID);
                }
                submitAuthority(user,tempObj,index);
            }else{
                layer.close(index);
            }
        });

        table.on("checkbox(authority)",function(obj){
            if(backupInheritDataSourceIDsArr.indexOf(obj.data.dataSourceID) != -1 && obj.data.userOrGroup){
                layer.msg("从组继承的权限不能修改。",{icon:3});
            }
        });
    }

    function change(){
        var selectData = table.checkStatus("authority").data;
        for(var i = selectData.length-1; i >= 0; i--){
            if(backupInheritDataSourceIDsArr.indexOf(selectData[i].dataSourceID) != -1){
                selectData.splice(i,1);
            }
        }
        if(selectData.length != backupSelfDataSourceIDsArr.length){
            return true;
        }
        for(var i = 0; i < selectData.length; i++){
            if(backupSelfDataSourceIDsArr.indexOf(selectData[i].dataSourceID) == -1){
                return true;
            }
        }
        return false;
    }

    function submitAuthority(user,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属数据源权限",errorStatus,msg);
		};
		userDataSources.updateByUserID(authorities,true,succ,fail);
    }
    
}();