!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var dataSources = new DataSources();
    var groupDataSources = new GroupDataSources();
    var backupDataSourceIDsArr = [];

    window.initAuthorityForm = function(index,group){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(group);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(group,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "dataSourceName",title: "数据源名称"},
                {field: "dataSourceType",title: "类型",templet: "#type"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(group){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据源列表",errorStatus,msg);
		};
		dataSources.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(group){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+group.groupName+" 所属数据源权限",errorStatus,msg);
		};
		groupDataSources.getItems(group.groupID,true,succ,fail);
    }

    function loadTableBody(data){
        var tableBody = [];
        for(var i = 0; i < dataSources.count; i++){
            var obj = {};
            for(var key in dataSources.item(i)){
                if(typeof dataSources.item(i)[key] === "function"){ continue;}
                obj[key] = dataSources.item(i)[key];
            }
            if(data.indexOf(dataSources.item(i).dataSourceID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = false;
            tableBody.push(obj);
        }
        backupDataSourceIDsArr = data;
        table.reload("authority",{data:tableBody,limit:tableBody.length});
    }

    function bindEvent(group,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.groupID = group.groupID;
                tempObj.dataSourceIDs = [];
                for(var i = 0; i < table.checkStatus('authority').data.length; i++){
                    tempObj.dataSourceIDs.push(table.checkStatus('authority').data[i].dataSourceID);
                }
                submitAuthority(group,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        if(backupDataSourceIDsArr.length == 0 && table.checkStatus('authority').data.length == 0){
            return false;
        }

        for(var i = 0; i < table.checkStatus('authority').data.length; i++){
            if(backupDataSourceIDsArr.indexOf(table.checkStatus('authority').data[i].dataSourceID) == -1){
                return true;
            }
        }

        if(backupDataSourceIDsArr.length > table.checkStatus('authority').data.length){
            return true;
        }
        return false;
    }

    function submitAuthority(group,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属数据源权限",errorStatus,msg);
		};
		groupDataSources.updateByGroupID(authorities,true,succ,fail);
    }
    
}();