/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-16 19:06:26
 * @LastEditTime: 2021-02-21 18:28:12
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var queryObjectRestrictions = new QueryObjectRestrictions();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "businessModelName",title: "业务模型", sort: true},
                {field: "businessModelType",title: "模型类型",templet:"#type", sort: true},
                {field: "businessObjectName",title: "业务对象", sort: true},
                {field: "operation",title: "逻辑判断",templet:"#operation", sort: true},
                {field: "queryObjectRestrictionValues",title: "值"},
                {field: "qorApplyUsers",title: "应用用户"},
                {field: "qorApplyGroups",title: "应用组"},
                {title: "操作",templet: "#setAuthority",width: 100, align:"center"} 
            ]
        ];
        table.render({
            elem: '#authorityList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取行权限列表",errorStatus,msg);
		};
		queryObjectRestrictions.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < queryObjectRestrictions.count; i++){
            var tempObj = {};
            for(var key in queryObjectRestrictions.item(i)){
                if(key === "queryObjectRestrictionValues"){
                    tempObj[key] = queryObjectRestrictions.item(i)[key].join(",");
                }else if(key === "qorApplyGroups"){
                    var tempArr = [];
                    for(var j = 0; j < queryObjectRestrictions.item(i)[key].count; j++){
                        tempArr.push(queryObjectRestrictions.item(i)[key].item(j).applyGroupName);
                    }
                    tempObj["qorApplyGroups"] = tempArr.join(",");
                }else if(key === "qorApplyUsers"){
                    var tempArr = [];
                    for(var j = 0; j < queryObjectRestrictions.item(i)[key].count; j++){
                        tempArr.push(queryObjectRestrictions.item(i)[key].item(j).applyUserName);
                    }
                    tempObj["qorApplyUsers"] = tempArr.join(",");
                }else{
                    tempObj[key] = queryObjectRestrictions.item(i)[key];
                }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("authorityList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("authorityList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("authorityList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(authorityList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });
        
        $(".add-column").click(function(){
            var queryObjectRestriction = new QueryObjectRestriction();
            getAndLoadRowForm(0,queryObjectRestriction);
        });

        $(".edit-column").click(function(){
            if(table.checkStatus('authorityList').data.length){
                var queryObjectRestriction = queryObjectRestrictions.item(table.checkStatus('authorityList').data[0].queryObjectRestrictionID);
                getAndLoadRowForm(1,queryObjectRestriction);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".delete-column").click(function(){
            if(table.checkStatus('authorityList').data.length){
                layer.open({
                    type: 0,
                    title: "删除行权限",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteColumn(table.checkStatus('authorityList').data[0].queryObjectRestrictionID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        
        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        table.on("tool(authorityList)", function(obj){
            var queryObjectRestriction = queryObjectRestrictions.item(obj.data.queryObjectRestrictionID);
            if(obj.event == "empower"){
                getAndLoadAuthorityListForm(queryObjectRestriction);
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].businessObjectName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].queryObjectRestrictionValues.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].qorApplyUsers.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }
    
    function getAndLoadRowForm(operationType, queryObjectRestriction) {
        $Utils.loading.open();
        $.ajax({
            url: "html/iControl/authority/data/row.html",
            type: 'GET',
            success: function(data){
                loadRowForm(data,operationType,queryObjectRestriction);
            }
        });
    }

    function loadRowForm(strHtml,operationType,queryObjectRestriction){
        layer.open({
            type: 1,
            title: ["行权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["868px","651px"],
            content: strHtml,
            success: function(layero,index){
                initRowForm(operationType,queryObjectRestriction,index,addSubmit,editSubmit);
            }
        });
    }

    function getAndLoadAuthorityListForm(queryObjectRestriction){
        $.ajax({
            url: "html/iControl/authority/data/rowAuthorityList.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,queryObjectRestriction)
            }
        });
    }

    function loadAuthorityListForm(strHtml,queryObjectRestriction){
        layer.open({
            type: 1,
            title: ["应用范围","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,queryObjectRestriction,editSubmit);
            }
        });
    }

    function deleteColumn(queryObjectRestrictionID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除行权限",errorStatus,msg);
        };
        queryObjectRestrictions.deleteItem(queryObjectRestrictionID,true,succ,fail);
    }

    var addSubmit = function(queryObjectRestriction,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增行权限",errorStatus,msg);
        };
        
		queryObjectRestrictions.addItem(queryObjectRestriction,true,succ,fail);
    };

    var editSubmit = function(queryObjectRestriction,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改行权限",errorStatus,msg);
        };

		queryObjectRestrictions.editItem(queryObjectRestriction,true,succ,fail);
    };

}();