/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-17 09:15:35
 * @LastEditTime: 2021-01-22 16:33:20
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form,tree = layui.tree, transfer = layui.transfer;
    var businessModels = new BusinessModels();
    var relationModel = new RelationModel();
    var tableModel = new TableModel();
    var sqlModel = new SqlModel();
    var excelModel = new ExcelModel();
    var selectBusinessObject = {
        businessObjectID: "",
        businessObjectName: ""
    };
    var mQueryObjectRestriction = null, layerIndex = null,mOperationType = null,formAddSubmit = null,formEditSubmit = null, mAllData = null, mBusinessObjects = null,mSelectBusinessModelID = null, mSelectBusinessModelType = null;
    var operationObj = [
        {key: "等于", value: 0},
        {key: "不等于", value: 1},
        {key: "大于", value: 2},
        {key: "大于等于", value: 3},
        {key: "小于", value: 4},
        {key: "小于等于", value: 5},
        {key: "属于列表", value: 6},
        {key: "不属于列表", value: 7},
        {key: "匹配模式", value: 8},
        {key: "不同于模式", value: 9}
    ];

    window.initRowForm = function(operationType,queryObjectRestriction,index,addSubmit,editSubmit){
        mQueryObjectRestriction = queryObjectRestriction;
        layerIndex = index;
        formAddSubmit = addSubmit
        formEditSubmit = editSubmit
        mOperationType = operationType;
        getAndLoadBusinessModels();
        loadOperation();
        getAndLoadBusinessObjects(mQueryObjectRestriction);
        loadTransfer();
        
        if(mOperationType == 1){
            if(mQueryObjectRestriction.operation != 8 && mQueryObjectRestriction.operation != 9){
                $(".special-item").hide();
            }else{
                $(".special-item").show();
                setSelectValue(mQueryObjectRestriction.queryObjectRestrictionValues[0]);
            }
        }

        bindElementEvent();
    }

    function getAndLoadBusinessModels(){
        var succ = function(){
            loadBusinessModelsSelectForm();
        };
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function loadBusinessModelsSelectForm(){
        var selectModelID = "";
        var businessModelsDom = document.getElementById("businessModelID");
        for(var i = 0; i < businessModels.count; i++){
            var option = document.createElement("option");
            option.setAttribute("value",businessModels.item(i).businessModelID);
            if(mOperationType == 0){
                if(i == 0){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }else if(mOperationType == 1){
                if(businessModels.item(i).businessModelID == mQueryObjectRestriction.businessModelID){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }
            option.innerText = businessModels.item(i).businessModelName;
            businessModelsDom.appendChild(option);
        }
        form.render();
        getAndLoadBusinessObjects(businessModels.item(selectModelID));
    }

    function loadOperation(){
        var operations = document.getElementById("operator");
        for(var i = 0; i < operationObj.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",operationObj[i].value);
            if(mQueryObjectRestriction.operation != null){
                if(operationObj[i].value == mQueryObjectRestriction.operation){
                    option.setAttribute("selected",true);
                }
            }else{
                if(i == 0){
                    option.setAttribute("selected",true);
                }
            }
            option.innerText = operationObj[i].key;
            operations.appendChild(option);
        }
        form.render();
    }

    function getAndLoadBusinessObjects(selectedBusinessModel){
        var succ = function () {
            $Utils.loading.close();

            loadBusinessObjectTreeList(selectedBusinessModel.businessModelType);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+selectedBusinessModel.businessModelName+" 业务对象",errorStatus,msg);
        };
        if(selectedBusinessModel.businessModelType == 0){
            relationModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 1){
            tableModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 2){
            sqlModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 3){
            excelModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
    }

    function loadTree(){
        
        

        // $(".data-row .data-row-bussiness-object").off("click").on("click", function (e) {
        //     $(this).parents(".select-bussiness-object").toggleClass("selected-dataRow-businessObject");

        //     layui.stope(e);
        // }).on("click", "dl i", function (e) {
        //     layui.stope(e);
        // });
        // $(document).on("click", function (e) {
        //     if (!$(e.target).hasClass("data-row-tree") && $(e.target).parents(".data-row-tree").length == 0){
        //         $(".data-row .select-bussiness-object").removeClass("selected-dataRow-businessObject");
        //     }
        // });
    }

    function loadBusinessObjectTreeList(businessModelType){
        var allBusinessObjects = null;
        var businessModelID = null;
        if(businessModelType == 0){
            allBusinessObjects = relationModel.businessObjects;
            businessModelID = relationModel.businessModelID;
        }
        if(businessModelType == 1){
            allBusinessObjects = tableModel.businessObjects;
            businessModelID = tableModel.businessModelID;
        }
        if(businessModelType == 2){
            allBusinessObjects = sqlModel.businessObjects;
            businessModelID = sqlModel.businessModelID;
        }
        if(businessModelType == 3){
            allBusinessObjects = excelModel.businessObjects;
            businessModelID = excelModel.businessModelID;
        }
        mBusinessObjects = allBusinessObjects;
        mSelectBusinessModelID = businessModelID;
        mSelectBusinessModelType = businessModelType;

        if (mBusinessObjects.item(mQueryObjectRestriction.businessObjectID)) {
            selectBusinessObject.businessObjectID = mQueryObjectRestriction.businessObjectID;
            selectBusinessObject.businessObjectName = mQueryObjectRestriction.businessObjectName;
            $(".data-row .data-row-bussiness-object").find(".layui-tree-text").html(mQueryObjectRestriction.businessObjectName).end().find("input:hidden[name='businessObjectID']").val(mQueryObjectRestriction.businessObjectID);
            getAndLoadTransferData(mBusinessObjects.item(mQueryObjectRestriction.businessObjectID), businessModelType, businessModelID);
        } else {
            $(".data-row .data-row-bussiness-object").find(".layui-tree-text").html("无数据").end().find("input:hidden[name='businessObjectID']").val("");
            setSelectValue("");
            transfer.reload("valueList", { data: [], value: [] });
        }
    }

    function loadTransfer(){
        transfer.render({
            elem: '#businessObjectValues',
            title: ["值列表","选定值"],
            showSearch: true,
            data: [],
            height: 500,
            id: "valueList",
            onchange: function(data, index){
                var operator = form.val("formWindow").operator;
                if((Number(operator) != 6 && Number(operator) != 7) && index == 0){
                    transfer.reload("valueList",{data:mAllData,value:[data[0].value]});
                }
                if(operator == 8 || operator == 9){
                    setSelectValue(data[0].value);
                }
            }
        })
    }

    function getAndLoadTransferData(businessObject, businessModelType, businessModelID) {
        $Utils.loading.open();
        var succ = function(data){
            $Utils.loading.close();
            loadTransferData(data,businessObject.businessObjectName);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+businessObject.businessObjectName+" 值",errorStatus,msg);
        };
        var basePath = "";
        if(businessModelType == 0){
            basePath = $AppURLs.relationModelPath;
        }
        if(businessModelType == 1){
            basePath = $AppURLs.tableModelPath;
        }
        if(businessModelType == 2){
            basePath = $AppURLs.sqlModelPath;
        }
        if(businessModelType == 3){
            basePath = $AppURLs.excelModelPath;
        }
        businessObject.getBusinessData(basePath,businessModelID,true,succ,fail);
    }

    function loadTransferData(data,businessObjectName){
        var selectData = mQueryObjectRestriction.queryObjectRestrictionValues.length?mQueryObjectRestriction.queryObjectRestrictionValues:[];
        var allData = [];
        for(var i = 0; i < data.length; i++){
            if(allData.indexOf(data[i][businessObjectName]) == -1){
                var obj = {};
                obj.value = data[i][businessObjectName];
                obj.title = data[i][businessObjectName];
                allData.push(obj);
            }
        }
        mAllData = allData;
        transfer.reload("valueList",{data:allData,value:selectData});
    }

    function bindElementEvent(){
        form.on('select(businessModelID)', function(data){
            if(data.value != ""){
                $Utils.loading.open();
                getAndLoadBusinessObjects(businessModels.item(data.value));
            }else{
                tree.reload("authority",{data:[]});
                $(".data-row .downpanel").find(".layui-select-title span").html("无数据").end().find("input:hidden[name='businessObjectID']").val("");
            }
        });

        form.on('select(operator)', function(data){
            if(Number(data.value) != 8 && Number(data.value) != 9){
                $(".special-item").hide();
            }else{
                $(".special-item").show();
            }
            setSelectValue("");
            transfer.reload("valueList",{data:mAllData,value:[]});
        });

        form.on("submit(formSubmit)",function(obj){
            if(mOperationType == 0){
                if(changeAdd(obj)){
                    $Utils.loading.open();
                    var queryObjectRestriction = new QueryObjectRestriction();
                    queryObjectRestriction.businessModelType = businessModels.item(obj.field.businessModelID).businessModelType;
                    queryObjectRestriction.businessModelID = obj.field.businessModelID;
                    queryObjectRestriction.businessModelName = businessModels.item(obj.field.businessModelID).businessModelName;
                    queryObjectRestriction.businessObjectID = mBusinessObjects.item(obj.field.businessObjectID).businessObjectID;
                    queryObjectRestriction.businessModelName = mBusinessObjects.item(obj.field.businessObjectID).businessObjectName;
                    queryObjectRestriction.operation = Number(obj.field.operator);
                    queryObjectRestriction.queryObjectRestrictionValues = setSelectValues();
                    queryObjectRestriction.qorApplyGroups = [];
                    queryObjectRestriction.qorApplyUsers = [];

                    formAddSubmit(queryObjectRestriction,layerIndex);
                }
            }else if(mOperationType == 1){
                if(changeEdit(obj)){
                    $Utils.loading.open();
                    var queryObjectRestriction = new QueryObjectRestriction();
                    queryObjectRestriction.queryObjectRestrictionID = mQueryObjectRestriction.queryObjectRestrictionID;
                    queryObjectRestriction.businessModelType = businessModels.item(obj.field.businessModelID).businessModelType;
                    queryObjectRestriction.businessModelID = obj.field.businessModelID;
                    queryObjectRestriction.businessModelName = businessModels.item(obj.field.businessModelID).businessModelName;
                    queryObjectRestriction.businessObjectID = mBusinessObjects.item(obj.field.businessObjectID).businessObjectID;
                    queryObjectRestriction.businessModelName = mBusinessObjects.item(obj.field.businessObjectID).businessObjectName;
                    queryObjectRestriction.operation = Number(obj.field.operator);
                    queryObjectRestriction.queryObjectRestrictionValues = setSelectValues();
                    queryObjectRestriction.qorApplyGroups = setBorApplyGroups();
                    queryObjectRestriction.qorApplyUsers = setBorApplyUsers();

                    formEditSubmit(queryObjectRestriction,layerIndex);
                }else{
                    layer.close(layerIndex);
                }
            }
            return false;
        })
        
        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".data-row-bussiness-object .business-list-button").off("click").on("click", function () {
            layer.open({
                type: 1,
                title: ["数据对象列表", "font-size: 14px"],
                btn: ["确定", "取消"],
                resize: false,
                area: ["500px", "666px"],
                content: '<div id="classtree"></div>',
                success: function (layero, index) {
                    initBusinessObjectTreeList();
                },
                yes: function (index, layero) {
                    if (mBusinessObjects.item(selectBusinessObject.businessObjectID)) {
                        $(".data-row .data-row-bussiness-object").find(".layui-tree-text").html(selectBusinessObject.businessObjectName).end().find("input:hidden[name='businessObjectID']").val(selectBusinessObject.businessObjectID);
                        getAndLoadTransferData(mBusinessObjects.item(selectBusinessObject.businessObjectID), mSelectBusinessModelType, mSelectBusinessModelID);
                    } else {
                        $(".data-row .data-row-bussiness-object").find(".layui-tree-text").html("无数据").end().find("input:hidden[name='businessObjectID']").val("");
                        setSelectValue("");
                        transfer.reload("valueList", { data: [], value: [] });
                    }
                    layer.close(index);
                }
            });
            return false;
        })
    }

    function initBusinessObjectTreeList() {
        var treeData = setTreeData();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            id: "authority",
            click: function (node) { //点击节点回调
                if (node.data.businessObjectID) {
                    selectBusinessObject.businessObjectID = node.data.businessObjectID;
                    selectBusinessObject.businessObjectName = node.data.title;
                    $('#classtree').find(".select-tree").removeClass("select-tree");
                    $(node.elem).addClass("select-tree");
                } else {
                    selectBusinessObject.businessObjectID = "";
                    selectBusinessObject.businessObjectName = "";
                }
            },
        });

        $("#classtree").find(".layui-tree-set").each(function () {
            if (mBusinessObjects.item($(this).attr("data-id")) && mBusinessObjects.item($(this).attr("data-id")).businessObjectType == 0) {
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-dimension");
            }
            if (mBusinessObjects.item($(this).attr("data-id")) && mBusinessObjects.item($(this).attr("data-id")).businessObjectType == 1) {
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-measure");
            }
            if (mBusinessObjects.item($(this).attr("data-id")) && mBusinessObjects.item($(this).attr("data-id")).businessObjectType == 2) {
                $(this).find(".layui-icon-file").removeClass().addClass("iconfont bda-measure");
            }
        });
    }

    function setSelectValue(value) {
        form.val("formWindow", {
            selectValue: value
        });
    }

    function setTreeData() {
        var treeData = [];
        if (mSelectBusinessModelType == 0) {
            treeData = collectRelationModelData([mQueryObjectRestriction.businessObjectID]);
        }
        if (mSelectBusinessModelType == 1) {
            treeData = collectOthersModelData(tableModel);
        }
        if (mSelectBusinessModelType == 2) {
            treeData = collectOthersModelData(sqlModel);
        }
        if (mSelectBusinessModelType == 3) {
            treeData = collectOthersModelData(excelModel);
        }

        return treeData;
    }

    function collectRelationModelData(selectedBusinessIDs) {
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1", { title: "数据对象", id: "-1", folderID: "-1", folderParentID: "0"});
        for (var i = 0; i < relationModel.businessObjectFolders.count; i++) {
            hashTable.add(relationModel.businessObjectFolders.item(i).folderID, { title: relationModel.businessObjectFolders.item(i).folderName, id: relationModel.businessObjectFolders.item(i).folderID, folderID: relationModel.businessObjectFolders.item(i).folderID, folderParentID: relationModel.businessObjectFolders.item(i).folderParentID, sortIndex: relationModel.businessObjectFolders.item(i).sortIndex });
        }
        for (var i = 0; i < relationModel.businessObjects.count; i++) {
            var businessObject = relationModel.businessObjects.item(i);
            var parentFolder = hashTable.getValue(businessObject.businessObjectFolderID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            if (selectedBusinessIDs.indexOf(businessObject.businessObjectID) != -1) {
                parentFolder.children.push({ title: businessObject.businessObjectName, id: businessObject.businessObjectID, businessObjectID: businessObject.businessObjectID, checked: true, sortIndex: businessObject.sortIndex });
            } else {
                parentFolder.children.push({ title: businessObject.businessObjectName, id: businessObject.businessObjectID, businessObjectID: businessObject.businessObjectID, sortIndex: businessObject.sortIndex });
            }
        }
        for (var i = 0; i < relationModel.businessObjectFolders.count; i++) {
            var parentFolder = hashTable.getValue(relationModel.businessObjectFolders.item(i).folderParentID);
            if (!parentFolder.businessObjectID) {
                // parentFolder.spread = true;
                if (!parentFolder.children) {
                    parentFolder.children = [];
                }
                parentFolder.children.push(hashTable.getValue(relationModel.businessObjectFolders.item(i).folderID));
            }
        }
        if (hashTable.getValue("-1").children) {
            tempArr = hashTable.getValue("-1").children;
        }
        bubbleSort(tempArr);
        return tempArr;
    }

    function bubbleSort(arr) {
        for (var i = 0; i < arr.length; i++) {
            if (arr[i].children) {
                bubbleSort(arr[i].children);
            }
        }
        arr.sort(function (a, b) {
            return a.sortIndex - b.sortIndex;
        });
    }

    function collectOthersModelData(mSelectedBusinessModel) {
        var tempArr = [];
        for (var i = 0; i < mSelectedBusinessModel.businessObjects.count; i++) {
            var businessObject = mSelectedBusinessModel.businessObjects.item(i);
            var obj = {};
            obj.title = businessObject.businessObjectName;
            obj.businessObjectID = businessObject.businessObjectID;
            obj.id = businessObject.businessObjectID;
            obj.sortIndex = businessObject.sortIndex;
            tempArr.push(obj);
        }
        bubbleSort(tempArr)
        return tempArr;
    }

    function changeAdd(obj){
        if(obj.field.businessModelID == ""){
            layer.msg("请选择业务模型。",{icon: 2});
            return false;
        }
        if(obj.field.businessObjectID == ""){
            layer.msg("请选择业务对象。",{icon: 2});
            return false;
        }
        if(obj.field.operator == 8 || obj.field.operator == 9){
            if(obj.field.selectValue == ""){
                layer.msg("请选择值。",{icon: 2});
                return false;
            }
        }else{
            if(transfer.getData('valueList').length == 0){
                layer.msg("请选择值。",{icon: 2});
                return false;
            }
        }
        return true;
    }

    function changeEdit(obj){
        var selectData = transfer.getData("valueList");
        if(obj.field.businessObjectID == ""){
            layer.msg("请选择业务对象。",{icon: 2});
            return false;
        }
        if(selectData.length == 0){
            layer.msg("请选择值。",{icon: 2});
            return false;
        }
        if(mQueryObjectRestriction.businessModelID != obj.field.businessModelID){
            return true;
        }
        if(mQueryObjectRestriction.businessObjectID != obj.field.businessObjectID){
            return true;
        }
        if(mQueryObjectRestriction.operation != obj.field.operator){
            return true;
        }
        if(mQueryObjectRestriction.queryObjectRestrictionValues.length != selectData.length){
            return true;
        }
        for(var i =0; i < selectData.length; i++){
            if(mQueryObjectRestriction.queryObjectRestrictionValues.indexOf(selectData[i].value) == -1){
                return true;
            }
        }
        return false;
    }

    function setSelectValues(){
        var selectData = transfer.getData("valueList");
        var tempArr = [];
        for(var i = 0; i < selectData.length; i++){
            tempArr.push(selectData[i].value);
        }
        return tempArr;
    }

    function setBorApplyGroups(){
        var tempArr = [];
        for(var i = 0; i < mQueryObjectRestriction.qorApplyGroups.count; i++){
            var borApplyGroup = new BorApplyGroup();
            borApplyGroup.applyGroupID = mQueryObjectRestriction.qorApplyGroups.item(i).applyGroupID;
            borApplyGroup.applyGroupName = mQueryObjectRestriction.qorApplyGroups.item(i).applyGroupName;
            tempArr.push(borApplyGroup);
        }
        return tempArr;
    }

    function setBorApplyUsers(){
        var tempArr = [];
        for(var i = 0; i < mQueryObjectRestriction.qorApplyUsers.count; i++){
            var borApplyUser = new BorApplyUser();
            borApplyUser.applyUserID = mQueryObjectRestriction.qorApplyUsers.item(i).applyUserID;
            borApplyUser.applyUserName = mQueryObjectRestriction.qorApplyUsers.item(i).applyUserName;
            tempArr.push(borApplyUser);
        }
        return tempArr;
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();