/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-16 19:38:45
 * @LastEditTime: 2020-05-13 22:14:07
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var groups = new Groups();
    var organizationUsers = new OrganizationUsers();
    var mQueryObjectRestriction = null;
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mBackupsGroupQueryObjectRestrictions = [];
    var mBackupsUserQueryObjectRestrictions = [];
    var formEditSubmit = null;
    var selectRowData = null;

    window.initAuthorityListForm = function(index,queryObjectRestriction,editSubmit){
        mQueryObjectRestriction = queryObjectRestriction;
        formEditSubmit = editSubmit;
        loadListTableHead();
        getRequisiteDataAndLoadList();

        buttonEvent(index);
    };

    function loadListTableHead(){
        var tableHead = [
            [
                {field: "name", title: "名称"},
                {field: "type", title: "类型",templet:"#listType"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getRequisiteDataAndLoadList(){
        var succ = function(){
            $Utils.loading.close();
			getGroupsAndLoadList();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
		organizationUsers.getItems(true,succ,fail);
    }

    function getGroupsAndLoadList(){
        var succ = function(){
            $Utils.loading.close();
			loadList();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function loadList(){
        var tableBody = [];
        for(var i = 0; i < mQueryObjectRestriction.qorApplyGroups.count; i++){
            var obj = {};
            obj.name = mQueryObjectRestriction.qorApplyGroups.item(i).applyGroupName;
            obj.type = 0;
            obj.dataID = mQueryObjectRestriction.qorApplyGroups.item(i).applyGroupID;
            tableBody.push(obj);
            mBackupsGroupQueryObjectRestrictions.push(mQueryObjectRestriction.qorApplyGroups.item(i).applyGroupID);
        }
        for(var i = 0; i < mQueryObjectRestriction.qorApplyUsers.count; i++){
            var obj = {};
            obj.name = mQueryObjectRestriction.qorApplyUsers.item(i).applyUserName;
            obj.type = 1;
            obj.dataID = mQueryObjectRestriction.qorApplyUsers.item(i).applyUserID;
            tableBody.push(obj);
            mBackupsUserQueryObjectRestrictions.push(mQueryObjectRestriction.qorApplyUsers.item(i).applyUserID);
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add-group").click(function(){
            getAndLoadGroupListForm();
        });

        $(".add-user").click(function(){
            getAndLoadUsersListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteDataItem();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectRowData){
                deleteDataItem([selectRowData.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        $(".column-button .layui-btn-determine").click(function(){
            if(changeUser() || changeGroup()){
                $Utils.loading.open();
                var queryObjectRestriction = new QueryObjectRestriction();
                queryObjectRestriction.queryObjectRestrictionID = mQueryObjectRestriction.queryObjectRestrictionID;
                queryObjectRestriction.businessModelID = mQueryObjectRestriction.businessModelID;
                queryObjectRestriction.businessModelName = mQueryObjectRestriction.businessModelName;
                queryObjectRestriction.businessModelType = mQueryObjectRestriction.businessModelType;
                queryObjectRestriction.businessObjectID = mQueryObjectRestriction.businessObjectID;
                queryObjectRestriction.businessObjectName = mQueryObjectRestriction.businessObjectName;
                queryObjectRestriction.operation = mQueryObjectRestriction.operation;
                queryObjectRestriction.queryObjectRestrictionValues = mQueryObjectRestriction.queryObjectRestrictionValues;
                queryObjectRestriction.qorApplyGroups = setQorApplyGroups();
                queryObjectRestriction.qorApplyUsers = setQorApplyUsers();
                queryObjectRestriction.isDateTime = mQueryObjectRestriction.isDateTime;
                formEditSubmit(queryObjectRestriction,index);
            }else{
                layer.close(index);
            }
        });

        $(".column-button .layui-btn-cancel").click(function(){
            layer.close(index);
        });

        table.on('row(list)', function(obj){
            selectRowData = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });
    }

    function getAndLoadGroupListForm(){
        $.ajax({
            url: "html/iControl/groupList.html",
            type: 'GET',
            success: function(data){
                loadGroupsListForm(data)
            }
        });
    }

    function loadGroupsListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 0){
                        transmitData.push(groups.item(mTableBody[i].dataID));
                    }
                }
                initGroupList(index,transmitData,groups,addGroupList);
            }
        });
    }

    function getAndLoadUsersListForm(){
        $.ajax({
            url: "html/iControl/userList.html",
            type: 'GET',
            success: function(data){
                loadUsersListForm(data)
            }
        });
    }

    function loadUsersListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 1){
                        for(var j = 0; j < organizationUsers.count; j++){
                            if(mTableBody[i].dataID == organizationUsers.item(j).userID){
                                transmitData.push(organizationUsers.item(j));
                                break;
                            }
                        }
                        
                    }
                }
                initUserList(index,transmitData,organizationUsers,addUserList);
            }
        });
    }

    function deleteDataItem(selectData){
        for(var i = 0; i < selectData.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectData[i].dataID == mTableBody[j].dataID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function changeGroup(){
        var groupIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                groupIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsGroupQueryObjectRestrictions.length == 0 && groupIDs.length == 0){
            return false;
        }
        

        if(mBackupsGroupQueryObjectRestrictions.length != groupIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsGroupQueryObjectRestrictions.length; i++){
            if(groupIDs.indexOf(mBackupsGroupQueryObjectRestrictions[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function changeUser(){
        var userIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                userIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsUserQueryObjectRestrictions.length == 0 && userIDs.length == 0){
            return false;
        }
        

        if(mBackupsUserQueryObjectRestrictions.length != userIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsUserQueryObjectRestrictions.length; i++){
            if(userIDs.indexOf(mBackupsUserQueryObjectRestrictions[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function setQorApplyGroups(){
        var tempArr = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                var borApplyGroup = new QorApplyGroup();
                borApplyGroup.applyGroupID = mTableBody[i].dataID;
                borApplyGroup.applyGroupName = mTableBody[i].name;
                tempArr.push(borApplyGroup);
            }
        }
        return tempArr;
    }

    function setQorApplyUsers(){
        var tempArr = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                var borApplyUser = new QorApplyUser();
                borApplyUser.applyUserID = mTableBody[i].dataID;
                borApplyUser.applyUserName = mTableBody[i].name;
                tempArr.push(borApplyUser);
            }
        }
        return tempArr;
    }

    var addGroupList = function(groupList,index){
        layer.close(index);
        for(var i = 0; i < groupList.length; i++){
            var obj = {};
            obj.name = groupList[i].groupName;
            obj.type = 0;
            obj.dataID = groupList[i].groupID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };

    var addUserList = function(userList,index){
        layer.close(index);
        for(var i = 0; i < userList.length; i++){
            var obj = {};
            obj.name = userList[i].userName;
            obj.type = 1;
            obj.dataID = userList[i].userID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };
    
}();