/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-16 10:24:46
 * @LastEditTime: 2020-08-12 17:53:43
 * @LastModifyUser: 
 * @Remark: 
 */
function BusinessObjectRestriction(){
    this.businessObjectRestrictionID = null;
    this.businessModelID = null;
    this.businessModelName = null;
    this.businessModelType = null;
    this.borBusinessObjects = new BorBusinessObjects();

    this.borApplyGroups = new BorApplyGroups();
    this.borApplyUsers = new BorApplyUsers();

    this.init = function(options){
        for(var key in options){
            if(key === "borBusinessObjects"){
                this[key].setBorBusinessObjects(options[key]);
            }else if(key === "borApplyGroups"){
                this[key].setBorApplyGroups(options[key]);
            }else if(key === "borApplyUsers"){
                this[key].setBorApplyUsers(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function BusinessObjectRestrictions(){
    var me = this;
    this.count = 0;
    this.aryBusinessObjectRestrictions = [];
    this.dicBusinessObjectRestrictions = {};

    this.add = function (businessObjectRestriction) {
        this.aryBusinessObjectRestrictions.push(businessObjectRestriction);
        this.dicBusinessObjectRestrictions[businessObjectRestriction.businessObjectRestrictionID] = businessObjectRestriction;
        this.count = this.aryBusinessObjectRestrictions.length;
    };
    this.remove = function (businessObjectRestriction) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBusinessObjectRestrictions[i].businessObjectRestrictionID==businessObjectRestriction.businessObjectRestrictionID){
                k = i;
                break;
            }
        }
        this.aryBusinessObjectRestrictions.splice(k,1);
        delete this.dicBusinessObjectRestrictions[businessObjectRestriction.businessObjectRestrictionID];
        this.count = this.aryBusinessObjectRestrictions.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBusinessObjectRestrictions[indexOrKey];
        }else{
            return this.dicBusinessObjectRestrictions[indexOrKey];
        }
    };
    this.addItem = function(businessObjectRestriction,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessObjectRestrictionsPath;
        var obj = JSON.stringify(businessObjectRestriction);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(businessObjectRestriction,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessObjectRestrictionsPath + "/" + businessObjectRestriction.businessObjectRestrictionID;
        var obj = JSON.stringify(businessObjectRestriction);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessObjectRestrictionID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessObjectRestrictionsPath + "/" + businessObjectRestrictionID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessObjectRestrictionID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessObjectRestrictionsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setBusinessObjectRestrictions(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setBusinessObjectRestrictions(data){
        me.count = 0;
        me.aryBusinessObjectRestrictions = [];
        me.dicBusinessObjectRestrictions = {};
        for(var i = 0; i < data.length; i++){
            var businessObjectRestriction = new BusinessObjectRestriction();
            businessObjectRestriction.init(data[i]);
            me.add(businessObjectRestriction);
        }
    }
}

function BorBusinessObject(){
    this.businessObjectID = null;
    this.businessObjectName = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function BorBusinessObjects(){
    var me = this;
    this.count = 0;
    this.aryBorBusinessObjects = [];
    this.dicBorBusinessObjects = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBorBusinessObjects[indexOrKey];
        }else{
            return this.dicBorBusinessObjects[indexOrKey];
        }
    };
    this.add = function (borBusinessObject) {
        this.aryBorBusinessObjects.push(borBusinessObject);
        this.dicBorBusinessObjects[borBusinessObject.borBusinessObjectID] = borBusinessObject;
        this.count = this.aryBorBusinessObjects.length;
    };
    this.remove = function (borBusinessObject) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBorBusinessObjects[i].borBusinessObjectID==borBusinessObject.borBusinessObjectID){
                k = i;
                break;
            }
        }
        this.aryBorBusinessObjects.splice(k,1);
        delete this.dicBorBusinessObjects[borBusinessObject.borBusinessObjectID];
        this.count = this.aryBorBusinessObjects.length;
    };
    this.setBorBusinessObjects = function(data){
        me.count = 0;
        me.aryBorBusinessObjects = [];
        me.dicBorBusinessObjects = {};
        for(var i = 0; i < data.length; i++){
            var borBusinessObject = new BorBusinessObject();
            borBusinessObject.init(data[i]);
            me.add(borBusinessObject);
        }
    }
}

function ApplyGroup(){
    this.applyGroupID = null;
    this.applyGroupName = null;
}

function BorApplyGroup(){
    ApplyGroup.call(this);

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function BorApplyGroups(){
    var me = this;
    this.count = 0;
    this.aryBorApplyGroups = [];
    this.dicBorApplyGroups = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBorApplyGroups[indexOrKey];
        }else{
            return this.dicBorApplyGroups[indexOrKey];
        }
    };
    this.add = function (borApplyGroup) {
        this.aryBorApplyGroups.push(borApplyGroup);
        this.dicBorApplyGroups[borApplyGroup.applyGroupID] = borApplyGroup;
        this.count = this.aryBorApplyGroups.length;
    };
    this.remove = function (borApplyGroup) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBorApplyGroups[i].applyGroupID==borApplyGroup.applyGroupID){
                k = i;
                break;
            }
        }
        this.aryBorApplyGroups.splice(k,1);
        delete this.dicBorApplyGroups[borApplyGroup.applyGroupID];
        this.count = this.aryBorApplyGroups.length;
    };
    this.setBorApplyGroups = function(data){
        me.count = 0;
        me.aryBorApplyGroups = [];
        me.dicBorApplyGroups = {};
        for(var i = 0; i < data.length; i++){
            var borApplyGroup = new BorApplyGroup();
            borApplyGroup.init(data[i]);
            me.add(borApplyGroup);
        }
    }
}

function ApplyUser(){
    this.applyUserID = null;
    this.applyUserName = null;
}

function BorApplyUser(){
    ApplyUser.call(this);

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function BorApplyUsers(){
    var me = this;
    this.count = 0;
    this.aryBorApplyUsers = [];
    this.dicBorApplyUsers = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBorApplyUsers[indexOrKey];
        }else{
            return this.dicBorApplyUsers[indexOrKey];
        }
    };
    this.add = function (borApplyUser) {
        this.aryBorApplyUsers.push(borApplyUser);
        this.dicBorApplyUsers[borApplyUser.applyUserID] = borApplyUser;
        this.count = this.aryBorApplyUsers.length;
    };
    this.remove = function (borApplyUser) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBorApplyUsers[i].applyUserID==borApplyUser.applyUserID){
                k = i;
                break;
            }
        }
        this.aryBorApplyUsers.splice(k,1);
        delete this.dicBorApplyUsers[borApplyUser.applyUserID];
        this.count = this.aryBorApplyUsers.length;
    };
    this.setBorApplyUsers = function(data){
        me.count = 0;
        me.aryBorApplyUsers = [];
        me.dicBorApplyUsers = {};
        for(var i = 0; i < data.length; i++){
            var borApplyUser = new BorApplyUser();
            borApplyUser.init(data[i]);
            me.add(borApplyUser);
        }
    }
}

function QueryObjectRestriction(){
    this.queryObjectRestrictionID = null;
    this.businessModelType = null;
    this.businessModelID = null;
    this.businessModelName = null;
    this.businessObjectID = null;
    this.businessObjectName = null;
    this.operation = null;
    this.queryObjectRestrictionValues = [];

    this.qorApplyGroups = new QorApplyGroups();
    this.qorApplyUsers = new QorApplyUsers();

    this.init = function(options){
        for(var key in options){
            if(key === "qorApplyGroups"){
                this[key].setQorApplyGroups(options[key]);
            }else if(key === "qorApplyUsers"){
                this[key].setQorApplyUsers(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function QueryObjectRestrictions(){
    var me = this;
    this.count = 0;
    this.aryQueryObjectRestrictions = [];
    this.dicQueryObjectRestrictions = {};

    this.add = function (queryObjectRestriction) {
        this.aryQueryObjectRestrictions.push(queryObjectRestriction);
        this.dicQueryObjectRestrictions[queryObjectRestriction.queryObjectRestrictionID] = queryObjectRestriction;
        this.count = this.aryQueryObjectRestrictions.length;
    };
    this.remove = function (queryObjectRestriction) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryQueryObjectRestrictions[i].queryObjectRestrictionID==queryObjectRestriction.queryObjectRestrictionID){
                k = i;
                break;
            }
        }
        this.aryQueryObjectRestrictions.splice(k,1);
        delete this.dicQueryObjectRestrictions[queryObjectRestriction.queryObjectRestrictionID];
        this.count = this.aryQueryObjectRestrictions.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryQueryObjectRestrictions[indexOrKey];
        }else{
            return this.dicQueryObjectRestrictions[indexOrKey];
        }
    };
    this.addItem = function(queryObjectRestriction,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.queryObjectRestrictionsPath;
        var obj = JSON.stringify(queryObjectRestriction);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(queryObjectRestriction,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.queryObjectRestrictionsPath + "/" + queryObjectRestriction.queryObjectRestrictionID;
        var obj = JSON.stringify(queryObjectRestriction);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(queryObjectRestrictionID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.queryObjectRestrictionsPath + "/" + queryObjectRestrictionID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(queryObjectRestrictionID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.queryObjectRestrictionsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setQueryObjectRestrictions(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setQueryObjectRestrictions(data){
        me.count = 0;
        me.aryQueryObjectRestrictions = [];
        me.dicQueryObjectRestrictions = {};
        for(var i = 0; i < data.length; i++){
            var queryObjectRestriction = new QueryObjectRestriction();
            queryObjectRestriction.init(data[i]);
            me.add(queryObjectRestriction);
        }
    }
}

function QorApplyGroup(){
    ApplyGroup.call(this);

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function QorApplyGroups(){
    var me = this;
    this.count = 0;
    this.aryQorApplyGroups = [];
    this.dicQorApplyGroups = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryQorApplyGroups[indexOrKey];
        }else{
            return this.dicQorApplyGroups[indexOrKey];
        }
    };
    this.add = function (qorApplyGroup) {
        this.aryQorApplyGroups.push(qorApplyGroup);
        this.dicQorApplyGroups[qorApplyGroup.applyGroupID] = qorApplyGroup;
        this.count = this.aryQorApplyGroups.length;
    };
    this.remove = function (qorApplyGroup) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryQorApplyGroups[i].applyGroupID==qorApplyGroup.applyGroupID){
                k = i;
                break;
            }
        }
        this.aryQorApplyGroups.splice(k,1);
        delete this.dicQorApplyGroups[qorApplyGroup.applyGroupID];
        this.count = this.aryQorApplyGroups.length;
    };
    this.setQorApplyGroups = function(data){
        me.count = 0;
        me.aryQorApplyGroups = [];
        me.dicQorApplyGroups = {};
        for(var i = 0; i < data.length; i++){
            var qorApplyGroup = new QorApplyGroup();
            qorApplyGroup.init(data[i]);
            me.add(qorApplyGroup);
        }
    }
}

function QorApplyUser(){
    ApplyUser.call(this);

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function QorApplyUsers(){
    var me = this;
    this.count = 0;
    this.aryQorApplyUsers = [];
    this.dicQorApplyUsers = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryQorApplyUsers[indexOrKey];
        }else{
            return this.dicQorApplyUsers[indexOrKey];
        }
    };
    this.add = function (qorApplyUser) {
        this.aryQorApplyUsers.push(qorApplyUser);
        this.dicQorApplyUsers[qorApplyUser.applyUserID] = qorApplyUser;
        this.count = this.aryQorApplyUsers.length;
    };
    this.remove = function (qorApplyUser) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryQorApplyUsers[i].applyUserID==qorApplyUser.applyUserID){
                k = i;
                break;
            }
        }
        this.aryQorApplyUsers.splice(k,1);
        delete this.dicQorApplyUsers[qorApplyUser.applyUserID];
        this.count = this.aryQorApplyUsers.length;
    };
    this.setQorApplyUsers = function(data){
        me.count = 0;
        me.aryQorApplyUsers = [];
        me.dicQorApplyUsers = {};
        for(var i = 0; i < data.length; i++){
            var qorApplyUser = new QorApplyUser();
            qorApplyUser.init(data[i]);
            me.add(qorApplyUser);
        }
    }
}