/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-16 09:28:15
 * @LastEditTime: 2021-02-21 18:27:57
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, laypage = layui.laypage;
    var businessObjectRestrictions = new BusinessObjectRestrictions();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();

    function initMain(){
        initTableHead();
        getAndLoadTableBody();

        bindEvent();
    }

    function initTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "businessModelName",title: "业务模型", sort: true},
                {field: "borBusinessObjects",title: "受限对象"},
                {field: "borApplyUsers",title: "应用用户"},
                {field: "borApplyGroups",title: "应用组"},
                {title: "操作",templet: "#setAuthority",width: 100, align:"center"} 
            ]
        ];
        table.render({
            elem: '#authorityList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取列权限列表",errorStatus,msg);
		};
		businessObjectRestrictions.getItems(true,succ,fail);
    }

    function setTableBody(){
        var tableBody = [];
        for(var i = 0; i < businessObjectRestrictions.count; i++){
            var tempObj = {};
            for(var key in businessObjectRestrictions.item(i)){
                if(key === "borBusinessObjects"){
                    var tempArr = [];
                    for(var j = 0; j < businessObjectRestrictions.item(i)[key].count; j++){
                        tempArr.push(businessObjectRestrictions.item(i)[key].item(j).businessObjectName);
                    }
                    tempObj["borBusinessObjects"] = tempArr.join(",");
                }else if(key === "borApplyGroups"){
                    var tempArr = [];
                    for(var j = 0; j < businessObjectRestrictions.item(i)[key].count; j++){
                        tempArr.push(businessObjectRestrictions.item(i)[key].item(j).applyGroupName);
                    }
                    tempObj["borApplyGroups"] = tempArr.join(",");
                }else if(key === "borApplyUsers"){
                    var tempArr = [];
                    for(var j = 0; j < businessObjectRestrictions.item(i)[key].count; j++){
                        tempArr.push(businessObjectRestrictions.item(i)[key].item(j).applyUserName);
                    }
                    tempObj["borApplyUsers"] = tempArr.join(",");
                }else{
                    tempObj[key] = businessObjectRestrictions.item(i)[key];
                }
            }
            tableBody.push(tempObj);
        }
        return tableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadTableBody(data,obj);
            }
        });
    }

    function loadTableBody(tableBodyData,obj){
        var tableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("authorityList",{data:tableBody,limit:tableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("authorityList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("authorityList",{height: tableBodyHeight});
        });
    }

    function bindEvent(){
        table.on('sort(authorityList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if(type === 'asc'){ //升序
                thisData = $Utils.sorter(data, field);
            }else if(type === 'desc'){ //降序
                thisData = $Utils.sorter(data, field, true);
            }else{ //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });
    
        $(".search-button").click(function(){
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if(searchValue == ""){
                searchData = mTableBodyData;
            }else{
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".add-column").click(function(){
            var businessObjectRestriction = new BusinessObjectRestriction();
            getAndLoadColumnForm(0,businessObjectRestriction);
        });

        $(".edit-column").click(function(){
            if(table.checkStatus('authorityList').data.length){
                var businessObjectRestriction = businessObjectRestrictions.item(table.checkStatus('authorityList').data[0].businessObjectRestrictionID);
                getAndLoadColumnForm(1,businessObjectRestriction);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });

        $(".delete-column").click(function(){
            if(table.checkStatus('authorityList').data.length){
                layer.open({
                    type: 0,
                    title: "删除列权限",
                    closeBtn: 1,
                    shadeClose: true,
                    resize: false,
                    area: ["480px","270px"],
                    skin: "delete-window",
                    content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除？</div></div>",
                    btn: ["是","否"],
                    success: function(layero,index){
                        $(layero).find('.layui-layer-content').css('height','137px');
                    },
                    yes: function(index,layero){
                        layer.close(index);
                        $Utils.loading.open();
                        deleteColumn(table.checkStatus('authorityList').data[0].businessObjectRestrictionID);
                    }
                });
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        
        $(".refresh").click(function(){
            $Utils.loading.open();
            getAndLoadTableBody();
        });

        table.on("tool(authorityList)", function(obj){
            var businessObjectRestriction = businessObjectRestrictions.item(obj.data.businessObjectRestrictionID);
            if(obj.event == "empower"){
                getAndLoadAuthorityListForm(businessObjectRestriction);
            }
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].borBusinessObjects.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].borApplyUsers.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadColumnForm(operationType,businessObjectRestriction){
        $.ajax({
            url: "html/iControl/authority/data/column.html",
            type: 'GET',
            success: function(data){
                loadColumnForm(data,operationType,businessObjectRestriction);
            }
        });
    }

    function loadColumnForm(strHtml,operationType,businessObjectRestriction){
        layer.open({
            type: 1,
            title: ["列权限","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initColumnForm(operationType,businessObjectRestriction,index,addSubmit,editSubmit);
            }
        });
    }

    function getAndLoadAuthorityListForm(businessObjectRestriction){
        $.ajax({
            url: "html/iControl/authority/data/columnAuthorityList.html",
            type: 'GET',
            success: function(data){
                loadAuthorityListForm(data,businessObjectRestriction)
            }
        });
    }

    function loadAuthorityListForm(strHtml,businessObjectRestriction){
        layer.open({
            type: 1,
            title: ["应用范围","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initAuthorityListForm(index,businessObjectRestriction,editSubmit);
            }
        });
    }

    function deleteColumn(businessObjectRestrictionID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除列权限",errorStatus,msg);
        };
        businessObjectRestrictions.deleteItem(businessObjectRestrictionID,true,succ,fail);
    }

    var addSubmit = function(businessObjectRestriction,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增列权限",errorStatus,msg);
        };
        
		businessObjectRestrictions.addItem(businessObjectRestriction,true,succ,fail);
    };

    var editSubmit = function(businessObjectRestriction,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改列权限",errorStatus,msg);
        };

		businessObjectRestrictions.editItem(businessObjectRestriction,true,succ,fail);
    };

}();