/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-16 14:07:36
 * @LastEditTime: 2020-08-27 10:48:12
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form,tree = layui.tree;
    var businessModels = new BusinessModels();
    var relationModel = new RelationModel();
    var tableModel = new TableModel();
    var sqlModel = new SqlModel();
    var excelModel = new ExcelModel();
    var mBusinessObjectRestriction = null, layerIndex = null,mOperationType = null,formAddSubmit = null,formEditSubmit = null, mSelectedBusinessModel = null;
    var businessObjectIsChange = true;

    window.initColumnForm = function(operationType,businessObjectRestriction,index,addSubmit,editSubmit){
        mBusinessObjectRestriction = businessObjectRestriction;
        layerIndex = index;
        formAddSubmit = addSubmit
        formEditSubmit = editSubmit
        mOperationType = operationType;
        getAndLoadBusinessModels();
        if(mOperationType == 0){
            tree.render({
                elem: "#treeList",
                data: [],
                showCheckbox: true,  //是否显示复选框
                id: "authority",
                isJump: false,
                onlyIconControl: true
            });
        }else if(mOperationType == 1){
            getAndLoadBusinessObjects(mBusinessObjectRestriction);
        }

        bindElementEvent();
    }

    function getAndLoadBusinessModels(){
        var succ = function(){
            loadBusinessModelsSelectForm();
        };
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function loadBusinessModelsSelectForm(){
        var selectModelID = "";
        var businessModelsDom = document.getElementById("businessModelID");
        for(var i = 0; i < businessModels.count; i++){
            var option = document.createElement("option");
            option.setAttribute("value",businessModels.item(i).businessModelID);
            if(mOperationType == 0){
                if(i == 0){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }else if(mOperationType == 1 && i > 0){
                if(businessModels.item(i).businessModelID == mBusinessObjectRestriction.businessModelID){
                    option.setAttribute("selected",true);
                    selectModelID = businessModels.item(i).businessModelID;
                }
            }
            option.innerText = businessModels.item(i).businessModelName;
            businessModelsDom.appendChild(option);
        }
        form.render();
        getAndLoadBusinessObjects(businessModels.item(selectModelID));
    }

    function getAndLoadBusinessObjects(selectedBusinessModel){
        var succ = function(){
            $Utils.loading.close();
            loadBusinessObjectTreeList(selectedBusinessModel.businessModelType);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+selectedBusinessModel.businessModelName+" 业务对象",errorStatus,msg);
        };
        if(selectedBusinessModel.businessModelType == 0){
            relationModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 1){
            tableModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 2){
            sqlModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
        if(selectedBusinessModel.businessModelType == 3){
            excelModel.initByModelID(selectedBusinessModel.businessModelID,true,succ,fail);
        }
    }

    function loadBusinessObjectTreeList(businessModelType){
        var selectedBusinessIDs = collectSelectedBusinessObjectIDs();
        var treeData = [];
        var allBusinessObjects = null;
        if(businessModelType == 0){
            treeData = collectRelationModelData(selectedBusinessIDs);
            allBusinessObjects = relationModel.businessObjects;
        }
        if(businessModelType == 1){
            treeData = collectOthersModelData(tableModel,selectedBusinessIDs);
            allBusinessObjects = tableModel.businessObjects;
        }
        if(businessModelType == 2){
            treeData = collectOthersModelData(sqlModel,selectedBusinessIDs);
            allBusinessObjects = sqlModel.businessObjects;
        }
        if(businessModelType == 3){
            treeData = collectOthersModelData(excelModel,selectedBusinessIDs);
            allBusinessObjects = excelModel.businessObjects;
        }

        tree.render({
            elem: "#treeList",
            data: treeData,
            showCheckbox: true,  //是否显示复选框
            id: "authority",
            isJump: false,
            onlyIconControl: true
        });
        $("#treeList").find("input[type=checkbox]").each(function(){
            if(allBusinessObjects.item($(this).val()) && allBusinessObjects.item($(this).val()).businessObjectType == 0){
                $(this).siblings(".layui-tree-iconClick").find(".layui-icon").removeClass().addClass("iconfont bda-dimension");
            }
            if(allBusinessObjects.item($(this).val()) && allBusinessObjects.item($(this).val()).businessObjectType == 1){
                $(this).siblings(".layui-tree-iconClick").find(".layui-icon").removeClass().addClass("iconfont bda-measure");
            }
            if(allBusinessObjects.item($(this).val()) && allBusinessObjects.item($(this).val()).businessObjectType == 2){
                $(this).siblings(".layui-tree-iconClick").find(".layui-icon").removeClass().addClass("iconfont bda-measure");
            }
        });
    }

    function collectSelectedBusinessObjectIDs(){
        var tempArr = [];
        for(var i = 0; i < mBusinessObjectRestriction.borBusinessObjects.count; i++){
            if(tempArr.indexOf(mBusinessObjectRestriction.borBusinessObjects.item(i).businessObjectID) == -1){
                tempArr.push(mBusinessObjectRestriction.borBusinessObjects.item(i).businessObjectID);
            }
        }

        return tempArr;
    }

    function collectRelationModelData(selectedBusinessIDs){
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "数据对象",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < relationModel.businessObjectFolders.count; i++){
            hashTable.add(relationModel.businessObjectFolders.item(i).folderID,{title:relationModel.businessObjectFolders.item(i).folderName,id:relationModel.businessObjectFolders.item(i).folderID,folderID:relationModel.businessObjectFolders.item(i).folderID,folderParentID:relationModel.businessObjectFolders.item(i).folderParentID,sortIndex:relationModel.businessObjectFolders.item(i).sortIndex});
        }
        for(var i = 0; i < relationModel.businessObjects.count; i++){
            var businessObject = relationModel.businessObjects.item(i);
            var parentFolder = hashTable.getValue(businessObject.businessObjectFolderID);
            // parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            if(selectedBusinessIDs.indexOf(businessObject.businessObjectID) != -1){
                parentFolder.children.push({title:businessObject.businessObjectName,id:businessObject.businessObjectID,businessObjectID:businessObject.businessObjectID,checked:true,sortIndex:businessObject.sortIndex});
            }else{
                parentFolder.children.push({title:businessObject.businessObjectName,id:businessObject.businessObjectID,businessObjectID:businessObject.businessObjectID,sortIndex:businessObject.sortIndex});
            }
        }
        for(var i = 0; i < relationModel.businessObjectFolders.count; i++){
            var parentFolder = hashTable.getValue(relationModel.businessObjectFolders.item(i).folderParentID);
            // parentFolder.spread = true;
            if(!parentFolder.businessObjectID){
                if(!parentFolder.children){
                    parentFolder.children = [];
                }
                parentFolder.children.push(hashTable.getValue(relationModel.businessObjectFolders.item(i).folderID));
            }
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }
        bubbleSort(tempArr);
        return tempArr;
    }

    function bubbleSort(arr){
		for(var i = 0; i < arr.length; i++){
			if(arr[i].children){
				bubbleSort(arr[i].children);
			}
		}
		arr.sort(function(a,b){
			return a.sortIndex -  b.sortIndex;
		});
    }

    function collectOthersModelData(mSelectedBusinessModel,selectedBusinessIDs){
        var tempArr = [];
        for(var i = 0; i < mSelectedBusinessModel.businessObjects.count; i++){
            var businessObject = mSelectedBusinessModel.businessObjects.item(i);
            var obj = {};
            obj.title = businessObject.businessObjectName;
            obj.businessObjectID = businessObject.businessObjectID;
            obj.id = businessObject.businessObjectID;
            obj.sortIndex = businessObject.sortIndex;
            if(selectedBusinessIDs.indexOf(businessObject.businessObjectID) != -1){
                obj.checked = true;
            }
            tempArr.push(obj);
        }
        bubbleSort(tempArr)
        return tempArr;
    }

    function bindElementEvent(){
        form.on('select(businessModelID)', function(data){
            if(data.value != ""){
                $Utils.loading.open();
                getAndLoadBusinessObjects(businessModels.item(data.value));
            }else{
                tree.render({
                    elem: "#treeList",
                    data: [],
                    showCheckbox: true,  //是否显示复选框
                    id: "authority",
                    isJump: false,
                    onlyIconControl: true
                });
            }
        });

        form.on("submit(formSubmit)",function(obj){
            if(mOperationType == 0){
                if(changeAdd(obj)){
                    $Utils.loading.open();
                    var businessObjectRestriction = new BusinessObjectRestriction();
                    businessObjectRestriction.businessModelID = obj.field.businessModelID;
                    businessObjectRestriction.businessModelName = businessModels.item(obj.field.businessModelID).businessModelName;
                    businessObjectRestriction.businessModelType = businessModels.item(obj.field.businessModelID).businessModelType;
                    businessObjectRestriction.borBusinessObjects = setBusinessObjects();
                    businessObjectRestriction.borApplyGroups = [];
                    businessObjectRestriction.borApplyUsers = [];

                    formAddSubmit(businessObjectRestriction,layerIndex);
                }
            }else if(mOperationType == 1){
                if(changeEdit(obj)){
                    $Utils.loading.open();
                    var businessObjectRestriction = new BusinessObjectRestriction();
                    businessObjectRestriction.businessObjectRestrictionID = mBusinessObjectRestriction.businessObjectRestrictionID;
                    businessObjectRestriction.businessModelID = obj.field.businessModelID;
                    businessObjectRestriction.businessModelName = businessModels.item(obj.field.businessModelID).businessModelName;
                    businessObjectRestriction.businessModelType = businessModels.item(obj.field.businessModelID).businessModelType;
                    businessObjectRestriction.borBusinessObjects = setBusinessObjects();
                    businessObjectRestriction.borApplyGroups = setBorApplyGroups();
                    businessObjectRestriction.borApplyUsers = setBorApplyUsers();

                    formEditSubmit(businessObjectRestriction,layerIndex);
                }else{
                    if(businessObjectIsChange){
                        layer.close(layerIndex);
                    }
                }
            }
            return false;
        })
        
        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
    }

    function changeAdd(obj){
        if(obj.field.businessModelID == ""){
            layer.msg("请选择业务模型。",{icon: 2});
            return false;
        }
        var checkedData = getCheckBusinessObjectID();
        if(checkedData.length == 0){
            layer.msg("请选择业务对象。",{icon: 2});
            return false;
        }
        return true;
    }

    function changeEdit(){
        var checkedData = getCheckBusinessObjectID();
        var selectedBusinessIDs = collectSelectedBusinessObjectIDs();
        if(checkedData.length == 0){
            layer.msg("请选择业务对象。",{icon: 2});
            businessObjectIsChange = false;
            return false;
        }
        if(checkedData.length != selectedBusinessIDs.length){
            return true;
        }
        for(var i = 0; i < checkedData.length; i++){
            if(selectedBusinessIDs.indexOf(checkedData[i].businessObjectID) == -1){
                return true;
            }
        }
        return false;
    }

    function setBusinessObjects(){
        var checkedData = getCheckBusinessObjectID();
        var tempArr = []
        for(var i = 0; i < checkedData.length; i++){
            var borBusinessObject = new BorBusinessObject();
            borBusinessObject.businessObjectID = checkedData[i].businessObjectID;
            borBusinessObject.businessObjectName = checkedData[i].businessObjectName;
            tempArr.push(borBusinessObject);
        }
        return tempArr;
    }

    function setBorApplyGroups(){
        var tempArr = [];
        for(var i = 0; i < mBusinessObjectRestriction.borApplyGroups.count; i++){
            var borApplyGroup = new BorApplyGroup();
            borApplyGroup.applyGroupID = mBusinessObjectRestriction.borApplyGroups.item(i).applyGroupID;
            borApplyGroup.applyGroupName = mBusinessObjectRestriction.borApplyGroups.item(i).applyGroupName;
            tempArr.push(borApplyGroup);
        }
        return tempArr;
    }

    function setBorApplyUsers(){
        var tempArr = [];
        for(var i = 0; i < mBusinessObjectRestriction.borApplyGroups.count; i++){
            var borApplyUser = new BorApplyUser();
            borApplyUser.applyUserID = mBusinessObjectRestriction.borApplyGroups.item(i).applyUserID;
            borApplyUser.applyUserName = mBusinessObjectRestriction.borApplyGroups.item(i).applyUserName;
            tempArr.push(borApplyUser);
        }
        return tempArr;
    }

    function getCheckBusinessObjectID(){
        var businessObjectIDs = [];
        var selectData = tree.getChecked('authority');
        for(var i = 0; i < selectData.length; i++){
            if(selectData[i].children && selectData[i].children.length){
                getChildrenBusinessObjectID(selectData[i].children,businessObjectIDs);
            }else{
                if(selectData[i].businessObjectID){
                    businessObjectIDs.push({businessObjectID:selectData[i].businessObjectID,businessObjectName:selectData[i].title});
                }
            }
        }
        return businessObjectIDs;
    }

    function getChildrenBusinessObjectID(dataArr,businessObjectIDs){
        for(var i = 0; i < dataArr.length; i++){
            if(dataArr[i].children && dataArr[i].children.length){
                getChildrenBusinessObjectID(dataArr[i].children,businessObjectIDs);
            }else{
                if(dataArr[i].businessObjectID){
                    businessObjectIDs.push({businessObjectID:dataArr[i].businessObjectID,businessObjectName:dataArr[i].title});
                }
            }
        }
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
    
}();