!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer, form = layui.form;
    var groups = new Groups();
    var organizationUsers = new OrganizationUsers();
    var mBusinessObjectRestriction = null;
    var mTableBody = [];
    var mBackupsTableBody = [];
    var mBackupsGroupBusinessObjectRestrictions = [];
    var mBackupsUserBusinessObjectRestrictions = [];
    var formEditSubmit = null;
    var selectColumnData = null;

    window.initAuthorityListForm = function(index,businessObjectRestriction,editSubmit){
        mBusinessObjectRestriction = businessObjectRestriction;
        formEditSubmit = editSubmit;
        loadListTableHead();
        getRequisiteDataAndLoadList();

        buttonEvent(index);
    };

    function loadListTableHead(){
        var tableHead = [
            [
                {field: "name", title: "名称"},
                {field: "type", title: "类型",templet:"#listType"}
            ]
        ];

        table.render({
            elem: '#list',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getRequisiteDataAndLoadList(){
        var succ = function(){
            $Utils.loading.close();
			getGroupsAndLoadList();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取用户列表",errorStatus,msg);
		};
		organizationUsers.getItems(true,succ,fail);
    }

    function getGroupsAndLoadList(){
        var succ = function(){
            $Utils.loading.close();
			loadList();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组列表",errorStatus,msg);
		};
		groups.getItems(true,succ,fail);
    }

    function loadList(){
        var tableBody = [];
        for(var i = 0; i < mBusinessObjectRestriction.borApplyGroups.count; i++){
            var obj = {};
            obj.name = mBusinessObjectRestriction.borApplyGroups.item(i).applyGroupName;
            obj.type = 0;
            obj.dataID = mBusinessObjectRestriction.borApplyGroups.item(i).applyGroupID;
            tableBody.push(obj);
            mBackupsGroupBusinessObjectRestrictions.push(mBusinessObjectRestriction.borApplyGroups.item(i).applyGroupID);
        }
        for(var i = 0; i < mBusinessObjectRestriction.borApplyUsers.count; i++){
            var obj = {};
            obj.name = mBusinessObjectRestriction.borApplyUsers.item(i).applyUserName;
            obj.type = 1;
            obj.dataID = mBusinessObjectRestriction.borApplyUsers.item(i).applyUserID;
            tableBody.push(obj);
            mBackupsUserBusinessObjectRestrictions.push(mBusinessObjectRestriction.borApplyUsers.item(i).applyUserID);
        }
        $.extend(true,mBackupsTableBody,tableBody);
        mTableBody = tableBody;
        table.reload("list",{data:tableBody,limit:tableBody.length,skin: "nob"});
    }

    function buttonEvent(index){
        $(".add-group").click(function(){
            getAndLoadGroupListForm();
        });

        $(".add-user").click(function(){
            getAndLoadUsersListForm();
        });

        $(".delete").click(function(){
            // if(table.checkStatus('list').data.length){
            //     deleteDataItem();
            // }else{
            //     layer.msg("请至少选择一条记录。",{icon:2});
            // }
            if(selectColumnData){
                deleteDataItem([selectColumnData.data]);
            }else{
                layer.msg("请至少选择一条记录。",{icon:2});
            }
        });

        $(".column-button .layui-btn-determine").click(function(){
            if(changeUser() || changeGroup()){
                $Utils.loading.open();
                var businessObjectRestriction = new BusinessObjectRestriction();
                businessObjectRestriction.businessObjectRestrictionID = mBusinessObjectRestriction.businessObjectRestrictionID;
                businessObjectRestriction.businessModelID = mBusinessObjectRestriction.businessModelID;
                businessObjectRestriction.businessModelName = mBusinessObjectRestriction.businessModelName;
                businessObjectRestriction.businessModelType = mBusinessObjectRestriction.businessModelType;
                businessObjectRestriction.borBusinessObjects = setBusinessObjects();
                businessObjectRestriction.borApplyGroups = setBorApplyGroups();
                businessObjectRestriction.borApplyUsers = setBorApplyUsers();
                formEditSubmit(businessObjectRestriction,index);
            }else{
                layer.close(index);
            }
        });

        $(".column-button .layui-btn-cancel").click(function(){
            layer.close(index);
        });

        table.on('row(list)', function(obj){
            selectColumnData = obj;
            $(obj.tr).addClass("layui-table-click").siblings("tr").removeClass("layui-table-click");
        });
    }

    function getAndLoadGroupListForm(){
        $.ajax({
            url: "html/iControl/groupList.html",
            type: 'GET',
            success: function(data){
                loadGroupsListForm(data)
            }
        });
    }

    function loadGroupsListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加组","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 0){
                        transmitData.push(groups.item(mTableBody[i].dataID));
                    }
                }
                initGroupList(index,transmitData,groups,addGroupList);
            }
        });
    }

    function getAndLoadUsersListForm(){
        $.ajax({
            url: "html/iControl/userList.html",
            type: 'GET',
            success: function(data){
                loadUsersListForm(data)
            }
        });
    }

    function loadUsersListForm(strHtml){
        layer.open({
            type: 1,
            title: ["添加用户","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["730px","550px"],
            content: strHtml,
            success: function(layero,index){
                var transmitData = [];
                for(var i = 0; i < mTableBody.length; i++){
                    if(mTableBody[i].type == 1){
                        for(var j = 0; j < organizationUsers.count; j++){
                            if(mTableBody[i].dataID == organizationUsers.item(j).userID){
                                transmitData.push(organizationUsers.item(j));
                                break;
                            }
                        }
                        
                    }
                }
                initUserList(index,transmitData,organizationUsers,addUserList);
            }
        });
    }

    function deleteDataItem(selectData){
        for(var i = 0; i < selectData.length; i++){
            for(var j = mTableBody.length - 1; j >= 0; j--){
                if(selectData[i].dataID == mTableBody[j].dataID){
                    mTableBody.splice(j,1);
                    break;
                }
            }
        }
        var scrollTop = $(".content-list .layui-table-main").scrollTop();
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
        $(".content-list .layui-table-main").scrollTop(scrollTop-35);
    }

    function changeGroup(){
        var groupIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                groupIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsGroupBusinessObjectRestrictions.length == 0 && groupIDs.length == 0){
            return false;
        }
        

        if(mBackupsGroupBusinessObjectRestrictions.length != groupIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsGroupBusinessObjectRestrictions.length; i++){
            if(groupIDs.indexOf(mBackupsGroupBusinessObjectRestrictions[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function changeUser(){
        var userIDs = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                userIDs.push(mTableBody[i].dataID);
            }
        }
        if(mBackupsUserBusinessObjectRestrictions.length == 0 && userIDs.length == 0){
            return false;
        }
        

        if(mBackupsUserBusinessObjectRestrictions.length != userIDs.length){
            return true;
        }

        for(var i = 0; i < mBackupsUserBusinessObjectRestrictions.length; i++){
            if(userIDs.indexOf(mBackupsUserBusinessObjectRestrictions[i]) == -1){
                return true;
            }
        }
        
        return false;
    }

    function setBusinessObjects(){
        var tempArr = [];
        for(var i = 0; i < mBusinessObjectRestriction.borBusinessObjects.count; i++){
            var borBusinessObject = new BorBusinessObject();
            borBusinessObject.businessObjectID = mBusinessObjectRestriction.borBusinessObjects.item(i).businessObjectID;
            borBusinessObject.businessObjectName = mBusinessObjectRestriction.borBusinessObjects.item(i).businessObjectName;
            tempArr.push(borBusinessObject);
        }
        return tempArr;
    }

    function setBorApplyGroups(){
        var tempArr = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 0){
                var borApplyGroup = new BorApplyGroup();
                borApplyGroup.applyGroupID = mTableBody[i].dataID;
                borApplyGroup.applyGroupName = mTableBody[i].name;
                tempArr.push(borApplyGroup);
            }
        }
        return tempArr;
    }

    function setBorApplyUsers(){
        var tempArr = [];
        for(var i = 0; i < mTableBody.length; i++){
            if(mTableBody[i].type == 1){
                var borApplyUser = new BorApplyUser();
                borApplyUser.applyUserID = mTableBody[i].dataID;
                borApplyUser.applyUserName = mTableBody[i].name;
                tempArr.push(borApplyUser);
            }
        }
        return tempArr;
    }

    var addGroupList = function(groupList,index){
        layer.close(index);
        for(var i = 0; i < groupList.length; i++){
            var obj = {};
            obj.name = groupList[i].groupName;
            obj.type = 0;
            obj.dataID = groupList[i].groupID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };

    var addUserList = function(userList,index){
        layer.close(index);
        for(var i = 0; i < userList.length; i++){
            var obj = {};
            obj.name = userList[i].userName;
            obj.type = 1;
            obj.dataID = userList[i].userID;
            mTableBody.push(obj);
        }
        table.reload("list",{data:mTableBody,limit:mTableBody.length});
    };
    
}();