/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 13:53:44
 * @LastEditTime: 2020-09-10 17:17:50
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var businessModels = new BusinessModels();
    var userBusinessModels = new UserBusinessModels();
    var backupSelfDataSourceIDsArr = [];
    var backupInheritDataSourceIDsArr = [];

    window.initAuthorityForm = function(index,user){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(user);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(user,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "businessModelName",title: "业务模型名称"},
                {field: "businessModelType",title: "类型",templet: "#type"},
                {field: "description",title: "描述"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(user){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(user){
        var succ = function(data){
            $Utils.loading.close();
            getInheritAndLoadTableBody(data,user);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属模型权限",errorStatus,msg);
		};
		userBusinessModels.getSelfBusinessModels(user.userID,true,succ,fail);
    }

    function getInheritAndLoadTableBody(selfBusinessModelsData,user){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(selfBusinessModelsData,data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+user.userName+" 所属组模型权限",errorStatus,msg);
		};
		userBusinessModels.getInheritBusinessModels(user.userID,true,succ,fail);
    }

    function loadTableBody(selfBusinessModelsData,inHeritBusinessModelsData){
        var tableBody = [];
        for(var i = 0; i < businessModels.count; i++){
            var obj = {};
            for(var key in businessModels.item(i)){
                if(typeof businessModels.item(i)[key] === "function"){ continue;}
                obj[key] = businessModels.item(i)[key];
            }
            if(selfBusinessModelsData.indexOf(businessModels.item(i).businessModelID) != -1 || inHeritBusinessModelsData.indexOf(businessModels.item(i).businessModelID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = true;
            tableBody.push(obj);
        }
        backupSelfDataSourceIDsArr = selfBusinessModelsData;
        backupInheritDataSourceIDsArr = inHeritBusinessModelsData;
        table.reload("authority",{data:tableBody,limit:tableBody.length,done:function(res, curr, count){
            for (var i in res.data) {
                var item = res.data[i];
                if(backupInheritDataSourceIDsArr.indexOf(item.businessModelID) != -1) {
                    $('tr[data-index=' + i + '] input[type="checkbox"]').prop('disabled', true);
                }
            }
        }});
    }

    function bindEvent(user,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.userID = user.userID;
                tempObj.businessModelIDs = [];
                var selectData = table.checkStatus("authority").data;
                for(var i = selectData.length-1; i >= 0; i--){
                    if(backupInheritDataSourceIDsArr.indexOf(selectData[i].businessModelID) != -1){
                        selectData.splice(i,1);
                    }
                }
                for(var i = 0; i < selectData.length; i++){
                    tempObj.businessModelIDs.push(selectData[i].businessModelID);
                }
                submitAuthority(user,tempObj,index);
            }else{
                layer.close(index);
            }
        });

        table.on("checkbox(authority)",function(obj){
            if(backupInheritDataSourceIDsArr.indexOf(obj.data.businessModelID) != -1 && obj.data.userOrGroup){
                layer.msg("从组继承的权限不能修改。",{icon:3});
            }
        });
    }

    function change(){
        var selectData = table.checkStatus("authority").data;
        for(var i = selectData.length-1; i >= 0; i--){
            if(backupInheritDataSourceIDsArr.indexOf(selectData[i].businessModelID) != -1){
                selectData.splice(i,1);
            }
        }
        if(selectData.length != backupSelfDataSourceIDsArr.length){
            return true;
        }
        for(var i = 0; i < selectData.length; i++){
            if(backupSelfDataSourceIDsArr.indexOf(selectData[i].businessModelID) == -1){
                return true;
            }
        }
        return false;
    }

    function submitAuthority(user,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属模型权限",errorStatus,msg);
		};
		userBusinessModels.updateByUserID(authorities,true,succ,fail);
    }
    
}();