/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-14 11:35:38
 * @LastEditTime: 2020-09-10 17:18:00
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, table = layui.table, layer = layui.layer;
    var businessModels = new BusinessModels();
    var groupBusinessModels = new GroupBusinessModels();
    var backupbusinessModelIDsArr = [];

    window.initAuthorityForm = function(index,group){
        loadAuthorityTableHead();
        getAndLoadAuthorityTableBody(group);

        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        bindEvent(group,index);
    };

    function loadAuthorityTableHead(){
        var tableHead = [
            [
                {type: "checkbox"},
                {field: "businessModelName",title: "业务模型名称"},
                {field: "businessModelType",title: "类型",templet: "#type"},
                {field: "description",title: "描述"}
            ]
        ];
        table.render({
            elem: '#authority',
            height: 445,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadAuthorityTableBody(group){
        var succ = function(){
            $Utils.loading.close();
			getAndLoadTableBody(group);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务模型列表",errorStatus,msg);
		};
		businessModels.getItems(1,true,succ,fail);
    }

    function getAndLoadTableBody(group){
        var succ = function(data){
            $Utils.loading.close();
			loadTableBody(data);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+group.groupName+" 所属模型",errorStatus,msg);
		};
		groupBusinessModels.getItems(group.groupID,true,succ,fail);
    }

    function loadTableBody(data){
        var tableBody = [];
        for(var i = 0; i < businessModels.count; i++){
            var obj = {};
            for(var key in businessModels.item(i)){
                if(typeof businessModels.item(i)[key] === "function"){ continue;}
                obj[key] = businessModels.item(i)[key];
            }
            if(data.indexOf(businessModels.item(i).businessModelID) != -1){
                obj.LAY_CHECKED = true;
            }
            obj.userOrGroup = false;
            tableBody.push(obj);
        }
        backupbusinessModelIDsArr = data;
        table.reload("authority",{data:tableBody,limit:tableBody.length});
    }

    function bindEvent(group,index){
        $(".layui-btn-cancel").click(function(){
            layer.close(index);
        });

        $(".layui-btn-determine").click(function(){
            if(change()){
                $Utils.loading.open();
                var tempObj = {};
                tempObj.groupID = group.groupID;
                tempObj.businessModelIDs = [];
                for(var i = 0; i < table.checkStatus('authority').data.length; i++){
                    tempObj.businessModelIDs.push(table.checkStatus('authority').data[i].businessModelID);
                }
                submitAuthority(group,tempObj,index);
            }else{
                layer.close(index);
            }
        });
    }

    function change(){
        if(backupbusinessModelIDsArr.length == 0 && table.checkStatus('authority').data.length == 0){
            return false;
        }

        for(var i = 0; i < table.checkStatus('authority').data.length; i++){
            if(backupbusinessModelIDsArr.indexOf(table.checkStatus('authority').data[i].businessModelID) == -1){
                return true;
            }
        }

        if(backupbusinessModelIDsArr.length > table.checkStatus('authority').data.length){
            return true;
        }
        return false;
    }

    function submitAuthority(group,authorities,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改所属模型权限",errorStatus,msg);
		};
		groupBusinessModels.updateByGroupID(authorities,true,succ,fail);
    }
    
}();