!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var excelFiles = new ExcelFiles();
    var businessModels = new BusinessModels();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initExcelFilesTableHead();
        getAndLoadExcelFilesTableBody();
    }

    function initExcelFilesTableHead(){
        var excelFilesTableHead = [
            [
                {type: "radio"},
                {field: "dataSourceName", title: "名称", sort: true},
                {field: "createUserName",title: "上传者", sort: true, width: 200},
                {field: "createDate",title: "上传时间", width: 130, sort: true, templet: function(d){
                    if (d.createDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: excelFilesTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadExcelFilesTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
			// loadExcelFilesTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取Excel文件列表",errorStatus,msg);
		};
		excelFiles.getItems(2,true,succ,fail);
    }
    

    function setTableBody(){
        var excelFilesTableBody = [];
        for(var i = 0; i < excelFiles.count; i++){
            var tempObj = {};
            for(var key in excelFiles.item(i)){
                if(typeof excelFiles.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = excelFiles.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(excelFiles.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = excelFiles.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(excelFiles.item(i)[key])):"";
                // }else{
                    tempObj[key] = excelFiles.item(i)[key];
                // }
            }
            excelFilesTableBody.push(tempObj);
        }
        return excelFilesTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                
                mLimit = obj.limit;
                loadExcelFilesTableBody(data,obj);
            }
        });
    }

    function loadExcelFilesTableBody(tableBodyData,obj){
        var databaseLinksTableBody = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:databaseLinksTableBody,limit:databaseLinksTableBody.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".add-excel").click(function(){
        // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
        //     layer.open({
        //         type: 0,
        //         title: "上传Excel",
        //         closeBtn: 1,
        //         shadeClose: true,
        //         resize: false,
        //         area: ["480px","270px"],
        //         skin: "delete-window",
        //         content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>因IE浏览器不支持某些方法，上传Excel请使用Chrome、Firefox、360（急速模式）等浏览器。</div></div>",
        //         btn: ["确定"]
        //     });
        // }else{
            var databaseLink = new DatabaseLink();
            getAndLoadExcelUploadForm(0,databaseLink);
        // }
    });

    $(".delete-excel").click(function(){
        if(table.checkStatus('dataList').data.length){
            judgeIncludeModelCount();
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadExcelFilesTableBody();
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadExcelUploadForm(operationType,databaseLink){
        $.ajax({
            url: "html/iBusinessModel/dataSource/excel.html",
            type: 'GET',
            success: function(data){
                loadExcelUploadForm(data)
            }
        });
    }

    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                var str = "当前Excel文件已有模型引用，如果删除将导致引用此Excel文件的模型不可用，您确定要删除该Excel文件吗？";
                deleteWindow(str,"bda-tips"); 
            }else{
                var str = "是否删除 "+table.checkStatus('dataList').data[0].dataSourceName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除Excel文件",errorStatus,msg);
		};
		businessModels.getUsedCount(table.checkStatus('dataList').data[0].dataSourceID,true,succ,fail);
    }

    function loadExcelUploadForm(strHtml){
        layer.open({
            type: 1,
            title: ["Excel文件上传向导","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initUploadExcel(index,addSubmit,excelFiles);
            }
        });
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除Excel文件",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteExcelFile(table.checkStatus('dataList').data[0].dataSourceID);
            }
        });
    }

    function deleteExcelFile(dataSourceID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadExcelFilesTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除Excel文件",errorStatus,msg);
		};
		excelFiles.deleteItem(dataSourceID,true,succ,fail);
    }

    var addSubmit = function(excel,excelFile,index){
        $Utils.loading.open();
        var file = new FormData();
        file.append("file", excel[0]);
        var succ = function(data){
            addExcelSubmit(file,data,index);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增Excel文件对象",errorStatus,msg);
        };
		excelFiles.addItem(excelFile,true,succ,fail);
    };

    function addExcelSubmit(file,dataSourceID,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadExcelFilesTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("上传Excel文件",errorStatus,msg);
        };
		excelFiles.addExcel(file,dataSourceID,true,succ,fail);
    }

}()