/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-07 11:28:47
 * @LastEditTime: 2020-10-12 14:13:50
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form, excel = layui.excel;
    var selectFiles = {};
    var columns = [];
    var formAddSubmit = null;
    var layerIndex = null;
    var mExcelFiles = null;
    var mFilesExistence = false;

    window.initUploadExcel = function(index,addSubmit,excelFiles){
        $Utils.windowLoading.open();
        layerIndex = index;
        formAddSubmit = addSubmit;
        mExcelFiles = excelFiles;

        $(".cancel").click(function(){
            layer.close(layerIndex);
        });
        initSelectExcel();
    };

    function initSelectExcel(){
        $(".select-excel-file .next-step").click(function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                initSelectExcelSheels();
            }
            return false;
        });

        bindSelectFileEvent();
        $Utils.windowLoading.close();
    }

    function bindSelectFileEvent(){
        
        $("#LAY-excel-import-excel").change(function(e) {
            if(e.target.files[0].name.indexOf(".csv") != -1 || e.target.files[0].name.indexOf(".xlsx") != -1 || e.target.files[0].name.indexOf(".xls") != -1){
                // if (!!window.ActiveXObject || "ActiveXObject" in window || navigator.userAgent.indexOf("Edge") > -1){
                //     layer.msg("因IE浏览器不支持某些方法，上传Excel请使用Chrome等浏览器。",{icon:3});
                // }else{
                    if (!Object.values) {
                        Object.values = function values(obj) {
                            return Object.keys(obj).map(function(e){
                                return obj[e];
                            })
                        };
                    }
                    var files = Object.values(e.target.files);
                    selectFiles.files = files;
                    selectFiles.excelFileName = files[0].name;
                    e.target.value = '';
                    excelIsExist(files);
                // }
            }else{
                layer.msg("不是一个Excel文件。",{icon:2});
            }
        });

        $(".reset-select").click(function(){
            $("#LAY-excel-import-excel").click();
        });
    }

    function excelIsExist(files){
        $Utils.loading.open();
        var succ = function(status){
            $Utils.loading.close();
            if(status == 204){
                mFilesExistence = true;
                judgeAuthority(files);
            }else if(status == 404){
                excelContent(files);
            }
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("判断Excel是否存在",errorStatus,msg);
        };
        
		mExcelFiles.isExist(files[0].name,true,succ,fail);
    }

    function judgeAuthority(files){
        var isInclude = false;
        for(var i = 0; i < mExcelFiles.count; i++){
            if(files[0].name == mExcelFiles.item(i).excelFileName){
                isInclude = true;
                break;
            }
        }
        if(isInclude){
            excelContent(files)
        }else{
            layer.open({
                type: 0,
                title: "上传Excel文件",
                closeBtn: 1,
                shadeClose: true,
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>检测服务器已存在同名的Excel文件，您没有权限覆盖这个文件。</div></div>",
                btn: ["确定"],
                success: function(layero,index){
                    $(layero).find('.layui-layer-content').css('height','137px');
                }
            });
        }
    }

    function excelContent(files){
        uploadExcel(files);
        showSelectedBox(files[0].name);
        $(".select-excel-file .next-step").attr("disabled",false);
    }

    function uploadExcel(files) {
        try {
            excel.importExcel(files, {}, function(data) {
                selectFiles.data = data[0];
            });
        } catch (e) {
            $Utils.openWindow.failWindow("读取Excel文件",e.message);
        }
    };

    function showSelectedBox(name){
        $(".init-select").addClass("uploaded");
        $(".selected-box").show();
        form.val("addExcelFile",{
            "excelName": name
        });
        form.render();
    }

    function initSelectExcelSheels(){
        $(".select-excel-file").hide();
        $(".sheel-list").show();
        $(".sheel-list .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                selectFiles.sheelName = $("#sheelName").val();
                initSheelRang();
            }
            return false;
        });
        $(".sheel-list .last-step").off("click").on("click",function(){
            $(".sheel-list").hide();
            $(".select-excel-file").show();
            return false;
        });

        initSheelSelectForm();

        form.render();

        $Utils.windowLoading.close();
    }

    function initSheelSelectForm(){
        var tempArr = [];
        for(var key in selectFiles.data){
            tempArr.push(key);
        }

        var sheelName = document.getElementById("sheelName");
        for(var i = 0; i < tempArr.length; i++){
            var option = document.createElement("option");
            option.setAttribute("value",tempArr[i]);
            if(i == 0){
                option.setAttribute("selected",true);
            }
            option.innerText = tempArr[i];
            sheelName.appendChild(option);
        }
    }

    function initSheelRang(){
        $(".sheel-list").hide();
        $(".sheel-range").show();
        $(".sheel-range .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                if(validateData()){
                    selectFiles.rangeType = $('input[name="rangeType"]:checked').val();
                    if(selectFiles.rangeType == 1){
                        selectFiles.range = $.trim($(".range").val());
                    }else{
                        var rowColumnLength = [];
                        for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                            var columnIndex = 0;
                            for(var key in selectFiles.data[selectFiles.sheelName][i]){
                                columnIndex ++;
                            }
                            rowColumnLength.push(columnIndex);
                        }
                        var maxColumn = Math.max.apply(null, rowColumnLength);
                        var maxRow = selectFiles.data[selectFiles.sheelName][selectFiles.data[selectFiles.sheelName].length - 1]["__rowNum__"];
                        selectFiles.range = "A2:"+createCellPos(maxColumn-1) + (maxRow+1)
                    }
                    $Utils.windowLoading.open();
                    initSheelColumn();
                }
            }
            return false;
        });
        $(".sheel-range .last-step").off("click").on("click",function(){
            $(".sheel-list").show();
            $(".sheel-range").hide();
            return false;
        });

        form.render();

        bindRadioEvent();

        $Utils.windowLoading.close();
    }

    function validateData(){
        if($('input[name="rangeType"]:checked').val() == 0){
            if(selectFiles.data[selectFiles.sheelName].length > 1){
                return true;
            }else{
                layer.msg("工作表"+selectFiles.sheelName+"的可用数据行数小于2，无法确定范围。",{icon:2});
                return false;
            }
        }
        return true;
    }

    function bindRadioEvent(){
        form.on("radio(rangeType)", function (data) {
            if(this.value == '0'){
                $("input[name=range]").attr("disabled",true);
                $(".sheel-range .next-step").attr("disabled",false);
            }else if(this.value == '1'){
                $("input[name=range]").attr("disabled",false);
                if(!$("input[name=range]").val().length){
                    $(".sheel-range .next-step").attr("disabled",true);
                }
            }
        });

        $(".sheel-range .range").bind("input propertychange",function(){
            if($(this).val().length){
                $(".sheel-range .next-step").attr("disabled",false);
            }else{
                $(".sheel-range .next-step").attr("disabled",true);
            }
        });
    }

    function initSheelColumn(){
        $(".sheel-range").hide();
        $(".sheel-columns").show();
        $(".sheel-columns .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                selectFiles.columns = saveColumn();
                initDataList();
            }
            return false;
        });
        $(".sheel-columns .last-step").off("click").on("click",function(){
            $(".sheel-range").show();
            $(".sheel-columns").hide();
            return false;
        });

        initSheelColumnTableHead();
        initSheelColumnTableBody();

        bindButtonEvent();

        $Utils.windowLoading.close();
    }

    function initSheelColumnTableHead(){
        var tableHead = [
            [
                {type: "radio"},
                {field: "columnName", title: "列名"},
                {field: "valueRange", title: "取值单元格"}
            ]
        ];

        table.render({
            elem: '#columnDetailsList',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            limit: 10
        });
    }

    function initSheelColumnTableBody(){
        var tableBody = [];
        if(selectFiles.rangeType == 0){
            var rowColumnLength = [];
            for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                var columnIndex = 0;
                for(var key in selectFiles.data[selectFiles.sheelName][i]){
                    columnIndex ++;
                }
                rowColumnLength.push(columnIndex);
            }
            var maxColumn = Math.max.apply(null, rowColumnLength);
            var maxRow = selectFiles.data[selectFiles.sheelName][selectFiles.data[selectFiles.sheelName].length - 1]["__rowNum__"];
            var headIndex = null;
            for(var i = 0; i < selectFiles.data[selectFiles.sheelName].length; i++){
                if(selectFiles.data[selectFiles.sheelName][i]["__rowNum__"] == 0){
                    headIndex = i;
                    break;
                }
            }
            if(headIndex != null){
                for(var i = 0; i < maxColumn; i++){
                    var obj = {};
                    obj.key = createCellPos(i);
                    obj.columnName = selectFiles.data[selectFiles.sheelName][headIndex][createCellPos(i)]?selectFiles.data[selectFiles.sheelName][headIndex][createCellPos(i)]:("column_" + createCellPos(i));
                    obj.valueRange = createCellPos(i)+(headIndex+2)+":"+createCellPos(i)+(maxRow+1);
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
            }else{
                for(var i = 0; i < maxColumn; i++){
                    var obj = {};
                    obj.key = createCellPos(i);
                    obj.columnName = "column_" + createCellPos(i);
                    obj.valueRange = createCellPos(i)+2+":"+createCellPos(i)+(maxRow+1);
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
            }
        }
        if(selectFiles.rangeType == 1){
            var tempArr = selectFiles.range.split(":");
            var startObj = {};
            startObj.key = tempArr[0].split(tempArr[0].replace(/[^0-9]/ig,""))[0];
            startObj.rowNum = tempArr[0].replace(/[^0-9]/ig,"");
            var endObj = {};
            endObj.key = tempArr[1].split(tempArr[1].replace(/[^0-9]/ig,""))[0];
            endObj.rowNum = tempArr[1].replace(/[^0-9]/ig,"");
            var isStart = false;
            for(var key in selectFiles.data[selectFiles.sheelName][(Number(startObj.rowNum)-1)]){
                if(key == startObj.key){
                    isStart = true;
                }
                if(isStart){
                    var obj = {};
                    obj.key = key;
                    obj.columnName = selectFiles.data[selectFiles.sheelName][(Number(startObj.rowNum)-1)][key];
                    obj.valueRange = key+""+(Number(startObj.rowNum)+1)+":"+key+endObj.rowNum;
                    obj.custom = false;
                    obj.dataType = 0;
                    tableBody.push(obj);
                }
                if(key == endObj.key){
                    isStart = false;
                }
            }
        }
        columns = tableBody;
        table.reload("columnDetailsList",{data:tableBody,limit:tableBody.length});
    }

    function createCellPos(n){
        var ordA = 'A'.charCodeAt(0);
        var ordZ = 'Z'.charCodeAt(0);
        var len = ordZ - ordA + 1;
        var s = "";
        while( n >= 0 ) {
            s = String.fromCharCode(n % len + ordA) + s;
            n = Math.floor(n / len) - 1;
        }
     
        return s;
    }

    function bindButtonEvent(){
        var rowObj = {};
        rowObj.rowIndex = null;
        table.on("radio(columnDetailsList)",function(data){
            rowObj.rowIndex = $(this).parents("tr").index();
        });
        $(".add-column").off("click").on("click",function(){
            var column = {};
            getAndLoadColumnForm(0,column,null);
        });
        $(".edit-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                var column = table.checkStatus('columnDetailsList').data[0];
                getAndLoadColumnForm(1,column,rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".up-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                upRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".down-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                downRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
        $(".delete-column").off("click").on("click",function(){
            if(table.checkStatus('columnDetailsList').data.length){
                deleteRow(rowObj);
            }else{
                layer.msg("请选择一条记录。",{icon:2});
            }
        });
    }

    function getAndLoadColumnForm(operationType,column,selectRow){
        $.ajax({
            url: "html/iBusinessModel/dataSource/column.html",
            type: 'GET',
            success: function(data){
                loadColumnForm(operationType,column,data,selectRow)
            }
        });
    }

    function loadColumnForm(operationType,column,strHtml,selectRow){
        layer.open({
            type: 1,
            title: ["列","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["400px","300px"],
            content: strHtml,
            success: function(layero,index){
                initColumnForm(operationType,column,index,selectRow,addSubmit,editSubmit);
            }
        });
    }

    function upRow(rowObj){
        if(rowObj.rowIndex != 0){
            var tempArr = $.extend(true,[],columns);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            columns[rowObj.rowIndex] = columns.splice(rowObj.rowIndex-1, 1, columns[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex-1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex != 0){ rowObj.rowIndex--;}
        }
    }

    function downRow(rowObj){
        if(rowObj.rowIndex != columns.length - 1){
            var tempArr = $.extend(true,[],columns);
            for(var i = 0; i < tempArr.length; i++){
                if(i == rowObj.rowIndex){
                    tempArr[i].LAY_CHECKED = true;
                    break;
                }
            }
            columns[rowObj.rowIndex] = columns.splice(rowObj.rowIndex+1, 1, columns[rowObj.rowIndex])[0];
            tempArr[rowObj.rowIndex] = tempArr.splice(rowObj.rowIndex+1, 1, tempArr[rowObj.rowIndex])[0];
            table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
            if(rowObj.rowIndex < columns.length - 1){ rowObj.rowIndex++;}
        }
    }

    function deleteRow(rowObj){
        for(var i = 0; i < columns.length; i++){
            if(i == rowObj.rowIndex){
                columns.splice(i,1);
                break;
            }
        }

        table.reload("columnDetailsList",{data: columns, limit: columns.length});
    }

    var addSubmit = function(column,layerIndex){
        columns.push(column);
        layer.close(layerIndex);
        table.reload("columnDetailsList",{data: columns, limit: columns.length});
    };

    var editSubmit = function(column,layerIndex,selectRow){
        var tempArr = $.extend(true,[],columns);
        for(var i = 0; i < tempArr.length; i++){
            if(i == selectRow.rowIndex){
                tempArr[i].columnName = column.columnName;
                tempArr[i].valueRange = column.valueRange;
                columns[i].columnName = column.columnName;
                columns[i].valueRange = column.valueRange;
                tempArr[i].LAY_CHECKED = true;
            }
        }
        layer.close(layerIndex);
        table.reload("columnDetailsList",{data: tempArr, limit: tempArr.length});
    };

    function saveColumn(){
        var tempArr = [];
        for(var i = 0; i < columns.length; i++){
            var column = new BDAColumn();
            column.columnName = columns[i].columnName;
            column.valueRange = columns[i].valueRange;
            column.custom = columns[i].custom;
            tempArr.push(column);
        }
        return tempArr;
    }

    function initDataList(){
        $(".sheel-columns").hide();
        $(".column-data-list").show();
        $(".column-data-list .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                if(mFilesExistence){
                    layer.open({
                        type: 0,
                        title: "上传Excel文件",
                        closeBtn: 1,
                        shadeClose: true,
                        resize: false,
                        area: ["480px","270px"],
                        skin: "delete-window",
                        content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-tips'></i></div><div class='fr fail-content'>Excel文件 "+selectFiles.excelFileName+" 已存在，是否覆盖？</div></div>",
                        btn: ["确定","取消"],
                        success: function(layero,index){
                            $(layero).find('.layui-layer-content').css('height','137px');
                        },
                        yes: function(index,layero){
                            layer.close(index);
                            addFormSubmit();
                        }
                    });
                }else{
                    addFormSubmit();
                }
                
            }
            return false;
        });
        $(".column-data-list .last-step").off("click").on("click",function(){
            $(".sheel-columns").show();
            $(".column-data-list").hide();
            return false;
        });

        initColumnDataTableHead();
        initColumnDataTableBody();

        $Utils.windowLoading.close();
    }

    function addFormSubmit(){
        var excelFile = new ExcelFile();
        excelFile.excelFileName = selectFiles.excelFileName;
        excelFile.sheetName = selectFiles.sheelName;
        excelFile.rangeType = selectFiles.rangeType;
        excelFile.range = selectFiles.range;
        excelFile.columns = selectFiles.columns;
        excelFile.dataSourceName = selectFiles.excelFileName;
        excelFile.dataSourceType = 1;
        formAddSubmit(selectFiles.files,excelFile,layerIndex);
    }

    function initColumnDataTableHead(){
        var tableHead = [];
        for(var i = 0; i < columns.length; i++){
            var obj = {};
            obj.field = columns[i].key;
            obj.title = columns[i].columnName;
            obj.align = "center";
            tableHead.push(obj);
        }

        table.render({
            elem: '#columnDataList',
            height: 380,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: [tableHead],
            toolbar: false,
            limit: 10
        });
    }

    function initColumnDataTableBody(){
        var tableBody = [];
        if(selectFiles.rangeType == 1){
            var tempBodyArr = [];
            for(var i = 0; i < columns.length; i++){
                var tempArr = [];
                for(var j = 0; j < (selectFiles.data[selectFiles.sheelName].length>200?200:selectFiles.data[selectFiles.sheelName].length); j++){
                    if(columns[i].valueRange.indexOf(":") != -1){
                        var columnRange = columns[i].valueRange.split(":")
                        var rowEndNum = Number(columnRange[1].replace(/[^0-9]/ig,""))-1;
                        var rowStartNum = Number(columnRange[0].replace(/[^0-9]/ig,""))-1;
                        if(selectFiles.data[selectFiles.sheelName][j]["__rowNum__"] >= rowStartNum && selectFiles.data[selectFiles.sheelName][j]["__rowNum__"] <= rowEndNum){
                            tempArr.push(selectFiles.data[selectFiles.sheelName][j][columns[i].key] || "")
                        }
                    }else if(columns[i].valueRange.indexOf(":") == -1){
                        var key = columns[i].valueRange.split(columns[i].valueRange.replace(/[^0-9]/ig,""))[0];
                        var rowIndex = columns[i].valueRange.split(key)[1]-1;
                        for(var k = 0; k < selectFiles.data[selectFiles.sheelName].length; k++){
                            if(selectFiles.data[selectFiles.sheelName][k]["__rowNum__"] == rowIndex){
                                tempArr.push(selectFiles.data[selectFiles.sheelName][k][key] || "");
                                break;
                            }
                        }
                    }
                }
                tempBodyArr.push(tempArr);
            }
            if(tempBodyArr.length){
                for(var i = 0; i < (tempBodyArr[0].length>200?200:tempBodyArr[0].length); i++){
                    var tempObj = {};
                    for(var j = 0; j < columns.length; j++){
                        tempObj[columns[j].key+""] = tempBodyArr[j][i];
                    }
                    tableBody.push(tempObj);
                }
            }
            
        }else{
            for(var i = 1; i < (selectFiles.data[selectFiles.sheelName].length>200?200:selectFiles.data[selectFiles.sheelName].length); i++){
                tableBody.push(selectFiles.data[selectFiles.sheelName][i]);
            }
        }
        table.reload("columnDataList",{data:tableBody,limit:tableBody.length});
    }

}();