!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var databaseLinks = new DatabaseLinks();
    var businessModels = new BusinessModels();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        initDatabaseLinksTableHead();
        getAndLoadDatabaseLinksTableBody();
    }

    function initDatabaseLinksTableHead(){
        var databaseLinkTableHead = [
            [
                {type: "radio"},
                {field: "dataSourceName", title: "名称", sort: true},
                {field: "databaseTypeName", title: "数据库类型", width: 90, sort: true},
                // {field: "createUserName",title: "创建者", sort: true},
                // {field: "createDate",title: "创建时间", sort: true, templet: function(d){
                //     if (d.createDate) {
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                //     } else {
                //         return "";
                //     }
                // }},
                // {field: "lastModifyUserName",title: "最后修改者", sort: true},
                {field: "lastModifyDate",title: "修改时间", width: 130, sort: true, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];
    
        table.render({
            elem: '#dataList',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: databaseLinkTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadDatabaseLinksTableBody(){
        var succ = function(){
            $Utils.loading.close();
            mTableBodyData = setTableBody();
            mSortBodyData = mTableBodyData;
            setTablePage(mTableBodyData);
            // loadDatabaseLinksTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库连接列表",errorStatus,msg);
		};
		databaseLinks.getItems(2,true,succ,fail);
    }

    function setTableBody(){
        var databaseLinksTableBody = [];
        for(var i = 0; i < databaseLinks.count; i++){
            var tempObj = {};
            for(var key in databaseLinks.item(i)){
                if(typeof databaseLinks.item(i)[key] === "function"){ continue;}
                // if(key == "createDate"){
                //     tempObj[key] = databaseLinks.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLinks.item(i)[key])):"";
                // }else if(key == "lastModifyDate"){
                //     tempObj[key] = databaseLinks.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLinks.item(i)[key])):"";
                // }else{
                    tempObj[key] = databaseLinks.item(i)[key];
                // }
            }
            databaseLinksTableBody.push(tempObj);
        }
        return databaseLinksTableBody;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                mLimit = obj.limit;
                loadDatabaseLinksTableBody(data,obj);
            }
        });
    }

    function loadDatabaseLinksTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("dataList",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("dataList",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("dataList",{height: tableBodyHeight});
        });
    }

    table.on('sort(dataList)', function (obj) {
        var type = obj.type,
            field = obj.field,
            data = mSortBodyData,//表格的配置Data
            thisData = [];
        if(type === 'asc'){ //升序
            thisData = $Utils.sorter(data, field);
        }else if(type === 'desc'){ //降序
            thisData = $Utils.sorter(data, field, true);
        }else{ //清除排序
            thisData = data;
        }
        setTablePage(thisData);
    });

    $(".search-button").click(function(){
        var searchValue = $(".search input[name=searchContent]").val();
        var searchData = [];
        if(searchValue == ""){
            searchData = mTableBodyData;
        }else{
            searchData = setSearchData(searchValue);
        }
        mSortBodyData = searchData;
        setTablePage(searchData);
    });

    $(".search input[name=searchContent]").keypress(function (e) {
        if (e.which == 13) {
            $(".search-button").click();
        }
    });

    $(".add-database").click(function(){
        var databaseLink = new DatabaseLink();
        getAndLoadDatabaseLinkForm(0,databaseLink);
    });

    $(".edit-database").click(function(){
        if(table.checkStatus('dataList').data.length){
            var databaseLink = databaseLinks.item(table.checkStatus('dataList').data[0].dataSourceID);
            getAndLoadDatabaseLinkForm(1,databaseLink);
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".delete-database").click(function(){
        if(table.checkStatus('dataList').data.length){
            judgeIncludeModelCount();
        }else{
            layer.msg("请选择一条记录。",{icon:2});
        }
    });

    $(".refresh").click(function(){
        $Utils.loading.open();
        getAndLoadDatabaseLinksTableBody();
    });

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].databaseTypeName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].databaseTypeVersion.toLowerCase().indexOf(searchValue.toLowerCase()) != -1){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadDatabaseLinkForm(operationType,databaseLink){
        $.ajax({
            url: "html/iBusinessModel/dataSource/databaseLink.html",
            type: 'GET',
            success: function(data){
                loadDatabaseLinkForm(operationType,databaseLink,data)
            }
        });
    }

    function loadDatabaseLinkForm(operationType,databaseLink,strHtml){
        layer.open({
            type: 1,
            title: [operationType?databaseLink.dataSourceName+" 属性":"新增数据库连接","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initDatabaseLinkForm(operationType,databaseLink,index,addSubmit,editSubmit);
            }
        });
    }

    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                var str = "当前数据库连接已有模型引用，如果删除将导致引用此数据库连接的模型不可用，您确定要删除该数据库连接吗？";
                deleteWindow(str,"bda-tips"); 
            }else{
                var str = "是否删除 "+table.checkStatus('dataList').data[0].dataSourceName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除数据库连接",errorStatus,msg);
		};
		businessModels.getUsedCount(table.checkStatus('dataList').data[0].dataSourceID,true,succ,fail);
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除数据库连接",
            closeBtn: 1,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteDatabaseLink(table.checkStatus('dataList').data[0].dataSourceID);
            }
        });
    }

    function deleteDatabaseLink(dataSourceID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
			getAndLoadDatabaseLinksTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("删除数据库连接",errorStatus,msg);
		};
		databaseLinks.deleteItem(dataSourceID,true,succ,fail);
    }

    var addSubmit = function(databaseLink,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadDatabaseLinksTableBody();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("新增数据库连接",errorStatus,msg);
        };
        
		databaseLinks.addItem(databaseLink,true,succ,fail);
    };

    var editSubmit = function(databaseLink,index){
        var succ = function(){
            layer.close(index);
            getAndLoadEditList(databaseLink);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("修改数据库连接",errorStatus,msg);
        };

		databaseLinks.editItem(databaseLink,true,succ,fail);
    };

    function getAndLoadEditList(databaseLink){
        var succ = function(){
            $Utils.loading.close();
            editListItem(databaseLink);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+databaseLink.dataSourceName+" 的属性",errorStatus,msg);
        };
        databaseLink.initByID(databaseLink.dataSourceID,true,succ,fail);
    }

    function editListItem(databaseLink){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        for(var i = 0; i < currentTableBodyData.length; i++){
            if(currentTableBodyData[i].dataSourceID == databaseLink.dataSourceID){
                for(var key in currentTableBodyData[i]){
                    if(key == "createDate"){
                        currentTableBodyData[i][key] = databaseLink[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLink[key])):"";
                        tempTableBody[i][key] = databaseLink[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLink[key])):"";

                    }else if(key == "lastModifyDate"){
                        currentTableBodyData[i][key] = databaseLink[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLink[key])):"";
                        tempTableBody[i][key] = databaseLink[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm:ss",new Date(databaseLink[key])):"";
                    }else{
                        currentTableBodyData[i][key] = databaseLink[key];
                        tempTableBody[i][key] = databaseLink[key];
                    }
                }
                tempTableBody[i].LAY_CHECKED = true;
            }else{
                tempTableBody[i].LAY_CHECKED = false;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("dataList",{data:tempTableBody,limit:tempTableBody.length});
    }

}();