!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    var mOperationType = null;
    var databaseTypes = new DatabaseTypes();
    var mDatabaseLink = null, layerIndex = null;
    var formAddSubmit = null;
    var formEditSubmit = null;
    var isFirst = true;

    window.initDatabaseLinkForm = function(operationType,databaseLink,index,addSubmit,editSubmit){
        mDatabaseLink = databaseLink;
        layerIndex = index;
        formAddSubmit = addSubmit;
        formEditSubmit = editSubmit;
        mOperationType = operationType;

        var createUserName = mOperationType == 0 ? $AppVars.gUser.userName : (mDatabaseLink.createUserName || "");
        var createDate = mOperationType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mDatabaseLink.createDate));
        var lastModifyUserName = mOperationType == 0 ? "" : (mDatabaseLink.lastModifyUserName || "");
        var lastModifyDate = mOperationType == 0 ? "" : (mDatabaseLink.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mDatabaseLink.lastModifyDate)) : "");
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);

        getDataBaseTypes();
        if(mOperationType == 0){
            initAddDatabaseLinkForm();
        }else if(mOperationType == 1){
            initEditDatabaseLinkForm(databaseLink);
        }
        form.render();
        $(".database-window input[name=dataSourceName]").focus();

        bindElementEvent();
    }

    function getDataBaseTypes(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
			$Utils.openWindow.failWindow("获取数据库类型列表",errorStatus,msg);
		};
		databaseTypes.getItems(false,succ,fail);
    }

    function initAddDatabaseLinkForm(){
        var databaseTypeName = document.getElementById("databaseTypeName");
        for(var i = 0; i < databaseTypes.count; i++){
            var databaseType = databaseTypes.item(i)
            var option = document.createElement("option");
            option.setAttribute("value",databaseType.databaseTypeName);
            if(i == 0){
                option.setAttribute("selected",true);
                if(databaseType.databaseTypeName == "Access"){
                    $(".acc-type").css("opacity",0);
                }
            }
            option.innerText = databaseType.databaseTypeName;
            databaseTypeName.appendChild(option);
        }

        bindLinkageEven();
    }

    function bindLinkageEven(){
        form.on("select(databaseTypeName)",function(data){
            var formData = form.val("formWindow");
            if (formData.serviceType == 0) {
                if (data.value == "Access") {
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
                    $(".acc-type").css("opacity", 0);
                } else {
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password],input[name=databaseName]").attr("lay-verify", "required");
                    $(".acc-type").css("opacity", 1);
                }
                if (data.value == "SAP HANA") {
                    $("input[name=databaseName]").removeAttr("lay-verify");
                    $(".database-name .layui-form-label span").css("opacity", 0);
                } else {
                    $("input[name=databaseName]").attr("lay-verify", "required");
                    $(".database-name .layui-form-label span").css("opacity", 1);
                }

                form.render();
            }
        });
    }

    function initEditDatabaseLinkForm(databaseLink){
        form.val("formWindow",{
            "dataSourceName": databaseLink.dataSourceName,
            "serviceType": databaseLink.serviceType,
        });
        var databaseTypeName = document.getElementById("databaseTypeName");
        for(var i = 0; i < databaseTypes.count; i++){
            var databaseType = databaseTypes.item(i);
            var option = document.createElement("option");
            option.setAttribute("value",databaseType.databaseTypeName);
            if(databaseType.databaseTypeName == databaseLink.databaseTypeName){
                option.setAttribute("selected",true);
                if(databaseType.databaseTypeName == "Access"){
                    $(".acc-type").css("opacity",0);
                }
            }
            option.innerText = databaseType.databaseTypeName;
            databaseTypeName.appendChild(option);
        }

        bindLinkageEven();

        if(databaseLink.serviceType == 0){
            $(".server-data-center").hide();
            $(".server-database").show();
            form.val("formWindow",{
                "databaseIP": databaseLink.databaseIP,
                "databasePort": databaseLink.databasePort,
                "userName": databaseLink.userName,
                "password": databaseLink.password,
                "databaseName": databaseLink.databaseName
            });
            $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=databaseName]").attr("lay-verify","required");
            $("input[name=getTablesInterface],input[name=getFieldsInterface],input[name=executeSqlInterface]").removeAttr("lay-verify");
        }else{
            $(".server-database").hide();
            $(".server-data-center").show();
            form.val("formWindow",{
                "getTablesInterface": databaseLink.getTablesInterface,
                "getFieldsInterface": databaseLink.getFieldsInterface,
                "executeSqlInterface": databaseLink.executeSqlInterface
            });
            $("input[name=getTablesInterface],input[name=getFieldsInterface],input[name=executeSqlInterface]").attr("lay-verify","required");
            $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=databaseName]").removeAttr("lay-verify");
        }
        if(databaseLink.databaseTypeName == "Access"){
            $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
        }
        form.render();
    }

    function bindElementEvent(){
        $(".database-window").on("click",".test-link",function(){
            $Utils.loading.open();
            var data = form.val("formWindow");
            if(validateLinkParameters(data)){
                formTestConnections(data);
            }
        });

        $(".database-name .layui-edge").click(function(){
            var data = form.val("formWindow");
            if (data.databaseTypeName == "MySql" || data.databaseTypeName == "SQLServer" || data.databaseTypeName == "PostgreSQL" || data.databaseTypeName == "SAP HANA"){
                if(isFirst && !$(".database-name-input").hasClass("database-name-selected")){
                    if(validateDatabaseParameters()){
                        $Utils.loading.open();
                        getAndLoadDatabase();
                    }
                }else{
                    if($(".database-name-input").hasClass("database-name-selected")){
                        $(".database-name-input").removeClass("database-name-selected");
                    }else{
                        $(".database-name-input").addClass("database-name-selected");
                    }
                }
            }
        });

        $(document).click(function(e){
            var target = $(e.target);
            if(target.closest(".database-name-input").length != 0 && $(".database-name-input").hasClass("database-name-selected")) return;
            $(".database-name-input").removeClass("database-name-selected");
        })

        $(".database-name input").focus(function(){
            $(".database-name-input").removeClass("database-name-selected");
        });

        $(".database-name .database-name-list").on("click","dd",function(){
            $(this).addClass("layui-this").siblings("dd").removeClass("layui-this");
            $(".database-name-input").removeClass("database-name-selected");
            form.val("formWindow",{
                databaseName: $(this).text()
            });
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
        
        form.on("radio(serviceType)", function (data) {
            var formData = form.val("formWindow");
            if(this.value == '0'){
                $(".server-data-center").hide();
                $(".server-database").show();
                if(formData.databaseTypeName == "Access"){
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password]").removeAttr("lay-verify");
                }else{
                    $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password],input[name=databaseName]").attr("lay-verify","required");
                }
                $("input[name=getTablesInterface],input[name=getFieldsInterface],input[name=executeSqlInterface]").removeAttr("lay-verify");
                
            }else if(this.value == '1'){
                $(".server-database").hide();
                $(".server-data-center").show();
                $("input[name=getTablesInterface],input[name=getFieldsInterface],input[name=executeSqlInterface]").attr("lay-verify","required");
                $("input[name=databaseIP],input[name=databasePort],input[name=userName],input[name=password],input[name=databaseName]").removeAttr("lay-verify");
            }
        });

        form.on('submit(formSubmit)', function(data){
            $Utils.loading.open();
            if(mOperationType == 1){
                if(changed(data)){
                    var databaseLink = new DatabaseLink();
                    databaseLink.init(JSON.parse(JSON.stringify(mDatabaseLink)));
                    setDatabaseLink(data,databaseLink);
                    formEditSubmit(databaseLink,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                setDatabaseLink(data, mDatabaseLink);
                formAddSubmit(mDatabaseLink,layerIndex);
            }
            return false;
        });
    }

    function formTestConnections(data){
        var databaseLink = new DatabaseLink();
        var parameters = "";
        if(data.databaseTypeName != "Access"){
            parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
            "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password)+"&databaseName="+encodeURIComponent(data.databaseName);
        }else{
            parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseName="+encodeURIComponent(data.databaseName);
        }
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        databaseLink.testConnections(parameters,true,succ,fail);
    }

    function getAndLoadDatabase(){
        var data = form.val("formWindow");
        var databaseLink = new DatabaseLink();
        var parameters = "databaseTypeName="+encodeURIComponent(data.databaseTypeName)+"&databaseIP="+encodeURIComponent(data.databaseIP)+"&databasePort="+encodeURIComponent(data.databasePort)+
        "&userName="+encodeURIComponent(data.userName)+"&password="+encodeURIComponent(data.password);
        var succ = function(data){
            $Utils.loading.close();
            isFirst = false;
            showDatabases(data);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库列表",errorStatus,msg);
        };
        databaseLink.getDatabaseNames(parameters,true,succ,fail);
    }

    function showDatabases(data){
        var databaseName = document.getElementById("databaseName");
        for(var i = 0; i < data.length; i++){
            var dd = document.createElement("dd");
            dd.setAttribute("data-value",data[i]);
            if(mOperationType == 1){
                if(data[i] == mDatabaseLink.databaseName){
                    dd.className = "layui-this";
                }
            }
            dd.innerText = data[i];
            databaseName.appendChild(dd);
        }
        $(".database-name-input").addClass("database-name-selected");
    }

    function setDatabaseLink(data, databaseLink){
        databaseLink.dataSourceType = 0;
        databaseLink.dataSourceName = data.field.dataSourceName;
        databaseLink.databaseTypeName = data.field.databaseTypeName;
        databaseLink.serviceType = Number(data.field.serviceType);
        if(data.field.serviceType == 0){
            databaseLink.databaseIP = data.field.databaseIP;
            databaseLink.databasePort = data.field.databasePort;
            databaseLink.userName = data.field.userName;
            databaseLink.password = data.field.password;
            databaseLink.databaseName = data.field.databaseName;
        }
        if(data.field.serviceType == 1){
            databaseLink.getTablesInterface = data.field.getTablesInterface;
            databaseLink.getFieldsInterface = data.field.getFieldsInterface;
            databaseLink.executeSqlInterface = data.field.executeSqlInterface;
            databaseLink.databaseIP = "";
            databaseLink.databasePort = "";
            databaseLink.userName = "";
            databaseLink.password = "";
        }
    }

    function validateDatabaseParameters(){
        var data = form.val("formWindow");
        if(data.databaseIP == ""){
            $Utils.loading.close();
            layer.msg("请输入主机名！",{icon:2});
            return false;
        }
        if(data.databasePort == ""){
            $Utils.loading.close();
            layer.msg("请输入端口！",{icon:2});
            return false;
        }
        if(data.userName == ""){
            $Utils.loading.close();
            layer.msg("请输入用户名！",{icon:2});
            return false;
        }
        if(data.password == ""){
            $Utils.loading.close();
            layer.msg("请输入密码！",{icon:2});
            return false;
        }
        return true;
    }

    function validateLinkParameters(data){
        if(data.databaseTypeName != "Access"){
            if(data.databaseIP == ""){
                $Utils.loading.close();
                layer.msg("请输入主机名！",{icon:2});
                return false;
            }
            if(data.databasePort == ""){
                $Utils.loading.close();
                layer.msg("请输入端口！",{icon:2});
                return false;
            }
            if(data.userName == ""){
                $Utils.loading.close();
                layer.msg("请输入用户名！",{icon:2});
                return false;
            }
            if(data.password == ""){
                $Utils.loading.close();
                layer.msg("请输入密码！",{icon:2});
                return false;
            }
            if (data.databaseTypeName != "SAP HANA") {
                if (data.databaseName == "") {
                    $Utils.loading.close();
                    layer.msg("请输入数据库名称！", { icon: 2 });
                    return false;
                }
            }
            return true
        }
        if(data.databaseName == ""){
            $Utils.loading.close();
            layer.msg("请输入数据库名称！",{icon:2});
            return false;
        }
        return true;
    }

    function changed(data){
        if(mDatabaseLink.dataSourceName != data.field.dataSourceName){
            return true
        }
        if(mDatabaseLink.databaseTypeName != data.field.databaseTypeName){
            return true
        }
        if(mDatabaseLink.serviceType != data.field.serviceType){
            return true
        }
        if(mDatabaseLink.serviceType == 0){
            if(mDatabaseLink.databaseIP != data.field.databaseIP){
                return true
            }
            if(mDatabaseLink.databasePort != data.field.databasePort){
                return true
            }
            if(mDatabaseLink.userName != data.field.userName){
                return true
            }
            if(mDatabaseLink.password != data.field.password){
                return true
            }
            if(mDatabaseLink.databaseName != data.field.databaseName){
                return true
            }
        }else{
            if(mDatabaseLink.getTablesInterface != data.field.getTablesInterface){
                return true
            }
            if(mDatabaseLink.getFieldsInterface != data.field.getFieldsInterface){
                return true
            }
            if(mDatabaseLink.executeSqlInterface != data.field.executeSqlInterface){
                return true
            }
        }
        
        return false;
    }

}();