function DataSource(){
    this.dataSourceID = null;
    this.dataSourceName = null;
    this.dataSourceType = null;

    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function DataSources(){
    var me = this;
    this.count = 0;
    this.aryDataSources = [];
    this.dicDataSources = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryDataSources[indexOrKey];
        }else{
            return this.dicDataSources[indexOrKey];
        }
    };
    this.add = function (dataSource) {
        this.aryDataSources.push(dataSource);
        this.dicDataSources[dataSource.dataSourceID] = dataSource;
        this.count = this.aryDataSources.length;
    };
    this.remove = function (dataSource) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryDataSources[i].dataSourceID==dataSource.dataSourceID){
                k = i;
                break;
            }
        }
        this.aryDataSources.splice(k,1);
        delete this.dicDataSources[dataSource.dataSourceID];
        this.count = this.aryDataSources.length;
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.dataSourcePath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setDataSources(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setDataSources(data){
        me.count = 0;
        me.aryDataSources = [];
        me.dicDataSources = {};
        for(var i = 0; i < data.length; i++){
            var dataSource = new DataSource();
            dataSource.init(data[i]);
            me.add(dataSource);
        }
    }
}

function DatabaseLink(){
    var me = this;
    DataSource.call(this);
    this.databaseIP = null;
    this.databasePort = null;
    this.userName = null;
    this.password = null;

    this.serviceType = null;

    this.databaseTypeName = null;
    this.databaseName = null;

    this.getTablesInterface = null;
    this.getFieldsInterface = null;
    this.executeSqlInterface = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };

    this.executeSQL = function(sqlText,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + this.dataSourceID + "/SQLs";
        var obj = {
            sql: sqlText
        };
        obj = JSON.stringify(obj);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getBusinessData = function(sqlText,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + this.dataSourceID + "/sql/businessData?valueAsString=1&recordCount=200";
        var obj = {
            sql: sqlText
        };
        obj = JSON.stringify(obj);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getDatabaseNames =  function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/databaseNames?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.testConnections = function(parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/connections?"+parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.initByID = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/"+dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getStoredProcedures = function (asyncOrSync, succ, fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + this.dataSourceID + "/storedProcedures";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}

function DatabaseLinks(){
    var me = this;
    this.count = 0;
    this.aryDatabaseLinks = [];
    this.dicDatabaseLinks = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryDatabaseLinks[indexOrKey];
        }else{
            return this.dicDatabaseLinks[indexOrKey];
        }
    };
    this.add = function (databaseLink) {
        this.aryDatabaseLinks.push(databaseLink);
        this.dicDatabaseLinks[databaseLink.dataSourceID] = databaseLink;
        this.count = this.aryDatabaseLinks.length;
    };
    this.remove = function (databaseLink) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryDatabaseLinks[i].dataSourceID==databaseLink.dataSourceID){
                k = i;
                break;
            }
        }
        this.aryDatabaseLinks.splice(k,1);
        delete this.dicDatabaseLinks[databaseLink.dataSourceID];
        this.count = this.aryDatabaseLinks.length;
    };
    this.addItem = function(databaselink,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath;
        var obj = JSON.stringify(databaselink);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(databaseLink,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + databaseLink.dataSourceID;
        var obj = JSON.stringify(databaseLink);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(databaseLink.dataSourceID).dataSourceName = databaseLink.dataSourceName;
                me.item(databaseLink.dataSourceID).databaseTypeName = databaseLink.databaseTypeName;
                me.item(databaseLink.dataSourceID).databaseTypeVersion = databaseLink.databaseTypeVersion;
                me.item(databaseLink.dataSourceID).serviceType = databaseLink.serviceType;
                if(databaseLink.serviceType == 0){
                    me.item(databaseLink.dataSourceID).databaseIP = databaseLink.databaseIP;
                    me.item(databaseLink.dataSourceID).databasePort = databaseLink.databasePort;
                    me.item(databaseLink.dataSourceID).userName = databaseLink.userName;
                    me.item(databaseLink.dataSourceID).password = databaseLink.password;
                    me.item(databaseLink.dataSourceID).databaseName = databaseLink.databaseName;
                }
                if(databaseLink.serviceType == 1){
                    me.item(databaseLink.dataSourceID).getTablesInterface = databaseLink.getTablesInterface;
                    me.item(databaseLink.dataSourceID).getFieldsInterface = databaseLink.getFieldsInterface;
                    me.item(databaseLink.dataSourceID).executeSqlInterface = databaseLink.executeSqlInterface;
                }
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + dataSourceID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                // if(me.item(dataSourceID)){
                //     me.remove(me.item(dataSourceID));
                // }
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setDatabaseLinks(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setDatabaseLinks(data){
        me.count = 0;
        me.aryDatabaseLinks = [];
        me.dicDatabaseLinks = {};
        for(var i = 0; i < data.length; i++){
            var databaseLink = new DatabaseLink();
            databaseLink.init(data[i]);
            me.add(databaseLink);
        }
    }
}

function DatabaseType(){
    this.databaseTypeID = null;
    this.databaseTypeName = null;
    this.databaseTypeVersion = null;

    this.init = function(options,index){
        for(var key in options){
            if(key == "databaseTypeID"){
                this[key] = index;
            }else{
                this[key] = options[key];
            }
        }
    }
}

function DatabaseTypes(){
    var me = this;
    this.count = 0;
    this.aryDatabaseTypes = [];
    this.dicDatabaseTypes = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryDatabaseTypes[indexOrKey];
        }else{
            return this.dicDatabaseTypes[indexOrKey];
        }
    };
    this.add = function (databaseType) {
        this.aryDatabaseTypes.push(databaseType);
        this.dicDatabaseTypes[databaseType.databaseTypeID] = databaseType;
        this.count = this.aryDatabaseTypes.length;
    };
    this.remove = function (databaseType) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryDatabaseTypes[i].databaseTypeID==databaseType.databaseTypeID){
                k = i;
                break;
            }
        }
        this.aryDatabaseTypes.splice(k,1);
        delete this.dicDatabaseTypes[databaseType.databaseTypeID];
        this.count = this.aryDatabaseTypes.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseTypePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setDatabaseLinks(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setDatabaseLinks(data){
        me.count = 0;
        me.aryDatabaseLinks = [];
        me.dicDatabaseLinks = {};
        for(var i = 0; i < data.length; i++){
            var databaseType = new DatabaseType();
            databaseType.init(data[i],i);
            me.add(databaseType);
        }
    }
}

function ExcelFile(){
    var me = this;
    
    DataSource.call(this);
    this.excelFileName = null;
    this.sheetName = null;
    this.rangeType = null;
    this.range = null;
    this.columns = null;
    this.custom = false;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };

    this.getItemByDataSourceID = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getExcelSheetData = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + this.dataSourceID + "/businessData?recordCount=200&formatDate=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.download = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID + "/file";
        var obj = "";
        var dataType = 'blob';
        var succCallback = function(data){
            succ(data);
        }
        var failCallback = function (status,statusText) {
            
            if(status == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(statusText == "timeout"){
                fail("请求超时。");
            }else if(status || status == 0){
                fail(status,statusText);
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.downLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function ExcelFiles(){
    var me = this;
    this.count = 0;
    this.aryExcelFiles = [];
    this.dicExcelFiles = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryExcelFiles[indexOrKey];
        }else{
            return this.dicExcelFiles[indexOrKey];
        }
    };
    this.add = function (excelFile) {
        this.aryExcelFiles.push(excelFile);
        this.dicExcelFiles[excelFile.dataSourceID] = excelFile;
        this.count = this.aryExcelFiles.length;
    };
    this.remove = function (excelFile) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryExcelFiles[i].dataSourceID==excelFile.dataSourceID){
                k = i;
                break;
            }
        }
        this.aryExcelFiles.splice(k,1);
        delete this.dicExcelFiles[excelFile.dataSourceID];
        this.count = this.aryExcelFiles.length;
    };
    this.addItem = function(excelFile,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath;
        var obj = JSON.stringify(excelFile);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var dataSourceID = request.getResponseHeader('location').split('/excelFiles/')[1];
                succ(dataSourceID);
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addExcel = function(excel,dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID + "/file";
        var obj = excel;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setExcelFiles(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/" + dataSourceID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                // if(me.item(dataSourceID)){
                //     me.remove(me.item(dataSourceID));
                // }
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.isExist = function(excelFileName,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelFilePath + "/excelFileNames?excelFileName="+encodeURIComponent(excelFileName);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ(request.status);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(XHR.status == 404){
                    succ(404);
                }else{
                    if(!$Utils.request.isJson(XHR.responseText)){
                        fail(XHR.status,XHR.responseText);
                    }else{
                        fail(XHR.status,JSON.parse(XHR.responseText).error);
                    }
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setExcelFiles(data){
        me.count = 0;
        me.aryExcelFiles = [];
        me.dicExcelFiles = {};
        for(var i = 0; i < data.length; i++){
            var excelFile = new ExcelFile();
            excelFile.init(data[i]);
            me.add(excelFile);
        }
    }
}

function BDAColumn(){
    this.columnName = null;
    this.valueRange = null;
    this.dataType = 0;
    this.custom = false;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Table(){
    var me = this;
    this.tableName = null;
    this.tableType = null;
    this.schemaName = null;
    this.tableFields = new TableFields();

    this.initByTableName = function(tables,dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + dataSourceID + "/tables/fields";
        var obj = JSON.stringify(tables);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.items[0]);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getBusinessDataByTableName = function (dataSourceID, tableName, schemaName,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + dataSourceID + "/tables/table/businessData?recordCount=200&tableName=" + encodeURIComponent(tableName) + "&schemaName=" + encodeURIComponent(schemaName);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            if(key == "tableFields"){
                this[key].setTableFields(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };

}

function Tables(){
    var me = this;
    this.count = 0;
    this.aryTables = [];
    this.dicTables = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTables[indexOrKey];
        }else{
            return this.dicTables[indexOrKey];
        }
    };
    this.add = function (table) {
        this.aryTables.push(table);
        this.dicTables[table.tableName] = table;
        this.count = this.aryTables.length;
    };
    this.remove = function (table) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTables[i].tableName==table.tableName){
                k = i;
                break;
            }
        }
        this.aryTables.splice(k,1);
        delete this.dicTables[table.tableName];
        this.count = this.aryTables.length;
    };
    this.getItems = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.databaseLinkPath + "/" + dataSourceID + "/tables";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setTables(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setTables(data){
        me.count = 0;
        me.aryTables = [];
        me.dicTables = {};
        for(var i = 0; i < data.length; i++){
            var table = new Table();
            table.init(data[i]);
            me.add(table);
        }
    }
}

function TableField(){
    this.fieldName = null;
    this.dataType = null;
    this.visible = null;
    this.comment = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function TableFields(){
    var me = this;
    this.count = 0;
    this.aryTableFields = [];
    this.dicTableFields = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableFields[indexOrKey];
        }else{
            return this.dicTableFields[indexOrKey];
        }
    };
    this.add = function (tableField) {
        this.aryTableFields.push(tableField);
        this.dicTableFields[tableField.fieldName] = tableField;
        this.count = this.aryTableFields.length;
    };
    this.remove = function (tableField) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableFields[i].fieldName==tableField.fieldName){
                k = i;
                break;
            }
        }
        this.aryTableFields.splice(k,1);
        delete this.dicTableFields[tableField.fieldName];
        this.count = this.aryTableFields.length;
    };
    this.setTableFields = function(data){
        this.count = 0;
        this.aryTableFields = [];
        this.dicTableFields = {};
        for(var i = 0; i < data.length; i++){
            var tableField = new TableField();
            tableField.init(data[i]);
            this.add(tableField);
        }
    };
}