!function(){
    var $ = layui.jquery, layer = layui.layer;
    var menus = new Menus();

    // $Utils.loading.open();
    initBusinessModel();

    function initBusinessModel(){
        loadModuleTitle();
        getAndLoadBusinessModelMenus();

        $(".left-menu-cnt .menu-list > ul").on("click","div",function(){
            $(".left-menu-cnt .menu-list > ul").find(".select-menu").removeClass("select-menu");
            if($(this).parent("li").hasClass("folder")){
                if($(this).siblings("ul").is(":hidden")){
                    $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
                    $(this).siblings("ul").show(200);
                    $(this).parents("li").addClass("select-menu");
                }else{
                    $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                    $(this).siblings("ul").hide(200);
                    // $(this).parent("li").removeClass("select-folder");
                    $(this).parents("li").addClass("select-menu");
                }
            }else{
                if(!$(this).parent("li").hasClass("select-menu")){
                    // $(this).parents(".menu-list").find("li").removeClass("select-menu");
                    $(this).parents("li").addClass("select-menu");
                    loadMenuList($(this).parent("li").attr("data-menucode"));
                    setBread(this);
                }
            }
        });
    }

    function loadModuleTitle(){
        var nameCn = "业务建模";
        var nameOther = "iBM";
        $(".module-title p").html("<span class='module-name'>"+nameCn+"</span> / <span class='module-name-other-language'>"+nameOther+"</span>");
    }

    function setBread(elem){
        var folderNameArr = [];
        folderNameArr.push($(elem).text());
        getFolderNameByDomTree($(elem).parent(),folderNameArr);
        var str = "<span>业务建模</span>";
        for(var i = folderNameArr.length-1; i >= 0; i--){
            str += "<span><i class='iconfont bda-bread'></i>"+folderNameArr[i]+"</span>"
        }
        $(".bread").html(str);
    }

    function getFolderNameByDomTree(elem,folderNameArr){
        if(elem.parent()[0].tagName == "UL" && elem.parent().siblings("div").length){
            folderNameArr.push(elem.parent().siblings("div").text());
            getFolderNameByDomTree(elem.parent().parent(),folderNameArr);
        }
    }

    function getAndLoadBusinessModelMenus(){
        var succ = function(){
            $Utils.loading.close();
			loadMenus();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务建模菜单",errorStatus,msg);
		};
		menus.getItems(2,true,succ,fail);
    }

    function loadMenus(){
        $(".menu-list > ul").html("");
        var str = "";
        for(var i = 0; i < menus.count; i++){
            // if (menus.item(i).menuCode == 22005){ continue;}
            if(menus.item(i).menuParentID == -1){
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-"+(menus.item(i).menuCode==21000?"dataBase":"moxing")+"'></i>"+menus.item(i).menuName+"<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+">"+menus.item(i).menuName+"</div></li>";
                }
                $(".menu-list > ul").append(str);
            }else{
                if(menus.item(i).lastLevel == false){
                    str = "<li class='folder folder-hide' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+"><i class='iconfont bda-wenjianjia'></i>"+menus.item(i).menuName+"<i class='fr iconfont bda-xiangyou'></i></div><ul></ul></li>"
                }else{
                    str = "<li class='report' data-menuid="+menus.item(i).menuID+" data-menucode="+menus.item(i).menuCode+"><div title="+menus.item(i).menuName+">"+menus.item(i).menuName+"</div></li>";
                }
                $(".menu-list > ul").find("li").each(function(){
                    if($(this).attr("data-menuid") == menus.item(i).menuParentID){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
        $(".menu-list > ul > li:first-child > div").trigger("click");
        $(".menu-list > ul > li:first-child ul li:first-child div").trigger("click");
    }

    function loadMenuList(menuCode){
        switch(Number(menuCode)){
            case 21001:
                getListHtml("html/iBusinessModel/dataSource/databaseLinks.html");
                break;
            case 21002:
                getListHtml("html/iBusinessModel/dataSource/excels.html");
                break;
            case 22001:
                getListHtml("html/iBusinessModel/businessModel/relationModel/relationModels.html");
                break;
            case 22002:
                getListHtml("html/iBusinessModel/businessModel/tableModel/tableModels.html");
                break;
            case 22003:
                getListHtml("html/iBusinessModel/businessModel/sqlModel/sqlModels.html");
                break;
            case 22004:
                getListHtml("html/iBusinessModel/businessModel/excelModel/excelModels.html");
                break;
            case 22005:
                getListHtml("html/iBusinessModel/businessModel/storedProcedureModel/storedProcedureModels.html");
                break;
        }
    }

    function getListHtml(url){
        $.ajax({
            url: url,
            type: 'GET',
            success: function(data){
                $(".main-content").html("");
                $(".main-content").html(data);
            }
        });
    }

}();